/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.TransactionalHeap;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AbstractTransactionalMemoryBlock
extends AnyMemoryBlock {
    private static final long METADATA_SIZE = 8L;

    AbstractTransactionalMemoryBlock(TransactionalHeap heap, long size, boolean bounded) {
        super(heap, size, bounded, true);
    }

    AbstractTransactionalMemoryBlock(TransactionalHeap heap, long poolHandle, long offset, boolean bounded) {
        super(heap, offset, bounded);
    }

    @Override
    public TransactionalHeap heap() {
        return (TransactionalHeap)super.heapInternal();
    }

    @Override
    abstract long metadataSize();

    public void free() {
        this.heap().freeMemoryBlock(this, true);
    }

    @Override
    public void freeMemory() {
        this.free();
    }

    @Override
    public void setByte(long offset, byte value) {
        super.transactionalSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.transactionalSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.transactionalSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.transactionalSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        super.transactionalCopy(srcAccessor, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcIndex, long dstOffset, int length) {
        super.transactionalCopyFromArray(srcArray, srcIndex, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.transactionalSetMemory(value, offset, length);
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.transactionalWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.transactionalWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }
}

