/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyAccessor;
import com.intel.pmem.llpl.Heap;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.Range;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Accessor
extends AnyAccessor {
    static final long METADATA_SIZE = 8L;

    Accessor(Heap heap) {
        super(heap);
    }

    @Override
    public Heap heap() {
        return (Heap)super.heapInternal();
    }

    @Override
    public void setByte(long offset, byte value) {
        super.rawSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.rawSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.rawSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.rawSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        super.rawCopy(srcAccessor, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        super.rawCopyFromArray(srcArray, srcOffset, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.rawSetMemory(value, offset, length);
    }

    @Override
    public void flush(long offset, long length) {
        super.flush(offset, length);
    }

    public void flush() {
        super.flush(0L, this.size());
    }

    @Override
    public void addToTransaction(long offset, long length) {
        super.addToTransaction(offset, length);
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.rawWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.rawWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }

    public void withRange(Consumer<Range> op) {
        this.withRange(0L, this.size(), op);
    }

    public void freeMemory(boolean transactional) {
        this.checkValid();
        this.heap().freeMemory(this.directAddress(), transactional);
        super.reset();
    }

    @Override
    public void freeMemory() {
        this.freeMemory(false);
    }

    @Override
    long metadataSize() {
        return 8L;
    }

    public void addToTransaction() {
        super.addToTransaction(0L, this.size());
    }

    @Override
    public long size() {
        return super.size();
    }

    @Override
    public void handle(long handle) {
        this.heap().checkBounds(handle, 8L);
        super.handle(handle, true);
    }

    @Override
    public void resetHandle() {
        super.reset();
    }
}

