/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyAccessor;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.Heap;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.PersistentHeap;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.TransactionalHeap;
import com.intel.pmem.llpl.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import sun.misc.Unsafe;

public abstract class AnyHeap {
    private static final int TOTAL_ALLOCATION_CLASSES = 40;
    private static final int USER_CLASS_INDEX = 15;
    private static final int MAX_USER_CLASSES = 12;
    static Unsafe UNSAFE;
    private static final Map<String, AnyHeap> heaps;
    private static final long HEAP_VERSION = 1200L;
    private static final long MIN_HEAP_VERSION = 900L;
    public static final long MINIMUM_HEAP_SIZE;
    private boolean open;
    private final String path;
    private boolean valid;
    private final long poolHandle;
    private long size;
    private SortedMap<Long, Integer> userSizes;
    private long[] allocationClasses;
    private Metadata metadata;
    static final String POOL_SET_FILE = "myobjpool.set";

    AnyHeap(String path, long requestedSize) {
        this.path = path;
        this.userSizes = new TreeMap<Long, Integer>();
        this.allocationClasses = new long[40];
        this.poolHandle = AnyHeap.nativeCreateHeap(path, requestedSize, this.allocationClasses, this.getHeapLayoutID());
        if (this.poolHandle == 0L) {
            throw new HeapException("Failed to create heap.");
        }
        this.valid = true;
        this.size = AnyHeap.nativeProbeHeapSize(this.poolHandle, this.size);
        this.metadata = Metadata.create(this);
        this.open = true;
    }

    AnyHeap(String path) {
        this.path = path;
        this.userSizes = new TreeMap<Long, Integer>();
        this.allocationClasses = new long[40];
        this.poolHandle = AnyHeap.nativeOpenHeap(path, this.allocationClasses, this.getHeapLayoutID());
        if (this.poolHandle == 0L) {
            throw new HeapException("Failed to open heap.");
        }
        this.valid = true;
        this.size = AnyHeap.nativeProbeHeapSize(this.poolHandle, this.size);
        this.metadata = Metadata.open(this);
        long currentVersion = this.metadata.getVersion();
        if (currentVersion < 900L || currentVersion > 1200L) {
            throw new HeapException("Failed to open heap. Incompatible heap version.");
        }
        this.open = true;
    }

    static boolean getHeap(String path) {
        return heaps.containsKey(path);
    }

    static AnyHeap getHeap(String path, Class cls) {
        AnyHeap h = heaps.get(path);
        try {
            cls.cast(h);
        }
        catch (ClassCastException e) {
            throw new HeapException("Failed to open heap. wrong heap type (wrong layout)");
        }
        return h;
    }

    static Class getHeapClass(String heapName) {
        Class cls = null;
        if (heapName.equals("Heap")) {
            cls = Heap.class;
        } else if (heapName.equals("PersistentHeap")) {
            cls = PersistentHeap.class;
        } else if (heapName.equals("TransactionalHeap")) {
            cls = TransactionalHeap.class;
        }
        return cls;
    }

    static void putHeap(String path, AnyHeap heap) {
        heaps.put(path, heap);
    }

    void close() {
        AnyHeap.nativeCloseHeap(this.poolHandle);
        heaps.remove(this.path);
        AnyHeap.markInvalid(this);
    }

    public synchronized boolean registerAllocationSize(long size, boolean compact) {
        if (this.userSizes.size() == 12) {
            throw new HeapException("Max number of allocation sizes reached.");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException();
        }
        long effectiveSize = size + (compact ? 0L : 8L);
        if (!this.userSizes.containsKey(effectiveSize)) {
            int id = AnyHeap.nativeRegisterAllocationClass(this.poolHandle, effectiveSize);
            if (id != -1) {
                int i = 15 + this.userSizes.size() * 2;
                this.userSizes.put(effectiveSize, id);
                this.allocationClasses[i++] = effectiveSize;
                this.allocationClasses[i] = id;
                return true;
            }
            return false;
        }
        return true;
    }

    static synchronized boolean deleteHeap(String path) {
        boolean result = false;
        if (AnyHeap.exists(path)) {
            AnyHeap heap = heaps.get(path);
            if (heap != null) {
                AnyHeap.markInvalid(heap);
            }
            heaps.remove(path);
            result = new File(path).delete();
        }
        return result;
    }

    static synchronized void markInvalid(AnyHeap heap) {
        heap.valid = false;
    }

    public static synchronized boolean exists(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (AnyHeap.getHeap(path)) {
            return true;
        }
        if (path.startsWith("/dev/dax")) {
            int flag = AnyHeap.nativeHeapExists(path);
            return flag == 1;
        }
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return true;
        }
        return file.exists() && file.isDirectory() && new File(path, POOL_SET_FILE).exists();
    }

    public long size() {
        return this.size;
    }

    public abstract void execute(Runnable var1);

    public abstract <T> T execute(Supplier<T> var1);

    void checkBounds(long handle) {
        this.checkBounds(handle, 0L);
    }

    void checkBounds(long handle, long length) {
        if (handle <= 0L || this.outOfBounds(handle + length)) {
            throw new IllegalArgumentException("Handle is invalid for this heap");
        }
    }

    boolean isInBounds(long handle, long length) {
        return handle > 0L && !this.outOfBounds(handle + length);
    }

    public long getRoot() {
        return this.metadata.getUserRoot();
    }

    public void setRoot(long value) {
        this.metadata.setUserRoot(value);
    }

    public abstract long allocateMemory(long var1);

    public abstract long allocateCompactMemory(long var1);

    public abstract AnyMemoryBlock allocateMemoryBlock(long var1);

    public abstract AnyMemoryBlock allocateCompactMemoryBlock(long var1);

    public abstract AnyMemoryBlock allocateMemoryBlock(long var1, Consumer<Range> var3);

    public abstract AnyMemoryBlock allocateCompactMemoryBlock(long var1, Consumer<Range> var3);

    public abstract AnyAccessor createAccessor();

    public abstract AnyAccessor createCompactAccessor();

    public abstract AnyMemoryBlock memoryBlockFromHandle(long var1);

    public abstract AnyMemoryBlock compactMemoryBlockFromHandle(long var1);

    abstract String getHeapLayoutID();

    abstract AnyMemoryBlock internalMemoryBlockFromHandle(long var1);

    void freeMemory(long directAddress, boolean transactional) {
        int result;
        int n = result = transactional ? AnyHeap.nativeFree(this.poolHandle, directAddress) : AnyHeap.nativeFreeAtomic(directAddress);
        if (result < 0) {
            throw new HeapException("Failed to free memory.");
        }
    }

    void freeMemoryBlock(AnyMemoryBlock block, boolean transactional) {
        block.checkValid();
        this.freeMemory(block.directAddress(), transactional);
        block.markInvalid();
    }

    long poolHandle() {
        return this.poolHandle;
    }

    long allocateTransactional(long size) {
        return AnyHeap.nativeAllocateTransactional(this.poolHandle, size, this.getAllocationClassIndex(size));
    }

    long allocateAtomic(long size) {
        return AnyHeap.nativeAllocateAtomic(this.poolHandle, size, this.getAllocationClassIndex(size));
    }

    int getAllocationClassIndex(long size) {
        long custom_unit_size = 0L;
        int custom_id = 0;
        for (Map.Entry<Long, Integer> e : this.userSizes.entrySet()) {
            custom_unit_size = e.getKey();
            custom_id = e.getValue();
            if (custom_unit_size == size) {
                return custom_id;
            }
            if (custom_unit_size <= size) continue;
            break;
        }
        if (size >= 128L) {
            return 0;
        }
        int closest_builtin_size = 128;
        int builtin_id = 0;
        for (int j = 14; j >= 0 && (long)(8 * (j + 1)) >= size; --j) {
            if (this.allocationClasses[j] == 0L) continue;
            closest_builtin_size = 8 * (j + 1);
            builtin_id = (int)this.allocationClasses[j];
            if ((long)closest_builtin_size != size) continue;
            return builtin_id;
        }
        if (custom_unit_size > 0L && (long)closest_builtin_size > custom_unit_size) {
            return custom_id;
        }
        return builtin_id;
    }

    static void createPoolSetFile(File file, long size) throws IOException {
        long capacity;
        File poolFile = new File(file, POOL_SET_FILE);
        long l = capacity = size == 0L ? file.getTotalSpace() : size;
        if (capacity < MINIMUM_HEAP_SIZE) {
            throw new HeapException("The partition \"" + file.getAbsolutePath() + "\" must have at least " + MINIMUM_HEAP_SIZE + " bytes");
        }
        Charset charset = Charset.forName("US-ASCII");
        StringBuffer sb = new StringBuffer();
        sb.append("PMEMPOOLSET\nOPTION SINGLEHDR\n" + capacity + " " + file.getAbsolutePath() + "\n");
        if (!poolFile.createNewFile()) {
            throw new HeapException("Heap \"" + file.getAbsolutePath() + "\" already exists");
        }
        BufferedWriter writer = Files.newBufferedWriter(poolFile.toPath(), charset, new OpenOption[0]);
        writer.write(sb.toString(), 0, sb.toString().length());
        writer.close();
    }

    boolean outOfBounds(long offset) {
        if (offset < 0L) {
            return true;
        }
        if (offset >= this.size) {
            this.size = AnyHeap.nativeProbeHeapSize(this.poolHandle, this.size);
            if (offset >= this.size) {
                return true;
            }
        }
        return false;
    }

    static long getUsableSize(MemoryAccessor mb) {
        return AnyHeap.nativeUsableSize(mb.directAddress());
    }

    static int removePool(String path) {
        return AnyHeap.nativeRemovePool(path);
    }

    private static native long nativeAllocateTransactional(long var0, long var2, int var4);

    private static native long nativeAllocateAtomic(long var0, long var2, int var4);

    private static native int nativeFree(long var0, long var2);

    private static native int nativeFreeAtomic(long var0);

    private static synchronized native long nativeCreateHeap(String var0, long var1, long[] var3, String var4);

    private static synchronized native long nativeOpenHeap(String var0, long[] var1, String var2);

    private static synchronized native int nativeRegisterAllocationClass(long var0, long var2);

    private static synchronized native void nativeCloseHeap(long var0);

    private static synchronized native long nativeGetRoot(long var0);

    private static native long nativeUsableSize(long var0);

    private static native long nativeDirectAddress(long var0, long var2);

    static native int nativeHeapExists(String var0);

    private static native long nativeHeapSize(String var0);

    private static native int nativeRemovePool(String var0);

    private static native long nativeProbeHeapSize(long var0, long var2);

    private static native long nativeMinHeapSize();

    static {
        heaps = new ConcurrentHashMap<String, AnyHeap>();
        Util.loadLibrary();
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize UNSAFE.");
        }
        MINIMUM_HEAP_SIZE = AnyHeap.nativeMinHeapSize();
    }

    static class Metadata {
        static final long METADATA_SIZE = 64L;
        private static final long USER_ROOT_OFFSET = 0L;
        private static final long HEAP_VERSION_OFFSET = 8L;
        private AnyMemoryBlock metaBlock;

        private Metadata(AnyHeap heap) {
            long metadataHandle = AnyHeap.nativeGetRoot(heap.poolHandle());
            this.metaBlock = heap.internalMemoryBlockFromHandle(metadataHandle);
        }

        static Metadata create(AnyHeap heap) {
            Metadata m = new Metadata(heap);
            m.metaBlock.transactionalSetLong(8L, 1200L);
            return m;
        }

        static Metadata open(AnyHeap heap) {
            return new Metadata(heap);
        }

        public long getUserRoot() {
            return this.metaBlock.getLong(0L);
        }

        public void setUserRoot(long value) {
            this.metaBlock.transactionalSetLong(0L, value);
        }

        public long getVersion() {
            return this.metaBlock.getLong(8L);
        }
    }
}

