/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.Accessor;
import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.CompactAccessor;
import com.intel.pmem.llpl.CompactMemoryBlock;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.MemoryBlock;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Heap
extends AnyHeap {
    static final String HEAP_LAYOUT_ID = "llpl_heap";

    private Heap(String path, long size) {
        super(path, size);
    }

    private Heap(String path) {
        super(path);
    }

    public static synchronized Heap createHeap(String path) {
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (path.startsWith("/dev/dax")) {
            heapPath = path;
        } else {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) {
                throw new HeapException("The path \"" + path + "\" doesnt exist or is not a directory");
            }
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, 0L);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists.");
        }
        Heap heap = new Heap(heapPath, 0L);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Heap createHeap(String path, long size) {
        long heapSize;
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null.");
        }
        if (path.startsWith("/dev/dax")) {
            throw new IllegalArgumentException("The path is invalid for this method");
        }
        if (size != 0L && size < MINIMUM_HEAP_SIZE) {
            throw new HeapException("The Heap size must be at least " + MINIMUM_HEAP_SIZE + " bytes.");
        }
        File file = new File(path);
        if (size == 0L) {
            if (!file.exists() || !file.isFile()) throw new HeapException("The path \"" + path + "\" does not exist or is not a file.");
            heapPath = path;
            heapSize = size;
        } else if (file.exists() && file.isDirectory()) {
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, size);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
            heapSize = 0L;
        } else {
            if (file.exists()) {
                throw new HeapException("Heap \"" + path + "\" already exists.");
            }
            heapPath = path;
            heapSize = size;
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists.");
        }
        Heap heap = new Heap(heapPath, heapSize);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    public static synchronized Heap openHeap(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null.");
        }
        Heap heap = (Heap)AnyHeap.getHeap(path, Heap.getHeapClass("Heap"));
        String heapPath = path;
        if (heap == null) {
            File file = new File(path);
            if (file.exists() && file.isDirectory() && (heap = (Heap)AnyHeap.getHeap(heapPath = new File(file, "myobjpool.set").getAbsolutePath(), Heap.getHeapClass("Heap"))) != null) {
                return heap;
            }
            heap = new Heap(heapPath);
            AnyHeap.putHeap(heapPath, heap);
        }
        return heap;
    }

    @Override
    public Accessor createAccessor() {
        return new Accessor(this);
    }

    @Override
    public CompactAccessor createCompactAccessor() {
        return new CompactAccessor(this);
    }

    public long allocateMemory(long size, boolean transactional) {
        long allocationSize = size + 8L;
        Supplier<Long> body = () -> {
            long handle;
            long l = handle = transactional ? this.allocateTransactional(allocationSize) : this.allocateAtomic(allocationSize);
            if (handle == 0L) {
                throw new HeapException("Failed to allocate memory of size " + size);
            }
            long address = this.poolHandle() + handle + 0L;
            AnyHeap.UNSAFE.putLong(address, size);
            if (!transactional) {
                MemoryAccessor.nativeFlush(address, 8L);
            }
            return handle;
        };
        long handle = transactional ? new Transaction(this).run(body).longValue() : body.get().longValue();
        return handle;
    }

    @Override
    public long allocateMemory(long size) {
        return this.allocateMemory(size, false);
    }

    public long allocateCompactMemory(long size, boolean transactional) {
        long handle;
        long l = handle = transactional ? Transaction.create((AnyHeap)this, () -> this.allocateTransactional(size)).longValue() : this.allocateAtomic(size);
        if (handle == 0L) {
            throw new HeapException("Failed to allocate memory of size " + size);
        }
        return handle;
    }

    @Override
    public long allocateCompactMemory(long size) {
        return this.allocateCompactMemory(size, false);
    }

    public MemoryBlock allocateMemoryBlock(long size, boolean transactional) {
        return new MemoryBlock(this, size, transactional);
    }

    @Override
    public MemoryBlock allocateMemoryBlock(long size) {
        return new MemoryBlock(this, size, false);
    }

    @Override
    public MemoryBlock allocateMemoryBlock(long size, Consumer<Range> initializer) {
        return this.allocateMemoryBlock(size, false, initializer);
    }

    public MemoryBlock allocateMemoryBlock(long size, boolean transactional, Consumer<Range> initializer) {
        MemoryBlock block = new MemoryBlock(this, size, transactional);
        Range range = block.range();
        initializer.accept(range);
        range.markInvalid();
        return block;
    }

    @Override
    public CompactMemoryBlock allocateCompactMemoryBlock(long size, Consumer<Range> initializer) {
        return this.allocateCompactMemoryBlock(size, false, initializer);
    }

    public CompactMemoryBlock allocateCompactMemoryBlock(long size, boolean transactional, Consumer<Range> initializer) {
        CompactMemoryBlock block = new CompactMemoryBlock(this, size, transactional);
        Range range = block.range(0L, size);
        initializer.accept(range);
        range.markInvalid();
        return block;
    }

    public CompactMemoryBlock allocateCompactMemoryBlock(long size, boolean transactional) {
        return new CompactMemoryBlock(this, size, transactional);
    }

    @Override
    public CompactMemoryBlock allocateCompactMemoryBlock(long size) {
        return new CompactMemoryBlock(this, size, false);
    }

    @Override
    public MemoryBlock memoryBlockFromHandle(long handle) {
        this.checkBounds(handle, 8L);
        return new MemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    public void execute(Runnable op) {
        op.run();
    }

    @Override
    public <T> T execute(Supplier<T> op) {
        return op.get();
    }

    @Override
    CompactMemoryBlock internalMemoryBlockFromHandle(long handle) {
        return new CompactMemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    String getHeapLayoutID() {
        return HEAP_LAYOUT_ID;
    }

    @Override
    public CompactMemoryBlock compactMemoryBlockFromHandle(long handle) {
        this.checkBounds(handle);
        return new CompactMemoryBlock(this, this.poolHandle(), handle);
    }
}

