/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.Transaction;
import com.intel.pmem.llpl.TransactionException;
import com.intel.pmem.llpl.Util;
import java.util.function.Consumer;
import java.util.function.Function;
import sun.misc.Unsafe;

public abstract class MemoryAccessor {
    private static boolean ELIDE_FLUSHES = false;
    static final long SIZE_OFFSET = 0L;
    final AnyHeap heap;
    private long size;
    private long address;
    private long directAddress;

    MemoryAccessor(AnyHeap heap, long size, boolean bounded, boolean transactional) {
        if (size <= 0L) {
            throw new HeapException("Failed to allocate memory of size " + size);
        }
        this.heap = heap;
        long allocSize = size + this.metadataSize();
        Runnable body = () -> {
            long l = this.address = transactional ? heap.allocateTransactional(allocSize) : heap.allocateAtomic(allocSize);
            if (this.address == 0L) {
                throw new HeapException("Failed to allocate memory of size " + size);
            }
            this.directAddress = this.directAddress(heap, this.address);
            if (bounded) {
                long address = this.directAddress + 0L;
                AnyHeap.UNSAFE.putLong(address, size);
                if (!transactional) {
                    MemoryAccessor.nativeFlush(address, 8L);
                }
                this.size = size;
            } else {
                this.size = -1L;
            }
        };
        if (transactional) {
            new Transaction(heap).run(body);
        } else {
            body.run();
        }
    }

    MemoryAccessor(AnyHeap heap, long offset, boolean bounded) {
        this.heap = heap;
        this.handle(offset, bounded);
    }

    MemoryAccessor(AnyHeap heap) {
        this.heap = heap;
        this.address = 0L;
        this.directAddress = 0L;
    }

    void reset() {
        this.address = 0L;
        this.directAddress = 0L;
        this.size = 0L;
    }

    void handle(long offset, boolean bounded) {
        this.address = offset;
        this.directAddress = this.heap.poolHandle() + this.address;
        long l = this.size = bounded ? this.getPersistentSize() : -1L;
        if (bounded && (this.size <= 0L || !this.heap.isInBounds(offset + this.size, 0L))) {
            throw new HeapException("Failed to update accessor with supplied handle");
        }
    }

    long directAddress(AnyHeap heap, long offset) {
        return heap.poolHandle() + offset;
    }

    public abstract AnyHeap heap();

    AnyHeap heapInternal() {
        return this.heap;
    }

    abstract long metadataSize();

    long uncheckedGetHandle() {
        return this.address;
    }

    public long handle() {
        this.checkValid();
        return this.address;
    }

    public boolean isValid() {
        return this.directAddress != 0L;
    }

    void checkValid() {
        if (this.directAddress != 0L) {
            return;
        }
        throw new IllegalStateException("Accessor references invalid memory");
    }

    public byte getByte(long offset) {
        this.checkValid();
        this.checkBounds(offset, 1L);
        return AnyHeap.UNSAFE.getByte(this.payloadAddress(offset));
    }

    public short getShort(long offset) {
        this.checkValid();
        this.checkBounds(offset, 2L);
        return AnyHeap.UNSAFE.getShort(this.payloadAddress(offset));
    }

    public int getInt(long offset) {
        this.checkValid();
        this.checkBounds(offset, 4L);
        return AnyHeap.UNSAFE.getInt(this.payloadAddress(offset));
    }

    public long getLong(long offset) {
        this.checkValid();
        this.checkBounds(offset, 8L);
        return AnyHeap.UNSAFE.getLong(this.payloadAddress(offset));
    }

    public void copyToArray(long srcOffset, byte[] dstArray, int dstOffset, int length) {
        this.checkValid();
        this.checkBoundsAndLength(srcOffset, length);
        if (dstOffset < 0 || dstOffset + length > dstArray.length) {
            throw new IndexOutOfBoundsException("array index out of bounds.");
        }
        MemoryAccessor.uncheckedCopyToArray(this.directAddress() + this.metadataSize() + srcOffset, dstArray, dstOffset, length);
    }

    public abstract void setByte(long var1, byte var3);

    public abstract void setShort(long var1, short var3);

    public abstract void setInt(long var1, int var3);

    public abstract void setLong(long var1, long var3);

    public abstract void copyFrom(MemoryAccessor var1, long var2, long var4, long var6);

    void copyFromMemoryBlock(AnyMemoryBlock srcBlock, long srcOffset, long dstOffset, long length) {
        this.copyFrom(srcBlock, srcOffset, dstOffset, length);
    }

    public abstract void copyFromArray(byte[] var1, int var2, long var3, int var5);

    public abstract void setMemory(byte var1, long var2, long var4);

    public abstract <T> T withRange(long var1, long var3, Function<Range, T> var5);

    public abstract void withRange(long var1, long var3, Consumer<Range> var5);

    public abstract void freeMemory();

    void rawSetByte(long offset, byte value) {
        this.checkValid();
        this.checkBounds(offset, 1L);
        this.setRawByte(offset, value);
    }

    void rawSetShort(long offset, short value) {
        this.checkValid();
        this.checkBounds(offset, 2L);
        this.setRawShort(offset, value);
    }

    void rawSetInt(long offset, int value) {
        this.checkValid();
        this.checkBounds(offset, 4L);
        this.setRawInt(offset, value);
    }

    void rawSetLong(long offset, long value) {
        this.checkValid();
        this.checkBounds(offset, 8L);
        this.setRawLong(offset, value);
    }

    void rawCopy(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        this.checkValid();
        srcAccessor.checkValid();
        srcAccessor.checkBoundsAndLength(srcOffset, length);
        this.checkBoundsAndLength(dstOffset, length);
        MemoryAccessor.uncheckedCopyBlockToBlock(srcAccessor.directAddress() + srcAccessor.metadataSize() + srcOffset, this.directAddress() + this.metadataSize() + dstOffset, length);
    }

    void rawCopyFromMemoryBlock(MemoryAccessor srcBlock, long srcOffset, long dstOffset, long length) {
        this.rawCopy(srcBlock, srcOffset, dstOffset, length);
    }

    void rawCopyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        if (srcOffset < 0 || srcOffset + length > srcArray.length) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(srcOffset, length));
        }
        this.checkValid();
        this.checkBoundsAndLength(dstOffset, length);
        MemoryAccessor.uncheckedCopyFromArray(srcArray, srcOffset, this.directAddress() + this.metadataSize() + dstOffset, length);
    }

    void rawSetMemory(byte val, long offset, long length) {
        this.checkValid();
        this.checkBoundsAndLength(offset, length);
        MemoryAccessor.uncheckedSetMemory(this.directAddress() + this.metadataSize() + offset, val, length);
    }

    <T> T rawWithRange(long startOffset, long length, Function<Range, T> op) {
        Range range = this.range(startOffset, length);
        T result = op.apply(range);
        range.markInvalid();
        return result;
    }

    void durableSetByte(long offset, byte value) {
        this.rawSetByte(offset, value);
        this.internalFlush(offset, 1L);
    }

    void durableSetShort(long offset, short value) {
        this.rawSetShort(offset, value);
        this.internalFlush(offset, 2L);
    }

    void durableSetInt(long offset, int value) {
        this.rawSetInt(offset, value);
        this.internalFlush(offset, 4L);
    }

    void durableSetLong(long offset, long value) {
        this.rawSetLong(offset, value);
        this.internalFlush(offset, 8L);
    }

    void durableCopy(MemoryAccessor src, long srcOffset, long dstOffset, long length) {
        this.durableWithRange(dstOffset, length, range -> {
            range.copyFrom(src, srcOffset, dstOffset, length);
            return null;
        });
    }

    void durableCopyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        this.durableWithRange(dstOffset, length, range -> {
            range.copyFromArray(srcArray, srcOffset, dstOffset, length);
            return null;
        });
    }

    void durableSetMemory(byte val, long offset, long length) {
        this.durableWithRange(offset, length, range -> {
            range.setMemory(val, offset, length);
            return null;
        });
    }

    <T> T durableWithRange(long startOffset, long length, Function<Range, T> op) {
        Range range = this.range(startOffset, length);
        T result = op.apply(range);
        range.flush();
        range.markInvalid();
        return result;
    }

    void transactionalSetByte(long offset, byte value) {
        this.transactionalWithRange(offset, 1L, range -> {
            range.setByte(offset, value);
            return null;
        });
    }

    void transactionalSetShort(long offset, short value) {
        this.transactionalWithRange(offset, 2L, range -> {
            range.setShort(offset, value);
            return null;
        });
    }

    void transactionalSetInt(long offset, int value) {
        this.transactionalWithRange(offset, 4L, range -> {
            range.setInt(offset, value);
            return null;
        });
    }

    void transactionalSetLong(long offset, long value) {
        this.transactionalWithRange(offset, 8L, range -> {
            range.setLong(offset, value);
            return null;
        });
    }

    void transactionalCopy(MemoryAccessor src, long srcOffset, long dstOffset, long length) {
        this.transactionalWithRange(dstOffset, length, range -> {
            range.copyFrom(src, srcOffset, dstOffset, length);
            return null;
        });
    }

    void transactionalCopyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        this.transactionalWithRange(dstOffset, length, range -> {
            range.copyFromArray(srcArray, srcOffset, dstOffset, length);
            return null;
        });
    }

    void transactionalSetMemory(byte val, long offset, long length) {
        this.transactionalWithRange(offset, length, range -> {
            range.setMemory(val, offset, length);
            return null;
        });
    }

    <T> T transactionalWithRange(long startOffset, long length, Function<Range, T> op) {
        T ans;
        Range range = this.range(startOffset, length);
        int result = range.addToTransaction();
        if (result == 2) {
            ans = op.apply(range);
        } else if (result == 1) {
            ans = new Transaction(this.heap(), false).run(range, op);
        } else {
            throw new TransactionException("No active transaction and unable to create transaction.");
        }
        range.markInvalid();
        return ans;
    }

    public long size() {
        if (this.size == -1L) {
            throw new UnsupportedOperationException("Size method is not supported for compact allocations");
        }
        return this.size;
    }

    Range range(long startOffset, long length) {
        return new Range(this, startOffset, length);
    }

    void flush(long offset, long length) {
        this.checkValid();
        this.checkBoundsAndLength(offset, length);
        this.internalFlush(offset, length);
    }

    void internalFlush(long offset, long size) {
        if (!ELIDE_FLUSHES) {
            MemoryAccessor.nativeFlush(this.payloadAddress(offset), size);
        }
    }

    void addToTransaction(long offset, long size) {
        this.checkValid();
        this.checkBoundsAndLength(offset, size);
        int result = MemoryAccessor.nativeAddToTransaction(this.heap().poolHandle(), this.payloadAddress(offset), size);
        if (result != 2) {
            throw new IllegalStateException("No transaction active.");
        }
    }

    long getPersistentSize() {
        return AnyHeap.UNSAFE.getLong(this.directAddress + 0L);
    }

    long payloadAddress(long payloadOffset) {
        return this.directAddress + this.metadataSize() + payloadOffset;
    }

    long directAddress() {
        return this.directAddress;
    }

    void markInvalid() {
        this.directAddress = 0L;
    }

    void checkBoundsAndLength(long offset, long length) {
        if (offset < 0L || length <= 0L || offset + length > this.size) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    void checkBounds(long offset, long length) {
        if (offset < 0L || offset + length > this.size) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    void setRawByte(long offset, byte value) {
        AnyHeap.UNSAFE.putByte(this.payloadAddress(offset), value);
    }

    void setRawShort(long offset, short value) {
        AnyHeap.UNSAFE.putShort(this.payloadAddress(offset), value);
    }

    void setRawInt(long offset, int value) {
        AnyHeap.UNSAFE.putInt(this.payloadAddress(offset), value);
    }

    void setRawLong(long offset, long value) {
        AnyHeap.UNSAFE.putLong(this.payloadAddress(offset), value);
    }

    static void uncheckedCopyToArray(long srcAddress, byte[] dstArray, int dstOffset, int length) {
        long dstAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + Unsafe.ARRAY_BYTE_INDEX_SCALE * dstOffset;
        AnyHeap.UNSAFE.copyMemory(null, srcAddress, dstArray, dstAddress, length);
    }

    static void uncheckedCopyBlockToBlock(long srcAddress, long dstAddress, long length) {
        AnyHeap.UNSAFE.copyMemory(srcAddress, dstAddress, length);
    }

    static void uncheckedCopyFromArray(byte[] srcArray, int srcOffset, long dstAddress, int length) {
        long srcAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + Unsafe.ARRAY_BYTE_INDEX_SCALE * srcOffset;
        AnyHeap.UNSAFE.copyMemory(srcArray, srcAddress, null, dstAddress, length);
    }

    static void uncheckedSetMemory(long dstAddress, byte val, long length) {
        AnyHeap.UNSAFE.setMemory(dstAddress, length, val);
    }

    static String outOfBoundsMessage(long offset, long length) {
        if (offset < 0L) {
            return "negative offset: " + offset;
        }
        if (length < 0L) {
            return "negative length: " + length;
        }
        return String.format("offset + length is out of bounds: %s + %s", offset, length);
    }

    static native void nativeFlush(long var0, long var2);

    private static native int nativeAddToTransaction(long var0, long var2, long var4);

    private static native int nativeHasAutoFlush();

    static native int nativeAddToTransactionNoCheck(long var0, long var2);

    static native int nativeAddRangeToTransaction(long var0, long var2, long var4);

    static {
        Util.loadLibrary();
    }
}

