/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.MemoryPoolImpl;
import java.io.File;

public interface MemoryPool {
    public static MemoryPool createPool(String filePath, long byteCount) {
        if (filePath.startsWith("/dev/dax")) {
            throw new IllegalArgumentException("Device paths are not compatible with this method");
        }
        return new MemoryPoolImpl(filePath, byteCount);
    }

    public static MemoryPool openPool(String filePath) {
        return new MemoryPoolImpl(filePath);
    }

    public static MemoryPool mapDevice(String devicePath) {
        return new MemoryPoolImpl(devicePath);
    }

    public static boolean exists(String path) {
        if (path.startsWith("/dev/dax")) {
            int flag = AnyHeap.nativeHeapExists(path);
            return flag != -1;
        }
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public byte getByte(long var1);

    public short getShort(long var1);

    public int getInt(long var1);

    public long getLong(long var1);

    public void setByte(long var1, byte var3);

    public void setShort(long var1, short var3);

    public void setInt(long var1, int var3);

    public void setLong(long var1, long var3);

    public void copyFromPool(long var1, long var3, long var5);

    public void copyFromPool(MemoryPool var1, long var2, long var4, long var6);

    public void copyFromByteArray(byte[] var1, int var2, long var3, int var5);

    public void copyToByteArray(long var1, byte[] var3, int var4, int var5);

    public void setMemory(byte var1, long var2, long var4);

    public void copyFromPoolNT(long var1, long var3, long var5);

    public void copyFromPoolNT(MemoryPool var1, long var2, long var4, long var6);

    public void copyFromByteArrayNT(byte[] var1, int var2, long var3, int var5);

    public void setMemoryNT(byte var1, long var2, long var4);

    public long size();

    public void flush(long var1, long var3);

    public int hashCode();

    public boolean equals(Object var1);
}

