/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.MemoryPool;
import com.intel.pmem.llpl.MemoryPoolException;
import com.intel.pmem.llpl.Util;
import java.io.File;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

class MemoryPoolImpl
implements MemoryPool {
    static Unsafe UNSAFE;
    private long poolAddress;
    private final long poolSize;
    private final String poolPath;

    MemoryPoolImpl(String path, long byteCount) {
        if (byteCount <= 0L) {
            throw new IllegalArgumentException("byteCount must be greater than zero");
        }
        File file = new File(path);
        if (file.exists()) {
            throw new MemoryPoolException("Unable to create pool, path already exists:" + path);
        }
        try {
            this.poolAddress = MemoryPoolImpl.nativeOpenPool(path, byteCount);
        }
        catch (MemoryPoolException e) {
            throw new MemoryPoolException("Unable to create pool: " + e.getMessage());
        }
        this.poolSize = byteCount;
        this.poolPath = path;
    }

    MemoryPoolImpl(String path) {
        File file = new File(path);
        if (path.startsWith("/dev/dax")) {
            try {
                this.poolAddress = MemoryPoolImpl.nativeOpenPool(path, 0L);
            }
            catch (MemoryPoolException e) {
                throw new MemoryPoolException("Unable to map device: " + e.getMessage());
            }
            this.poolSize = MemoryPoolImpl.nativePoolSize(path);
            this.poolPath = path;
        } else {
            if (!file.exists() || !file.isFile()) {
                throw new IllegalArgumentException("path supplied must be an existing file");
            }
            this.poolSize = file.length();
            try {
                this.poolAddress = MemoryPoolImpl.nativeOpenPool(path, this.poolSize);
            }
            catch (MemoryPoolException e) {
                throw new MemoryPoolException("Unable to open pool: " + e.getMessage());
            }
            this.poolPath = path;
        }
    }

    private void checkBounds(long offset, long byteCount) {
        if (offset < 0L || byteCount < 0L || offset + byteCount > this.poolSize) {
            StringBuilder errorMessage = new StringBuilder("MemoryPool");
            if (offset < 0L) {
                errorMessage.append("negative offset: " + offset);
            } else if (byteCount < 0L) {
                errorMessage.append("negative length: " + byteCount);
            } else {
                errorMessage.append(String.format("offset + length is out of bounds: %s + %s", offset, byteCount));
            }
            throw new IndexOutOfBoundsException(errorMessage.toString());
        }
    }

    private long dataAddress(long offset) {
        return this.poolAddress + offset;
    }

    void close() {
        int result = MemoryPoolImpl.nativeClosePool(this.poolAddress, this.poolSize);
        if (result == -1) {
            throw new MemoryPoolException("Unable to close pool");
        }
    }

    @Override
    public long size() {
        return this.poolSize;
    }

    @Override
    public byte getByte(long offset) {
        this.checkBounds(offset, 1L);
        return UNSAFE.getByte(this.dataAddress(offset));
    }

    @Override
    public short getShort(long offset) {
        this.checkBounds(offset, 2L);
        return UNSAFE.getShort(this.dataAddress(offset));
    }

    @Override
    public int getInt(long offset) {
        this.checkBounds(offset, 4L);
        return UNSAFE.getInt(this.dataAddress(offset));
    }

    @Override
    public long getLong(long offset) {
        this.checkBounds(offset, 8L);
        return UNSAFE.getLong(this.dataAddress(offset));
    }

    @Override
    public void setByte(long offset, byte value) {
        this.checkBounds(offset, 1L);
        UNSAFE.putByte(this.dataAddress(offset), value);
    }

    @Override
    public void setShort(long offset, short value) {
        this.checkBounds(offset, 2L);
        UNSAFE.putShort(this.dataAddress(offset), value);
    }

    @Override
    public void setInt(long offset, int value) {
        this.checkBounds(offset, 4L);
        UNSAFE.putInt(this.dataAddress(offset), value);
    }

    @Override
    public void setLong(long offset, long value) {
        this.checkBounds(offset, 8L);
        UNSAFE.putLong(this.dataAddress(offset), value);
    }

    @Override
    public void copyFromPool(long srcOffset, long dstOffset, long byteCount) {
        this.checkBounds(srcOffset, byteCount);
        this.checkBounds(dstOffset, byteCount);
        UNSAFE.copyMemory(this.dataAddress(srcOffset), this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void copyFromPool(MemoryPool srcPool, long srcOffset, long dstOffset, long byteCount) {
        ((MemoryPoolImpl)srcPool).checkBounds(srcOffset, byteCount);
        this.checkBounds(dstOffset, byteCount);
        UNSAFE.copyMemory(((MemoryPoolImpl)srcPool).dataAddress(srcOffset), this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void copyFromByteArray(byte[] srcArray, int srcIndex, long dstOffset, int byteCount) {
        if (srcIndex < 0 || srcIndex + byteCount > srcArray.length) {
            throw new IndexOutOfBoundsException(MemoryPoolImpl.indexOutOfBoundsMessage(srcIndex, byteCount));
        }
        this.checkBounds(dstOffset, byteCount);
        long srcAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + Unsafe.ARRAY_BYTE_INDEX_SCALE * srcIndex;
        UNSAFE.copyMemory(srcArray, srcAddress, null, this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void copyToByteArray(long srcOffset, byte[] dstArray, int dstIndex, int byteCount) {
        if (dstIndex < 0 || dstIndex + byteCount > dstArray.length) {
            throw new IndexOutOfBoundsException(MemoryPoolImpl.indexOutOfBoundsMessage(dstIndex, byteCount));
        }
        this.checkBounds(srcOffset, byteCount);
        long dstAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + Unsafe.ARRAY_BYTE_INDEX_SCALE * dstIndex;
        UNSAFE.copyMemory(null, this.dataAddress(srcOffset), dstArray, dstAddress, byteCount);
    }

    @Override
    public void setMemory(byte value, long offset, long byteCount) {
        this.checkBounds(offset, byteCount);
        UNSAFE.setMemory(this.dataAddress(offset), byteCount, value);
    }

    @Override
    public void copyFromPoolNT(long srcOffset, long dstOffset, long byteCount) {
        this.checkBounds(srcOffset, byteCount);
        this.checkBounds(dstOffset, byteCount);
        MemoryPoolImpl.nativeCopyMemoryNT(this.dataAddress(srcOffset), this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void copyFromPoolNT(MemoryPool srcPool, long srcOffset, long dstOffset, long byteCount) {
        ((MemoryPoolImpl)srcPool).checkBounds(srcOffset, byteCount);
        this.checkBounds(dstOffset, byteCount);
        MemoryPoolImpl.nativeCopyMemoryNT(((MemoryPoolImpl)srcPool).dataAddress(srcOffset), this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void copyFromByteArrayNT(byte[] srcArray, int srcIndex, long dstOffset, int byteCount) {
        if (srcIndex < 0 || srcIndex + byteCount > srcArray.length) {
            throw new IndexOutOfBoundsException(MemoryPoolImpl.indexOutOfBoundsMessage(srcIndex, byteCount));
        }
        this.checkBounds(dstOffset, byteCount);
        MemoryPoolImpl.nativeCopyFromByteArrayNT(srcArray, srcIndex, this.dataAddress(dstOffset), byteCount);
    }

    @Override
    public void setMemoryNT(byte value, long offset, long byteCount) {
        this.checkBounds(offset, byteCount);
        MemoryPoolImpl.nativeSetMemoryNT(this.dataAddress(offset), byteCount, value);
    }

    @Override
    public void flush(long offset, long byteCount) {
        this.checkBounds(offset, byteCount);
        MemoryPoolImpl.nativeFlush(this.dataAddress(offset), byteCount);
    }

    @Override
    public int hashCode() {
        return this.poolPath.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MemoryPool)) {
            return false;
        }
        MemoryPoolImpl other = (MemoryPoolImpl)obj;
        return this.poolPath.equals(other.poolPath);
    }

    static String indexOutOfBoundsMessage(long index, long length) {
        if (index < 0L) {
            return "negative index: " + index;
        }
        if (length < 0L) {
            return "negative length: " + length;
        }
        return String.format("index + length is out of bounds: %s + %s", index, length);
    }

    private static native long nativeOpenPool(String var0, long var1);

    private static native int nativeClosePool(long var0, long var2);

    private static native void nativeFlush(long var0, long var2);

    private static native long nativePoolSize(String var0);

    private static native void nativeCopyMemoryNT(long var0, long var2, long var4);

    private static native void nativeCopyFromByteArrayNT(byte[] var0, int var1, long var2, int var4);

    private static native void nativeSetMemoryNT(long var0, long var2, byte var4);

    static {
        Util.loadLibrary();
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize UNSAFE.");
        }
    }
}

