/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyAccessor;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.PersistentHeap;
import com.intel.pmem.llpl.Range;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PersistentAccessor
extends AnyAccessor {
    static final long METADATA_SIZE = 8L;

    PersistentAccessor(PersistentHeap heap) {
        super(heap);
    }

    @Override
    public PersistentHeap heap() {
        return (PersistentHeap)super.heapInternal();
    }

    @Override
    public void setByte(long offset, byte value) {
        super.durableSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.durableSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.durableSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.durableSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor src, long srcOffset, long dstOffset, long length) {
        super.durableCopy(src, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        super.durableCopyFromArray(srcArray, srcOffset, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.durableSetMemory(value, offset, length);
    }

    public void freeMemory(boolean transactional) {
        this.checkValid();
        this.heap().freeMemory(this.directAddress(), transactional);
        super.reset();
    }

    @Override
    public void freeMemory() {
        this.freeMemory(false);
    }

    @Override
    void checkBounds(long offset, long length) {
        super.checkBounds(offset, length);
    }

    @Override
    long metadataSize() {
        return 8L;
    }

    @Override
    public long size() {
        return super.size();
    }

    @Override
    public void handle(long handle) {
        this.heap().checkBounds(handle, 8L);
        super.handle(handle, true);
    }

    @Override
    public void resetHandle() {
        super.reset();
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.durableWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.durableWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }

    public void withRange(Consumer<Range> op) {
        super.durableWithRange(0L, this.size(), r -> {
            op.accept((Range)r);
            return null;
        });
    }

    @Override
    public <T> T transactionalWithRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.transactionalWithRange(startOffset, rangeLength, op);
    }

    public void transactionalWithRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.transactionalWithRange(startOffset, rangeLength, (Range r) -> {
            op.accept((Range)r);
            return null;
        });
    }

    public void transactionalWithRange(Consumer<Range> op) {
        this.transactionalWithRange(0L, this.size(), op);
    }
}

