/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AbstractPersistentMemoryBlock;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.PersistentHeap;

public final class PersistentCompactMemoryBlock
extends AbstractPersistentMemoryBlock {
    PersistentCompactMemoryBlock(PersistentHeap heap, long size, boolean transactional) {
        super(heap, size, false, transactional);
    }

    PersistentCompactMemoryBlock(PersistentHeap heap, long poolHandle, long offset) {
        super(heap, poolHandle, offset, false);
    }

    @Override
    long metadataSize() {
        return 0L;
    }

    @Override
    void checkBounds(long offset, long length) {
        if (offset < 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    @Override
    void checkBoundsAndLength(long offset, long length) {
        if (offset < 0L || length <= 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }
}

