/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.PersistentAccessor;
import com.intel.pmem.llpl.PersistentCompactAccessor;
import com.intel.pmem.llpl.PersistentCompactMemoryBlock;
import com.intel.pmem.llpl.PersistentMemoryBlock;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class PersistentHeap
extends AnyHeap {
    static final String HEAP_LAYOUT_ID = "llpl_persistent_heap";

    private PersistentHeap(String path, long size) {
        super(path, size);
    }

    private PersistentHeap(String path) {
        super(path);
    }

    public static synchronized PersistentHeap createHeap(String path) {
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (path.startsWith("/dev/dax")) {
            heapPath = path;
        } else {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) {
                throw new HeapException("The path \"" + path + "\" doesnt exist or is not a directory");
            }
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, 0L);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists");
        }
        PersistentHeap heap = new PersistentHeap(heapPath, 0L);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized PersistentHeap createHeap(String path, long size) {
        long heapSize;
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (path.startsWith("/dev/dax")) {
            throw new IllegalArgumentException("The path is invalid for this method");
        }
        if (size != 0L && size < MINIMUM_HEAP_SIZE) {
            throw new HeapException("The Heap size must be at least " + MINIMUM_HEAP_SIZE + " bytes");
        }
        File file = new File(path);
        if (size == 0L) {
            if (!file.exists() || !file.isFile()) throw new HeapException("The path \"" + path + "\" does not exist or is not a file");
            heapPath = path;
            heapSize = size;
        } else if (file.exists() && file.isDirectory()) {
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, size);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
            heapSize = 0L;
        } else {
            if (file.exists()) {
                throw new HeapException("Heap \"" + path + "\" already exists");
            }
            heapPath = path;
            heapSize = size;
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists");
        }
        PersistentHeap heap = new PersistentHeap(heapPath, heapSize);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    public static synchronized PersistentHeap openHeap(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        PersistentHeap heap = (PersistentHeap)AnyHeap.getHeap(path, PersistentHeap.getHeapClass("PersistentHeap"));
        String heapPath = path;
        if (heap == null) {
            File file = new File(path);
            if (file.exists() && file.isDirectory() && (heap = (PersistentHeap)AnyHeap.getHeap(heapPath = new File(file, "myobjpool.set").getAbsolutePath(), PersistentHeap.getHeapClass("PersistentHeap"))) != null) {
                return heap;
            }
            heap = new PersistentHeap(heapPath);
            AnyHeap.putHeap(heapPath, heap);
        }
        return heap;
    }

    @Override
    public PersistentAccessor createAccessor() {
        return new PersistentAccessor(this);
    }

    @Override
    public PersistentCompactAccessor createCompactAccessor() {
        return new PersistentCompactAccessor(this);
    }

    public long allocateMemory(long size, boolean transactional) {
        long allocationSize = size + 8L;
        Supplier<Long> body = () -> {
            long handle;
            long l = handle = transactional ? this.allocateTransactional(allocationSize) : this.allocateAtomic(allocationSize);
            if (handle == 0L) {
                throw new HeapException("Failed to allocate memory of size " + size);
            }
            long address = this.poolHandle() + handle + 0L;
            AnyHeap.UNSAFE.putLong(address, size);
            if (!transactional) {
                MemoryAccessor.nativeFlush(address, 8L);
            }
            return handle;
        };
        long handle = transactional ? new Transaction(this).run(body).longValue() : body.get().longValue();
        return handle;
    }

    @Override
    public long allocateMemory(long size) {
        return this.allocateMemory(size, false);
    }

    public long allocateCompactMemory(long size, boolean transactional) {
        long handle;
        long l = handle = transactional ? Transaction.create((AnyHeap)this, () -> this.allocateTransactional(size)).longValue() : this.allocateAtomic(size);
        if (handle == 0L) {
            throw new HeapException("Failed to allocate memory of size " + size);
        }
        return handle;
    }

    @Override
    public long allocateCompactMemory(long size) {
        return this.allocateCompactMemory(size, false);
    }

    public PersistentMemoryBlock allocateMemoryBlock(long size, boolean transactional) {
        return new PersistentMemoryBlock(this, size, transactional);
    }

    @Override
    public PersistentMemoryBlock allocateMemoryBlock(long size) {
        return new PersistentMemoryBlock(this, size, false);
    }

    @Override
    public PersistentMemoryBlock allocateMemoryBlock(long size, Consumer<Range> initializer) {
        return this.allocateMemoryBlock(size, false, initializer);
    }

    public PersistentMemoryBlock allocateMemoryBlock(long size, boolean transactional, Consumer<Range> initializer) {
        Supplier<PersistentMemoryBlock> body = () -> {
            PersistentMemoryBlock block = new PersistentMemoryBlock(this, size, transactional);
            Range range = block.range();
            if (initializer == null) {
                throw new IllegalArgumentException("Initializer is null.");
            }
            initializer.accept(range);
            if (!transactional) {
                range.flush();
            }
            range.markInvalid();
            return block;
        };
        return transactional ? Transaction.create((AnyHeap)this, body) : body.get();
    }

    public PersistentCompactMemoryBlock allocateCompactMemoryBlock(long size, boolean transactional) {
        return new PersistentCompactMemoryBlock(this, size, transactional);
    }

    @Override
    public PersistentCompactMemoryBlock allocateCompactMemoryBlock(long size) {
        return new PersistentCompactMemoryBlock(this, size, false);
    }

    @Override
    public PersistentCompactMemoryBlock allocateCompactMemoryBlock(long size, Consumer<Range> initializer) {
        return this.allocateCompactMemoryBlock(size, false, initializer);
    }

    public PersistentCompactMemoryBlock allocateCompactMemoryBlock(long size, boolean transactional, Consumer<Range> initializer) {
        Supplier<PersistentCompactMemoryBlock> body = () -> {
            PersistentCompactMemoryBlock block = new PersistentCompactMemoryBlock(this, size, transactional);
            Range range = block.range(0L, size);
            if (initializer == null) {
                throw new IllegalArgumentException("Initializer is null.");
            }
            initializer.accept(range);
            if (!transactional) {
                range.flush();
            }
            range.markInvalid();
            return block;
        };
        return transactional ? Transaction.create((AnyHeap)this, body) : body.get();
    }

    @Override
    public PersistentMemoryBlock memoryBlockFromHandle(long handle) {
        this.checkBounds(handle, 8L);
        return new PersistentMemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    public PersistentCompactMemoryBlock compactMemoryBlockFromHandle(long handle) {
        this.checkBounds(handle);
        return new PersistentCompactMemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    public void execute(Runnable op) {
        op.run();
    }

    @Override
    public <T> T execute(Supplier<T> op) {
        return op.get();
    }

    @Override
    String getHeapLayoutID() {
        return HEAP_LAYOUT_ID;
    }

    @Override
    PersistentCompactMemoryBlock internalMemoryBlockFromHandle(long handle) {
        return new PersistentCompactMemoryBlock(this, this.poolHandle(), handle);
    }
}

