/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.TransactionException;

public final class Range {
    private final MemoryAccessor accessor;
    private long startOffset;
    private final long endOffset;
    private final long rangeLength;

    Range(MemoryAccessor accessor, long startOffset, long length) {
        accessor.checkBoundsAndLength(startOffset, length);
        this.accessor = accessor;
        this.startOffset = startOffset;
        this.endOffset = startOffset + length;
        this.rangeLength = length;
    }

    void markInvalid() {
        this.startOffset = -1L;
    }

    void checkValid() {
        if (this.startOffset < 0L) {
            throw new IllegalStateException("Invalid Range object");
        }
        this.accessor.checkValid();
    }

    public boolean isValid() {
        return this.startOffset > -1L;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long rangeLength() {
        return this.rangeLength;
    }

    void checkBounds(long start, long length) {
        if (start < this.startOffset || start + length > this.endOffset) {
            throw new IndexOutOfBoundsException("range start or length is out of bounds");
        }
    }

    void checkBoundsAndLength(long start, long length) {
        if (start < this.startOffset || length <= 0L || start + length > this.endOffset) {
            throw new IndexOutOfBoundsException("range start or length is out of bounds");
        }
    }

    public void setByte(long offset, byte value) {
        this.checkValid();
        this.checkBounds(offset, 1L);
        this.accessor.setRawByte(offset, value);
    }

    public void setShort(long offset, short value) {
        this.checkValid();
        this.checkBounds(offset, 2L);
        this.accessor.setRawShort(offset, value);
    }

    public void setInt(long offset, int value) {
        this.checkValid();
        this.checkBounds(offset, 4L);
        this.accessor.setRawInt(offset, value);
    }

    public void setLong(long offset, long value) {
        this.checkValid();
        this.checkBounds(offset, 8L);
        this.accessor.setRawLong(offset, value);
    }

    public void copyFrom(MemoryAccessor srcAccessor, long srcOffset, long dstOffset, long length) {
        this.checkValid();
        srcAccessor.checkValid();
        srcAccessor.checkBoundsAndLength(srcOffset, length);
        this.checkBoundsAndLength(dstOffset, length);
        MemoryAccessor.uncheckedCopyBlockToBlock(srcAccessor.directAddress() + srcAccessor.metadataSize() + srcOffset, this.accessor.directAddress() + this.accessor.metadataSize() + dstOffset, length);
    }

    public void copyFromMemoryBlock(AnyMemoryBlock srcBlock, long srcOffset, long dstOffset, long length) {
        this.copyFrom(srcBlock, srcOffset, dstOffset, length);
    }

    public void copyFromArray(byte[] srcArray, int srcIndex, long dstOffset, int length) {
        this.checkValid();
        if (srcIndex < 0 || srcIndex + length > srcArray.length) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(srcIndex, length));
        }
        this.checkBoundsAndLength(dstOffset, length);
        MemoryAccessor.uncheckedCopyFromArray(srcArray, srcIndex, this.accessor.directAddress() + this.accessor.metadataSize() + dstOffset, length);
    }

    public void setMemory(byte value, long offset, long length) {
        this.checkValid();
        this.checkBoundsAndLength(offset, length);
        MemoryAccessor.uncheckedSetMemory(this.accessor.directAddress() + this.accessor.metadataSize() + offset, value, length);
    }

    void flush() {
        this.checkValid();
        this.accessor.internalFlush(this.startOffset, this.rangeLength);
    }

    int addToTransaction() {
        this.checkValid();
        return MemoryAccessor.nativeAddRangeToTransaction(this.accessor.heap().poolHandle(), this.accessor.payloadAddress(this.startOffset), this.rangeLength);
    }

    void addToTransactionNoCheck() {
        this.checkValid();
        int res = MemoryAccessor.nativeAddToTransactionNoCheck(this.accessor.payloadAddress(this.startOffset), this.rangeLength);
        if (res != 0) {
            throw new TransactionException("Failed to add range to transaction.");
        }
    }
}

