/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.TransactionException;
import com.intel.pmem.llpl.Util;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Transaction {
    private State state;
    private int depth;
    private final boolean doStart;
    private final AnyHeap heap;
    private boolean isValid;

    Transaction(AnyHeap heap) {
        this(heap, true);
    }

    Transaction(AnyHeap heap, boolean doStart) {
        this.heap = heap;
        this.state = State.New;
        this.isValid = true;
        this.doStart = doStart;
    }

    public static Transaction create(AnyHeap heap) {
        return new Transaction(heap, true);
    }

    public boolean isValid() {
        return this.isValid;
    }

    State state() {
        return this.state;
    }

    public static void create(AnyHeap heap, Runnable body) {
        Transaction.create(heap, () -> {
            body.run();
            return null;
        });
    }

    public static <T> T create(AnyHeap heap, Supplier<T> body) {
        return (T)Transaction.internalRun(new Transaction(heap), null, r -> body.get());
    }

    public void run(Runnable body) {
        this.run(null, r -> {
            body.run();
            return null;
        });
    }

    public <T> T run(Supplier<T> body) {
        return (T)this.run(null, r -> body.get());
    }

    <T> T run(Range range, Function<Range, T> body) {
        return Transaction.internalRun(this, range, body);
    }

    private static <T> T internalRun(Transaction transaction, Range range, Function<Range, T> body) {
        T result;
        if (transaction.state == State.New) {
            int result2;
            if (transaction.doStart && (result2 = Transaction.nativeStartTransaction(transaction.heap.poolHandle())) == -1) {
                throw new IllegalStateException("Error starting transaction.");
            }
            transaction.state = State.Active;
        }
        if (transaction.state != State.Active) {
            throw new TransactionException("Transaction not active");
        }
        ++transaction.depth;
        try {
            if (range != null) {
                range.addToTransactionNoCheck();
            }
            result = body.apply(range);
        }
        catch (Throwable t) {
            if (transaction.state == State.Active) {
                Transaction.nativeAbortTransaction();
            }
            transaction.state = State.Aborted;
            transaction.isValid = false;
            throw t;
        }
        finally {
            if (transaction.state == State.Active && transaction.depth == 1) {
                Transaction.nativeCommitTransaction();
                transaction.state = State.Committed;
                transaction.isValid = false;
            }
            --transaction.depth;
        }
        return result;
    }

    static void checkTransactionActive(boolean expected) {
        boolean active = Transaction.isTransactionActive();
        if (active != expected) {
            throw new IllegalStateException(expected ? "Expected active transaction." : "Unexpected active transaction.");
        }
    }

    static boolean isTransactionActive() {
        return Transaction.nativeTransactionState() == 2;
    }

    private static native int nativeStartTransaction(long var0);

    private static native void nativeCommitTransaction();

    private static native void nativeAbortTransaction();

    private static native int nativeTransactionState();

    static {
        Util.loadLibrary();
    }

    static enum State {
        New,
        Active,
        Committed,
        Aborted;

    }
}

