/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyAccessor;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.TransactionalHeap;
import java.util.function.Consumer;
import java.util.function.Function;

public final class TransactionalCompactAccessor
extends AnyAccessor {
    static final long METADATA_SIZE = 0L;

    TransactionalCompactAccessor(TransactionalHeap heap) {
        super(heap);
    }

    @Override
    public TransactionalHeap heap() {
        return (TransactionalHeap)super.heapInternal();
    }

    @Override
    public void setByte(long offset, byte value) {
        super.transactionalSetByte(offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        super.transactionalSetShort(offset, value);
    }

    @Override
    public void setInt(long offset, int value) {
        super.transactionalSetInt(offset, value);
    }

    @Override
    public void setLong(long offset, long value) {
        super.transactionalSetLong(offset, value);
    }

    @Override
    public void copyFrom(MemoryAccessor srcBlock, long srcOffset, long dstOffset, long length) {
        super.transactionalCopy(srcBlock, srcOffset, dstOffset, length);
    }

    @Override
    public void copyFromArray(byte[] srcArray, int srcOffset, long dstOffset, int length) {
        super.transactionalCopyFromArray(srcArray, srcOffset, dstOffset, length);
    }

    @Override
    public void setMemory(byte value, long offset, long length) {
        super.transactionalSetMemory(value, offset, length);
    }

    @Override
    public void freeMemory() {
        this.checkValid();
        this.heap().freeMemory(this.directAddress(), true);
        super.reset();
    }

    @Override
    void checkBounds(long offset, long length) {
        if (offset < 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    @Override
    void checkBoundsAndLength(long offset, long length) {
        if (offset < 0L || length <= 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    @Override
    long metadataSize() {
        return 0L;
    }

    @Override
    public void handle(long handle) {
        this.heap().checkBounds(handle, 0L);
        super.handle(handle, false);
    }

    @Override
    public void resetHandle() {
        super.reset();
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("Size method is not supported for compact accessors");
    }

    @Override
    public <T> T withRange(long startOffset, long rangeLength, Function<Range, T> op) {
        return super.transactionalWithRange(startOffset, rangeLength, op);
    }

    @Override
    public void withRange(long startOffset, long rangeLength, Consumer<Range> op) {
        super.transactionalWithRange(startOffset, rangeLength, r -> {
            op.accept((Range)r);
            return null;
        });
    }
}

