/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AbstractTransactionalMemoryBlock;
import com.intel.pmem.llpl.MemoryAccessor;
import com.intel.pmem.llpl.TransactionalHeap;

public final class TransactionalCompactMemoryBlock
extends AbstractTransactionalMemoryBlock {
    TransactionalCompactMemoryBlock(TransactionalHeap heap, long size) {
        super(heap, size, false);
    }

    TransactionalCompactMemoryBlock(TransactionalHeap heap, long poolHandle, long offset) {
        super(heap, poolHandle, offset, false);
    }

    @Override
    long metadataSize() {
        return 0L;
    }

    @Override
    void checkBounds(long offset, long length) {
        if (offset < 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }

    @Override
    void checkBoundsAndLength(long offset, long length) {
        if (offset < 0L || length <= 0L || this.heap().outOfBounds(offset + length + this.uncheckedGetHandle())) {
            throw new IndexOutOfBoundsException(MemoryAccessor.outOfBoundsMessage(offset, length));
        }
    }
}

