/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.Transaction;
import com.intel.pmem.llpl.TransactionalAccessor;
import com.intel.pmem.llpl.TransactionalCompactAccessor;
import com.intel.pmem.llpl.TransactionalCompactMemoryBlock;
import com.intel.pmem.llpl.TransactionalMemoryBlock;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class TransactionalHeap
extends AnyHeap {
    static final String HEAP_LAYOUT_ID = "llpl_transactional_heap";

    private TransactionalHeap(String path, long size) {
        super(path, size);
    }

    private TransactionalHeap(String path) {
        super(path);
    }

    public static synchronized TransactionalHeap createHeap(String path) {
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (path.startsWith("/dev/dax")) {
            heapPath = path;
        } else {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) {
                throw new HeapException("The path \"" + path + "\" doesnt exist or is not a directory");
            }
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, 0L);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists");
        }
        TransactionalHeap heap = new TransactionalHeap(heapPath, 0L);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TransactionalHeap createHeap(String path, long size) {
        long heapSize;
        String heapPath;
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        if (path.startsWith("/dev/dax")) {
            throw new IllegalArgumentException("The path is invalid for this method");
        }
        if (size != 0L && size < MINIMUM_HEAP_SIZE) {
            throw new HeapException("The Heap size must be at least " + MINIMUM_HEAP_SIZE + " bytes");
        }
        File file = new File(path);
        if (size == 0L) {
            if (!file.exists() || !file.isFile()) throw new HeapException("The path \"" + path + "\" does not exist or is not a file");
            heapPath = path;
            heapSize = size;
        } else if (file.exists() && file.isDirectory()) {
            heapPath = new File(file, "myobjpool.set").getAbsolutePath();
            try {
                AnyHeap.createPoolSetFile(file, size);
            }
            catch (IOException e) {
                throw new HeapException(e.getMessage());
            }
            heapSize = 0L;
        } else {
            if (file.exists()) {
                throw new HeapException("Heap \"" + path + "\" already exists");
            }
            heapPath = path;
            heapSize = size;
        }
        if (AnyHeap.getHeap(heapPath)) {
            throw new HeapException("Heap \"" + path + "\" already exists");
        }
        TransactionalHeap heap = new TransactionalHeap(heapPath, heapSize);
        AnyHeap.putHeap(heapPath, heap);
        return heap;
    }

    public static synchronized TransactionalHeap openHeap(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The provided path must not be null");
        }
        TransactionalHeap heap = (TransactionalHeap)AnyHeap.getHeap(path, TransactionalHeap.getHeapClass("TransactionalHeap"));
        String heapPath = path;
        if (heap == null) {
            File file = new File(path);
            if (file.exists() && file.isDirectory() && (heap = (TransactionalHeap)AnyHeap.getHeap(heapPath = new File(file, "myobjpool.set").getAbsolutePath(), TransactionalHeap.getHeapClass("TransactionalHeap"))) != null) {
                return heap;
            }
            heap = new TransactionalHeap(heapPath);
            AnyHeap.putHeap(heapPath, heap);
        }
        return heap;
    }

    @Override
    public TransactionalAccessor createAccessor() {
        return new TransactionalAccessor(this);
    }

    @Override
    public TransactionalCompactAccessor createCompactAccessor() {
        return new TransactionalCompactAccessor(this);
    }

    @Override
    public long allocateMemory(long size) {
        long allocationSize = size + 8L;
        long hd = Transaction.create((AnyHeap)this, () -> {
            long handle = this.allocateTransactional(allocationSize);
            if (handle == 0L) {
                throw new HeapException("Failed to allocate memory of size " + size);
            }
            AnyHeap.UNSAFE.putLong(this.poolHandle() + handle + 0L, size);
            return handle;
        });
        return hd;
    }

    @Override
    public long allocateCompactMemory(long size) {
        long handle = Transaction.create((AnyHeap)this, () -> this.allocateTransactional(size));
        if (handle == 0L) {
            throw new HeapException("Failed to allocate memory of size " + size);
        }
        return handle;
    }

    @Override
    public TransactionalMemoryBlock allocateMemoryBlock(long size) {
        return new TransactionalMemoryBlock(this, size);
    }

    @Override
    public TransactionalMemoryBlock allocateMemoryBlock(long size, Consumer<Range> initializer) {
        return Transaction.create((AnyHeap)this, () -> {
            TransactionalMemoryBlock block = new TransactionalMemoryBlock(this, size);
            Range range = block.range();
            if (initializer == null) {
                throw new IllegalArgumentException("Initializer is null.");
            }
            initializer.accept(range);
            range.markInvalid();
            return block;
        });
    }

    @Override
    public TransactionalCompactMemoryBlock allocateCompactMemoryBlock(long size) {
        return new TransactionalCompactMemoryBlock(this, size);
    }

    @Override
    public TransactionalCompactMemoryBlock allocateCompactMemoryBlock(long size, Consumer<Range> initializer) {
        return Transaction.create((AnyHeap)this, () -> {
            TransactionalCompactMemoryBlock block = new TransactionalCompactMemoryBlock(this, size);
            Range range = block.range(0L, size);
            if (initializer == null) {
                throw new IllegalArgumentException("Initializer is null.");
            }
            initializer.accept(range);
            range.markInvalid();
            return block;
        });
    }

    @Override
    public TransactionalMemoryBlock memoryBlockFromHandle(long handle) {
        this.checkBounds(handle, 8L);
        return new TransactionalMemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    public void execute(Runnable op) {
        Transaction.create((AnyHeap)this, op);
    }

    @Override
    public <T> T execute(Supplier<T> op) {
        return Transaction.create((AnyHeap)this, op);
    }

    @Override
    String getHeapLayoutID() {
        return HEAP_LAYOUT_ID;
    }

    @Override
    TransactionalCompactMemoryBlock internalMemoryBlockFromHandle(long handle) {
        return new TransactionalCompactMemoryBlock(this, this.poolHandle(), handle);
    }

    @Override
    public TransactionalCompactMemoryBlock compactMemoryBlockFromHandle(long handle) {
        this.checkBounds(handle);
        return new TransactionalCompactMemoryBlock(this, this.poolHandle(), handle);
    }
}

