/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Util {
    private static boolean loaded = false;
    private static String extension = "";
    private static String tempDirectory;

    private Util() {
    }

    static boolean isLoaded() {
        if (loaded) {
            return true;
        }
        try {
            System.loadLibrary("llpl");
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        return loaded;
    }

    static String getLibName() {
        return "/com/intel/pmem/llpl/" + Util.getOSName() + "/" + Util.getOSArch() + "/libllpl" + extension;
    }

    static String getOSName() {
        String os = System.getProperty("os.name");
        if (!os.contains("Linux")) {
            throw new UnsupportedOperationException("Operating System is not supported");
        }
        String ret = "linux";
        extension = ".so";
        return ret;
    }

    static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static void setLLPLTempDirectory(String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Path is not a valid directory");
        }
        tempDirectory = path;
    }

    static void loadLibrary() {
        if (Util.isLoaded()) {
            return;
        }
        String libName = Util.getLibName();
        File nativeLib = null;
        try (InputStream in = Util.class.getResourceAsStream(libName);){
            nativeLib = tempDirectory == null ? File.createTempFile("libllpl", extension) : new File(tempDirectory, "libllpl" + extension);
            try (FileOutputStream out = new FileOutputStream(nativeLib);){
                int bytesRead;
                byte[] buf = new byte[4096];
                while ((bytesRead = in.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
            }
            System.load(nativeLib.getAbsolutePath());
            loaded = true;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("Failed to native load llpl library");
        }
        finally {
            if (nativeLib != null) {
                nativeLib.deleteOnExit();
            }
        }
    }
}

