/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.util.AbstractSharded;
import com.intel.pmem.llpl.util.AutoCloseableIterator;
import com.intel.pmem.llpl.util.DynamicSharder;
import com.intel.pmem.llpl.util.LongART;
import com.intel.pmem.llpl.util.Sharder;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class ConcurrentLongART
extends AbstractSharded<byte[]> {
    private final AnyHeap heap;
    private final Sharder<byte[]> sharder;
    final Comparator<byte[]> comparator = ConcurrentLongART::compare;

    public ConcurrentLongART(AnyHeap heap, int concurrencyLevel) {
        this.heap = heap;
        this.sharder = new DynamicSharder<byte[]>(heap, concurrencyLevel, (AbstractSharded)this);
    }

    private ConcurrentLongART(AnyHeap heap, long handle) {
        this.heap = heap;
        this.sharder = Sharder.rebuild(heap, handle, this);
        if (this.sharder == null) {
            throw new RuntimeException();
        }
    }

    public static ConcurrentLongART fromHandle(AnyHeap heap, long handle) {
        return new ConcurrentLongART(heap, handle);
    }

    @Override
    Comparator<byte[]> getComparator() {
        return this.comparator;
    }

    LongART createDynamicShard() {
        return new LongART(this.heap);
    }

    LongART recreateDynamicShard(long handle) {
        return LongART.fromHandle(this.heap, handle);
    }

    LongART createShard() {
        return new LongART(this.heap);
    }

    LongART recreateShard(long handle) {
        return LongART.fromHandle(this.heap, handle);
    }

    static int compare(byte[] a, byte[] b) {
        byte[] shorter = a.length < b.length ? a : b;
        int compare = 0;
        for (int i = 0; i < shorter.length && (compare = Integer.compareUnsigned(Byte.toUnsignedInt(a[i]), Byte.toUnsignedInt(b[i]))) == 0; ++i) {
        }
        return compare;
    }

    public byte[] firstKey() {
        return this.sharder.lowestKey(s -> ((LongART)s).firstKey());
    }

    public byte[] lastKey() {
        return this.sharder.highestKey(s -> ((LongART)s).lastKey());
    }

    public long put(byte[] key, long value) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        return (Long)this.sharder.shardAndPut(key, s -> ((LongART)s).put(key, value, (v, old) -> (Long)v));
    }

    public long put(byte[] key, Object newValue, BiFunction<Object, Long, Long> mergeFunction) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("newValue cannot be null");
        }
        return (Long)this.sharder.shardAndPut(key, s -> ((LongART)s).put(key, newValue, mergeFunction));
    }

    public long get(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        return (Long)this.sharder.shardAndGet(key, s -> ((LongART)s).get(key));
    }

    public long size() {
        return this.sharder.totalEntries();
    }

    public AutoCloseableIterator<LongART.Entry> getEntryIterator(byte[] firstKey, boolean firstInclusive, byte[] lastKey, boolean lastInclusive) {
        if (firstKey == null || firstKey.length == 0 || lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.sharder.shardsAndExecute(firstKey, lastKey, s -> ((LongART)s).getEntryIterator(firstKey, firstInclusive, lastKey, lastInclusive), false);
    }

    public AutoCloseableIterator<LongART.Entry> getEntryIterator() {
        return this.sharder.shardsAndExecute(null, null, s -> ((LongART)s).getEntryIterator(), false);
    }

    public AutoCloseableIterator<LongART.Entry> getReverseEntryIterator(byte[] firstKey, boolean firstInclusive, byte[] lastKey, boolean lastInclusive) {
        if (firstKey == null || firstKey.length == 0 || lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.sharder.shardsAndExecute(firstKey, lastKey, s -> ((LongART)s).getReverseEntryIterator(firstKey, firstInclusive, lastKey, lastInclusive), true);
    }

    public AutoCloseableIterator<LongART.Entry> getReverseEntryIterator() {
        return this.sharder.shardsAndExecute(null, null, s -> ((LongART)s).getReverseEntryIterator(), true);
    }

    public AutoCloseableIterator<LongART.Entry> getHeadEntryIterator(byte[] lastKey, boolean lastInclusive) {
        if (lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.sharder.shardsAndExecute(null, lastKey, s -> ((LongART)s).getHeadEntryIterator(lastKey, lastInclusive), false);
    }

    public AutoCloseableIterator<LongART.Entry> getTailEntryIterator(byte[] firstKey, boolean firstInclusive) {
        if (firstKey == null || firstKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return this.sharder.shardsAndExecute(firstKey, null, s -> ((LongART)s).getTailEntryIterator(firstKey, firstInclusive), false);
    }

    public long remove(byte[] key, Consumer<Long> cleanerFunction) {
        if (cleanerFunction == null) {
            throw new NullPointerException("cleaner function cannot be null");
        }
        if (key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        return (Long)this.sharder.shardAndGet(key, s -> ((LongART)s).remove(key, cleanerFunction));
    }

    public void clear(Consumer<Long> cleanerFunction) {
        if (cleanerFunction == null) {
            throw new IllegalArgumentException("cleaner function cannot be null");
        }
        this.sharder.forEach(s -> ((LongART)s).clear(cleanerFunction));
    }

    public void free() {
        this.sharder.free();
    }

    public long handle() {
        long ret = this.sharder.handle();
        if (ret == 0L) {
            throw new IllegalStateException();
        }
        return ret;
    }

    public int hashCode() {
        AnyMemoryBlock rootBlock = this.heap.memoryBlockFromHandle(this.handle());
        return rootBlock.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcurrentLongART)) {
            return false;
        }
        AnyMemoryBlock thisRootBlock = this.heap.memoryBlockFromHandle(this.handle());
        AnyMemoryBlock otherRootBlock = this.heap.memoryBlockFromHandle(((ConcurrentLongART)obj).handle());
        return otherRootBlock.equals(thisRootBlock);
    }

    static enum Mode {
        Static,
        Dynamic;

    }
}

