/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.Transaction;
import com.intel.pmem.llpl.util.AbstractSharded;
import com.intel.pmem.llpl.util.AutoCloseableIterator;
import com.intel.pmem.llpl.util.DynamicShardable;
import com.intel.pmem.llpl.util.LongArray;
import com.intel.pmem.llpl.util.Shardable;
import com.intel.pmem.llpl.util.Sharder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;

class DynamicSharder<K>
implements Sharder<K> {
    private int nShards;
    private int maxShards;
    private ConcurrentSkipListMap<KeyRange<K>, Shard<K>> rangeToShardMap;
    private AnyHeap heap;
    private AbstractSharded<K> sharded;
    private final long SPLIT_THRESHOLD = 1000L;
    private long handle;
    private LongArray shardArray;
    final String CLASSNAME = "com.intel.pmem.llpl.util.DynamicSharder";
    private final short VERSION = (short)100;
    private final long VERSION_OFFSET = 0L;
    private final long ROOT_SHARD_OFFSET = 8L;
    private final long CLASSNAME_LENGTH_OFFSET = 16L;
    private final long CLASSNAME_OFFSET = 20L;
    private final long ROOT_BLOCK_SIZE = 20L + (long)"com.intel.pmem.llpl.util.DynamicSharder".length();
    private final Comparator<K> comparator;

    long encodeRootBlock(AnyHeap heap, LongArray shardArray) {
        AnyMemoryBlock rootBlock = heap.allocateMemoryBlock(this.ROOT_BLOCK_SIZE);
        rootBlock.setInt(16L, "com.intel.pmem.llpl.util.DynamicSharder".length());
        rootBlock.copyFromArray("com.intel.pmem.llpl.util.DynamicSharder".getBytes(), 0, 20L, "com.intel.pmem.llpl.util.DynamicSharder".length());
        rootBlock.setLong(8L, shardArray.handle());
        rootBlock.setShort(0L, (short)100);
        return rootBlock.handle();
    }

    public DynamicSharder(AnyHeap heap, long handle, AbstractSharded sharded) {
        AnyMemoryBlock block = heap.memoryBlockFromHandle(handle);
        long shardArrayHandle = block.getLong(8L);
        this.shardArray = LongArray.fromHandle(heap, shardArrayHandle);
        this.maxShards = (int)this.shardArray.size();
        this.comparator = sharded.getComparator();
        this.rangeToShardMap = new ConcurrentSkipListMap();
        for (int i = 0; i < this.maxShards; ++i) {
            long l = this.shardArray.get(i);
            if (l == 0L) continue;
            Shard shard = new Shard(sharded.recreateDynamicShard(l));
            KeyRange<K> range = shard.shard().size() == 0L ? new KeyRange<K>(this.comparator) : new KeyRange(shard.shard().lastKey(), this.comparator);
            this.rangeToShardMap.put(range, shard);
        }
        Map.Entry<KeyRange<K>, Shard<K>> last2 = this.rangeToShardMap.pollLastEntry();
        this.rangeToShardMap.put(new KeyRange<K>(this.comparator), last2.getValue());
        this.nShards = this.rangeToShardMap.size();
        this.heap = heap;
        this.handle = handle;
        this.sharded = sharded;
    }

    public DynamicSharder(AnyHeap heap, int maxShards, AbstractSharded sharded) {
        LongArray shardArray = new LongArray(heap, maxShards);
        this.rangeToShardMap = new ConcurrentSkipListMap();
        Shard shard = new Shard(sharded.createDynamicShard());
        shardArray.set(0L, shard.shard().handle());
        this.comparator = sharded.getComparator();
        KeyRange<K> range = new KeyRange<K>(this.comparator);
        this.rangeToShardMap.put(range, shard);
        this.nShards = 1;
        this.maxShards = maxShards;
        this.heap = heap;
        this.shardArray = shardArray;
        this.handle = this.encodeRootBlock(heap, shardArray);
        this.sharded = sharded;
    }

    @Override
    public long handle() {
        return this.handle;
    }

    @Override
    public long totalEntries() {
        long size = 0L;
        for (Shard<K> shard : this.rangeToShardMap.values()) {
            size += shard.shard().size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K lowestKey(Function<Shardable<K>, K> f) {
        K ret;
        Shard<K> newShard;
        Map.Entry<KeyRange<K>, Shard<K>> celEntry = this.rangeToShardMap.firstEntry();
        Shard<K> shard = celEntry.getValue();
        shard.lock();
        while ((newShard = this.rangeToShardMap.get(celEntry.getKey())) != null && !newShard.equals(shard)) {
            shard.unlock();
            celEntry = this.rangeToShardMap.firstEntry();
            shard = celEntry.getValue();
            shard.lock();
        }
        try {
            ret = f.apply(shard.shard());
        }
        finally {
            shard.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K highestKey(Function<Shardable<K>, K> f) {
        K ret;
        Shard<K> newShard;
        Map.Entry<KeyRange<K>, Shard<K>> celEntry = this.rangeToShardMap.lastEntry();
        Shard<K> shard = celEntry.getValue();
        shard.lock();
        while ((newShard = this.rangeToShardMap.get(celEntry.getKey())) != null && !newShard.equals(shard)) {
            shard.unlock();
            celEntry = this.rangeToShardMap.lastEntry();
            shard = celEntry.getValue();
            shard.lock();
        }
        try {
            ret = f.apply(shard.shard());
        }
        finally {
            shard.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object shardAndPut(K key, Function<Shardable<K>, Object> f) {
        Object ret;
        Shard<K> newShard;
        Map.Entry<KeyRange<K>, Shard<K>> celEntry = this.rangeToShardMap.ceilingEntry(new KeyRange<K>(key, this.comparator));
        Shard<K> shard = this.maybeSplit(celEntry, key);
        shard.lock();
        while ((newShard = this.rangeToShardMap.get(celEntry.getKey())) != null && !newShard.equals(shard)) {
            shard.unlock();
            celEntry = this.rangeToShardMap.ceilingEntry(new KeyRange<K>(key, this.comparator));
            shard = celEntry.getValue();
            shard.lock();
        }
        try {
            ret = f.apply(shard.shard());
        }
        finally {
            shard.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object shardAndGet(K key, Function<Shardable<K>, Object> f) {
        Object ret;
        Shard<K> newShard;
        Map.Entry<KeyRange<K>, Shard<K>> celEntry = this.rangeToShardMap.ceilingEntry(new KeyRange<K>(key, this.comparator));
        Shard<K> shard = celEntry.getValue();
        shard.lock();
        while ((newShard = this.rangeToShardMap.get(celEntry.getKey())) != null && !newShard.equals(shard)) {
            shard.unlock();
            celEntry = this.rangeToShardMap.ceilingEntry(new KeyRange<K>(key, this.comparator));
            shard = celEntry.getValue();
            shard.lock();
        }
        try {
            ret = f.apply(shard.shard());
        }
        finally {
            shard.unlock();
        }
        return ret;
    }

    @Override
    public <E> SequentialShardIterator<E> shardsAndExecute(K fromKey, K toKey, Function<Shardable<K>, Iterator<E>> f, boolean reversed) {
        Iterator<Shard<Object>> it;
        KeyRange<K> toKeyRange = null;
        KeyRange<K> fromKeyRange = null;
        if (toKey != null) {
            toKeyRange = this.rangeToShardMap.ceilingKey(new KeyRange<K>(toKey, this.comparator));
        }
        if (fromKey != null) {
            fromKeyRange = this.rangeToShardMap.ceilingKey(new KeyRange<K>(fromKey, this.comparator));
        }
        if (fromKey == null && toKey == null) {
            it = reversed ? this.rangeToShardMap.descendingMap().values().iterator() : this.rangeToShardMap.values().iterator();
        } else if (fromKey == null) {
            it = reversed ? this.rangeToShardMap.headMap((Object)toKeyRange, true).descendingMap().values().iterator() : this.rangeToShardMap.headMap((Object)toKeyRange, true).values().iterator();
        } else if (toKey == null) {
            it = reversed ? this.rangeToShardMap.tailMap((Object)fromKeyRange, true).descendingMap().values().iterator() : this.rangeToShardMap.tailMap((Object)fromKeyRange, true).values().iterator();
        } else {
            Map.Entry<KeyRange<K>, Shard<K>> entry = this.rangeToShardMap.ceilingEntry(new KeyRange<K>(fromKey, this.comparator));
            if (entry.getKey().contains(toKey)) {
                return new SequentialShardIterator<E>(entry.getValue(), f);
            }
            it = reversed ? this.rangeToShardMap.subMap((Object)fromKeyRange, true, (Object)toKeyRange, true).descendingMap().values().iterator() : this.rangeToShardMap.subMap((Object)fromKeyRange, true, (Object)toKeyRange, true).values().iterator();
        }
        return new SequentialShardIterator<E>(it, f);
    }

    @Override
    public void forEach(Consumer<Shardable<K>> c) {
        this.rangeToShardMap.values().parallelStream().forEach((? super T shard) -> {
            shard.lock();
            try {
                c.accept(shard.shard());
            }
            finally {
                shard.unlock();
            }
        });
    }

    @Override
    public void free() {
        this.rangeToShardMap.values().parallelStream().forEach((? super T shard) -> {
            shard.lock();
            try {
                shard.shard().free();
            }
            finally {
                shard.unlock();
            }
        });
        this.shardArray.free();
        this.heap.memoryBlockFromHandle(this.handle).freeMemory();
        this.handle = 0L;
    }

    private static String format(byte[] ba) {
        StringBuffer sb = new StringBuffer("[ ");
        for (int i = 0; i < ba.length; ++i) {
            sb.append(Byte.toUnsignedInt(ba[i]) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Shard<K> splitKeyRange(Map.Entry<KeyRange<K>, Shard<K>> entry, K bytes) {
        KeyRange<K> left;
        Shard newShard;
        KeyRange<K> oldRange = entry.getKey();
        Shard<K> oldShard = entry.getValue();
        LongArray longArray = this.shardArray;
        synchronized (longArray) {
            oldShard.lock();
            try {
                if (this.nShards == this.maxShards || entry.getValue().shard().size() < 1000L) {
                    Shard<K> shard = entry.getValue();
                    return shard;
                }
                KeyRange<K> right = oldRange;
                newShard = Transaction.create(this.heap, () -> {
                    Shard tempShard = new Shard(oldShard.shard().split());
                    this.shardArray.set(this.nShards, tempShard.shard().handle());
                    return tempShard;
                });
                ++this.nShards;
                left = this.createKeyRange(oldShard.shard().lastKey());
                this.rangeToShardMap.put(left, oldShard);
                this.rangeToShardMap.put(right, newShard);
            }
            finally {
                oldShard.unlock();
            }
        }
        if (left.contains(bytes)) {
            return oldShard;
        }
        return newShard;
    }

    private KeyRange<K> createKeyRange(K high) {
        return new KeyRange<K>(high, this.comparator);
    }

    void printRangeMap() {
        for (Map.Entry<KeyRange<K>, Shard<K>> entry : this.rangeToShardMap.entrySet()) {
            System.out.println(entry.getKey() + " size " + entry.getValue().shard().size());
        }
    }

    private Shard<K> maybeSplit(Map.Entry<KeyRange<K>, Shard<K>> entry, K key) {
        if (this.nShards == this.maxShards || entry.getValue().shard().size() < 1000L) {
            return entry.getValue();
        }
        return this.splitKeyRange(entry, key);
    }

    public class SequentialShardIterator<E>
    implements AutoCloseableIterator<E> {
        Iterator<Shard<K>> shardIterator;
        Function<Shardable<K>, Iterator<E>> f;
        Iterator<E> shardEntryIter;
        Shard<K> currentShard;
        E currentEntry;
        E nextEntry;
        boolean reversed;

        public SequentialShardIterator(Shard<K> shard, Function<Shardable<K>, Iterator<E>> f) {
            this.shardIterator = null;
            this.f = f;
            this.currentShard = shard;
            this.currentShard.lock();
            this.shardEntryIter = f.apply(this.currentShard.shard());
            this.nextEntry = this.shardEntryIter != null && this.shardEntryIter.hasNext() ? this.shardEntryIter.next() : null;
            Object v0 = this.nextEntry;
            if (this.nextEntry == null) {
                this.currentShard.unlock();
            }
        }

        public SequentialShardIterator(Iterator<Shard<K>> shardIterator, Function<Shardable<K>, Iterator<E>> f) {
            this.shardIterator = shardIterator;
            this.f = f;
            if (shardIterator.hasNext()) {
                this.currentShard = shardIterator.next();
                this.currentShard.lock();
                this.shardEntryIter = f.apply(this.currentShard.shard());
                this.nextEntry = this.shardEntryIter != null && this.shardEntryIter.hasNext() ? this.shardEntryIter.next() : null;
                Object v0 = this.nextEntry;
                if (this.nextEntry == null && this.currentShard != null && this.currentShard.isLocked()) {
                    this.currentShard.unlock();
                }
            }
        }

        @Override
        public E next() {
            this.currentEntry = this.nextEntry;
            if (this.currentEntry == null) {
                throw new NoSuchElementException("Null");
            }
            this.nextEntry = this.shardEntryIter != null && this.shardEntryIter.hasNext() ? this.shardEntryIter.next() : null;
            Object v0 = this.nextEntry;
            if (this.nextEntry == null && this.shardIterator != null && this.shardIterator.hasNext()) {
                this.currentShard.unlock();
                this.currentShard = this.shardIterator.next();
                this.currentShard.lock();
                this.shardEntryIter = this.f.apply(this.currentShard.shard());
                this.nextEntry = this.shardEntryIter.hasNext() ? this.shardEntryIter.next() : null;
                Object v1 = this.nextEntry;
                if (this.nextEntry == null && this.currentShard != null && this.currentShard.isLocked()) {
                    this.currentShard.unlock();
                }
            }
            return this.currentEntry;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public void close() {
            if (this.currentShard != null && this.currentShard.isLocked()) {
                this.currentShard.unlock();
            }
        }
    }

    class Shard<K> {
        DynamicShardable<K> shard;
        ReentrantLock lock;

        Shard(DynamicShardable<K> shard) {
            this.shard = shard;
            this.lock = new ReentrantLock(false);
        }

        public DynamicShardable<K> shard() {
            return this.shard;
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean isLocked() {
            return this.lock.isLocked();
        }
    }

    static class KeyRange<K>
    implements Comparable<KeyRange<K>> {
        private K high;
        public static final Object END_RANGE = new Object();
        private final Comparator<K> c;

        public KeyRange(Comparator<K> c) {
            this.high = END_RANGE;
            this.c = c;
        }

        public KeyRange(K high, Comparator<K> c) {
            this.high = high;
            this.c = c;
        }

        public K high() {
            return this.high;
        }

        public boolean contains(K key) {
            if (this.high == END_RANGE) {
                return true;
            }
            boolean b = KeyRange.compare(this.c, key, this.high) <= 0;
            return b;
        }

        @Override
        public int compareTo(KeyRange<K> b) {
            if (this.high.equals(b.high)) {
                return 0;
            }
            if (b.high.equals(END_RANGE)) {
                return -1;
            }
            if (this.high.equals(END_RANGE)) {
                return 1;
            }
            return KeyRange.compare(this.c, this.high, b.high);
        }

        static <K> int compare(Comparator<K> c, K a, K b) {
            return c != null ? c.compare(a, b) : ((Comparable)a).compareTo(b);
        }

        public K asKey() {
            return this.high;
        }

        public int hashCode() {
            return this.high.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyRange)) {
                return false;
            }
            KeyRange other = (KeyRange)obj;
            return this.c != null ? this.c.compare(this.high, other.high) == 0 : this.high.equals(other.high);
        }

        public String toString() {
            if (this.high == END_RANGE) {
                return "END_RANGE";
            }
            return DynamicSharder.format((byte[])this.high);
        }
    }
}

