/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;

public class IntArray {
    private static final int SHIFT_BITS = 2;
    private final AnyMemoryBlock arrayBlock;
    private static final long VERSION_OFFSET = 0L;
    private static final long DATA_OFFSET = 8L;
    private static final short VERSION = 100;

    public static IntArray fromHandle(AnyHeap heap, long handle) {
        AnyMemoryBlock arrayBlock = heap.memoryBlockFromHandle(handle);
        return new IntArray(heap, arrayBlock);
    }

    public IntArray(AnyHeap heap, long size) {
        this.arrayBlock = heap.allocateMemoryBlock(4L * size + 8L);
        this.arrayBlock.setShort(0L, (short)100);
    }

    private IntArray(AnyHeap heap, AnyMemoryBlock arrayBlock) {
        this.arrayBlock = arrayBlock;
    }

    private long elementOffset(long index) {
        return 8L + 4L * index;
    }

    public void set(long index, int value) {
        if (index < 0L || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.arrayBlock.setInt(this.elementOffset(index), value);
    }

    public int get(long index) {
        if (index < 0L || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.arrayBlock.getInt(this.elementOffset(index));
    }

    public long size() {
        return this.arrayBlock.size() - 8L >> 2;
    }

    public long handle() {
        return this.arrayBlock.handle();
    }

    public void free() {
        this.arrayBlock.freeMemory();
    }

    public boolean equals(Object obj) {
        return obj instanceof IntArray && ((IntArray)obj).arrayBlock.equals(this.arrayBlock);
    }

    public int hashCode() {
        return this.arrayBlock.hashCode();
    }
}

