/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.HeapException;
import com.intel.pmem.llpl.Range;
import com.intel.pmem.llpl.util.DynamicShardable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LongART
implements DynamicShardable<byte[]> {
    final AnyHeap heap;
    private Root root;
    private int maxKeyLen;
    private long count = 0L;
    private byte[] lastKey;
    private static final short VERSION = 100;

    public LongART(AnyHeap heap) {
        LongART.registerAllocationClasses(heap);
        this.heap = heap;
        this.root = new Root(heap);
        this.root.setVersion((short)100);
    }

    static void registerAllocationClasses(AnyHeap heap) {
        heap.registerAllocationSize(24L, true);
        heap.registerAllocationSize(52L, true);
        heap.registerAllocationSize(160L, true);
        heap.registerAllocationSize(656L, true);
        heap.registerAllocationSize(2072L, true);
    }

    private LongART(AnyHeap heap, long handle) {
        if (handle <= 0L) {
            throw new IllegalArgumentException("Invalid artree handle: " + handle);
        }
        LongART.registerAllocationClasses(heap);
        this.heap = heap;
        this.root = (Root)Node.rebuild(heap, handle);
        this.count = this.root.getCount();
        this.maxKeyLen = this.root.getMaxKeyLength();
    }

    public static LongART fromHandle(AnyHeap heap, long handle) {
        return new LongART(heap, handle);
    }

    @Override
    public long handle() {
        return this.root.handle();
    }

    @Override
    public void free() {
        this.root.free();
    }

    static int compareUnsigned(byte b1, byte b2) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(b1), Byte.toUnsignedInt(b2));
    }

    @Override
    public long size() {
        return this.root.getCount();
    }

    public int hashCode() {
        return this.root.mb.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LongART && ((LongART)obj).root.mb.equals(this.root.mb);
    }

    private void incrementCount() {
        this.root.incrementCount();
        ++this.count;
    }

    private void decrementCount() {
        this.root.decrementCount();
        --this.count;
    }

    private void setMaxKeyLength(int length) {
        this.maxKeyLen = length;
        this.root.setMaxKeyLength(this.maxKeyLen);
    }

    public byte[] firstKey() {
        Node n = this.root.getChild();
        if (n == null) {
            throw new NoSuchElementException();
        }
        ByteBuffer firstKey = ByteBuffer.allocate(this.maxKeyLen);
        SearchHelper h = (parent, child, radix, cleanerFunction) -> {
            byte[] ba = parent.getPrefix();
            if (ba.length > 0) {
                firstKey.put(ba);
            }
            if (radix != null) {
                firstKey.put(radix);
            }
            if (child != null && child.isLeaf()) {
                firstKey.put(child.getPrefix());
            }
        };
        this.search2(n, new byte[0], 0, h, null, false);
        return Arrays.copyOf(firstKey.array(), firstKey.position());
    }

    @Override
    public byte[] lastKey() {
        Node n = this.root.getChild();
        if (n == null) {
            throw new NoSuchElementException();
        }
        ByteBuffer lastKey = ByteBuffer.allocate(this.maxKeyLen);
        SearchHelper h = (parent, child, radix, cleanerFunction) -> {
            byte[] ba = parent.getPrefix();
            if (ba.length > 0) {
                lastKey.put(ba);
            }
            if (radix != null) {
                lastKey.put(radix);
            }
            if (child != null && child.isLeaf()) {
                lastKey.put(child.getPrefix());
            }
        };
        this.search2(n, new byte[0], 0, h, null, true);
        return Arrays.copyOf(lastKey.array(), lastKey.position());
    }

    public long put(byte[] key, long value) {
        return this.put(key, value, (a, b) -> value);
    }

    public long put(byte[] key, Object newValue, BiFunction<Object, Long, Long> mergeFunction) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (key.length > this.maxKeyLen) {
            this.setMaxKeyLength(key.length);
        }
        return this.heap.execute(() -> this.insert(this.root, this.root.getChild(), key, newValue, 0, 0, mergeFunction));
    }

    private long insert(Node parent, Node node, byte[] key, Object value, int depth, int replaceIndex, BiFunction<Object, Long, Long> merge) {
        long oldValue;
        if (node == null) {
            long leafValue = merge.apply(value, 0L);
            Root rt = (Root)parent;
            Node leaf = SimpleLeaf.create(this.heap, key, 0, key.length, leafValue);
            rt.addChild(leaf);
            this.incrementCount();
            return 0L;
        }
        byte[] newPrefix = new byte[8];
        byte[] prefix = node.getPrefix();
        if (node.isLeaf()) {
            int i;
            int matchedLength = node.checkPrefix(key, depth);
            if (matchedLength == node.getPrefixLength() && matchedLength + depth == key.length) {
                long old = ((Leaf)node).getValue();
                long newVal = merge.apply(value, old);
                if (newVal != old) {
                    ((Leaf)node).setValue(newVal);
                }
                return old;
            }
            long newVal = merge.apply(value, 0L);
            for (i = 0; i < key.length - depth && i < prefix.length && key[i + depth] == prefix[i]; ++i) {
                newPrefix[i] = key[i + depth];
            }
            node.updatePrefix(prefix, i + 1, node.getPrefixLength() - i - 1);
            int prefixLength = key.length - depth - i - 1;
            Node newChild = SimpleLeaf.create(this.heap, key, depth + i + 1, prefixLength, newVal);
            Node4 newNode = depth + i == key.length ? new Node4(this.heap, newPrefix, i, true, newChild, 0, node, prefix[i]) : (i == prefix.length ? new Node4(this.heap, newPrefix, i, true, (Leaf)node, 0, newChild, key[depth + i]) : new Node4(this.heap, newPrefix, i, false, newChild, key[depth + i], node, prefix[i]));
            if (parent == this.root) {
                ((Root)parent).addChild(newNode);
            } else {
                ((InternalNode)parent).putChildAtIndex(replaceIndex, newNode);
            }
            this.incrementCount();
            return 0L;
        }
        InternalNode intNode = (InternalNode)node;
        int matchedLength = intNode.checkPrefix(key, depth);
        if (matchedLength != intNode.getPrefixLength()) {
            int i;
            long leafVal = merge.apply(value, 0L);
            for (i = 0; i < matchedLength; ++i) {
                newPrefix[i] = prefix[i];
            }
            intNode.updatePrefix(prefix, i + 1, intNode.getPrefixLength() - i - 1);
            int prefixLength = key.length - depth - i - 1;
            Node newChild = SimpleLeaf.create(this.heap, key, depth + i + 1, prefixLength, leafVal);
            Node4 newNode = depth + i == key.length ? new Node4(this.heap, newPrefix, matchedLength, true, newChild, 0, node, prefix[i]) : new Node4(this.heap, newPrefix, matchedLength, false, newChild, key[depth + i], node, prefix[i]);
            if (parent == this.root) {
                ((Root)parent).addChild(newNode);
            } else {
                ((InternalNode)parent).putChildAtIndex(replaceIndex, newNode);
            }
            this.incrementCount();
            return 0L;
        }
        if ((depth += intNode.getPrefixLength()) == key.length) {
            long old = 0L;
            Leaf child = intNode.findBlankRadixChild();
            if (child != null) {
                long newVal;
                old = child.getValue();
                if (old != (newVal = merge.apply(value, old).longValue())) {
                    child.setValue(newVal);
                }
            } else {
                long newVal = merge.apply(value, 0L);
                child = new SimpleLeaf(this.heap, newVal);
                if (!intNode.addBlankRadixChild(child)) {
                    InternalNode newNode = intNode.grow(child, Optional.empty());
                    ((InternalNode)parent).putChildAtIndex(replaceIndex, newNode);
                    intNode.free();
                }
                this.incrementCount();
            }
            return old;
        }
        int childIndex = intNode.findChildIndex(key[depth]);
        Node next = intNode.getChildAtIndex(childIndex);
        if (next != null) {
            oldValue = this.insert(node, next, key, value, depth + 1, childIndex, merge);
        } else {
            int prefixLength = key.length - depth - 1;
            oldValue = 0L;
            long leafVal = merge.apply(value, 0L);
            Node newChild = SimpleLeaf.create(this.heap, key, depth + 1, prefixLength, leafVal);
            if (!intNode.addChild(key[depth], newChild)) {
                InternalNode newNode = intNode.grow(newChild, Optional.of(key[depth]));
                if (parent == this.root) {
                    ((Root)parent).addChild(newNode);
                } else {
                    ((InternalNode)parent).putChildAtIndex(replaceIndex, newNode);
                }
                intNode.free();
            }
            this.incrementCount();
        }
        return oldValue;
    }

    public long get(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        Node node = this.root.getChild();
        if (node != null) {
            return this.search(this.root.getChild(), key, 0, null, null);
        }
        return 0L;
    }

    byte[] splitKey() {
        EntryIterator it = new EntryIterator();
        long midPos = this.count / 2L;
        int i = 0;
        byte[] splitKey = null;
        while (it.hasNext()) {
            if ((long)i++ < midPos) {
                it.next();
                continue;
            }
            splitKey = it.next().getKey();
            break;
        }
        return splitKey;
    }

    public LongART split() {
        EntryIterator it = new EntryIterator();
        long midPos = this.count / 2L;
        int i = 0;
        byte[] splitKey = null;
        while (it.hasNext()) {
            if ((long)i++ < midPos) {
                it.next();
                continue;
            }
            splitKey = it.next().getKey();
            break;
        }
        if (splitKey == null) {
            return null;
        }
        return this.split(splitKey);
    }

    LongART split(byte[] splitKey) {
        long newcount;
        if (splitKey == null || splitKey.length == 0) {
            throw new IllegalArgumentException("Invalid splitKey");
        }
        LongART newTree = new LongART(this.heap);
        Root newRoot = newTree.root;
        SearchHelper splitFunc = (parent, child, radix, c) -> {
            if (child.isLeaf()) {
                if (radix == -1) {
                    return;
                }
                InternalNode s = ((InternalNode)parent).split(radix = Byte.valueOf((byte)(radix + 1)), true);
                if (s.getChildrenCount() != 0) {
                    newRoot.addChild(s);
                } else {
                    s.free();
                }
            } else {
                InternalNode s;
                Node rc = newRoot.getChild();
                if (rc == null) {
                    if (radix == -1) {
                        return;
                    }
                    radix = (byte)(radix + 1);
                    s = ((InternalNode)parent).split(radix, true);
                } else {
                    s = ((InternalNode)parent).split(radix, false);
                    s.updateChild(rc, radix);
                }
                if (s.getChildrenCount() != 0) {
                    newRoot.addChild(s);
                } else {
                    s.free();
                }
            }
        };
        this.search(this.root.getChild(), splitKey, 0, splitFunc, null);
        this.count = newcount = 1L + this.root.getCount() / 2L;
        this.root.setCount(newcount);
        newRoot.setCount(newcount - 2L);
        newTree.count = newcount - 2L;
        newTree.setMaxKeyLength(this.maxKeyLen);
        return newTree;
    }

    void mergeTree(LongART tree) {
        Node node = tree.root.getChild();
        if (node != null && !node.isLeaf()) {
            InternalNode from = (InternalNode)node;
            InternalNode to = (InternalNode)this.root.getChild();
            if (to == null) {
                this.root.addChild(from);
                return;
            }
            NodeEntry[] children = from.getEntries();
            for (int i = 0; i < children.length; ++i) {
                if (to.addChild(children[i].radix, children[i].child)) continue;
                InternalNode newNode = to.grow(children[i].child, Optional.of(children[i].radix));
                this.root.addChild(newNode);
                to.free();
                to = newNode;
            }
        }
    }

    private long search2(Node node, byte[] key, int depth, SearchHelper helper, Consumer<Long> c, boolean reversed) {
        long l;
        int matchedLength;
        if (node == null) {
            return 0L;
        }
        int n = matchedLength = key.length == 0 ? node.getPrefixLength() : node.checkPrefix(key, depth);
        if (matchedLength != node.getPrefixLength()) {
            return -1L;
        }
        if (node.isLeaf()) {
            return depth + matchedLength == key.length ? ((SimpleLeaf)node).getValue() : 0L;
        }
        depth += matchedLength;
        if (key.length == 0) {
            Leaf next;
            boolean blank;
            InternalNode n2 = (InternalNode)node;
            byte b = 0;
            if (reversed) {
                Node node2;
                boolean bl = blank = n2.hasBlankRadixChild() && n2.getChildrenCount() == 1;
                if (blank) {
                    node2 = n2.findBlankRadixChild();
                } else {
                    b = n2.findHighestRadix();
                    node2 = n2.findChild(b);
                }
                next = node2;
            } else {
                Node node3;
                blank = n2.hasBlankRadixChild();
                if (blank) {
                    node3 = n2.findBlankRadixChild();
                } else {
                    b = n2.findLowestRadix();
                    node3 = next = n2.findChild(b);
                }
            }
            if (helper != null) {
                helper.apply(node, next, blank ? null : Byte.valueOf(b), c);
            }
            l = this.search2(next, key, blank ? depth : depth + 1, helper, c, reversed);
        } else {
            Leaf next;
            boolean blank = depth == key.length;
            Node node4 = next = blank ? ((InternalNode)node).findBlankRadixChild() : ((InternalNode)node).findChild(key[depth]);
            if (helper != null) {
                helper.apply(node, next, blank ? null : Byte.valueOf(key[Math.min(depth, key.length - 1)]), c);
            }
            l = this.search2(next, key, blank ? depth : depth + 1, helper, c, reversed);
        }
        return l;
    }

    private long search(Node node, byte[] key, int depth, SearchHelper helper, Consumer<Long> c) {
        if (node == null) {
            return 0L;
        }
        int matchedLength = node.checkPrefix(key, depth);
        if (matchedLength != node.getPrefixLength()) {
            return 0L;
        }
        if (node.isLeaf()) {
            return depth + matchedLength == key.length ? ((SimpleLeaf)node).getValue() : 0L;
        }
        boolean blank = (depth += matchedLength) == key.length;
        Leaf next = blank ? ((InternalNode)node).findBlankRadixChild() : ((InternalNode)node).findChild(key[depth]);
        long l = this.search(next, key, blank ? depth : depth + 1, helper, c);
        if (helper != null) {
            helper.apply(node, next, blank ? null : Byte.valueOf(key[Math.min(depth, key.length - 1)]), c);
        }
        return l;
    }

    void statsPrint() {
        System.out.println("Printing Stats .Printing Stats ...");
        Node node = this.root.getChild();
        if (node != null) {
            node.statsPrint(0);
        }
        System.out.println("");
    }

    void print() {
        Node node = this.root.getChild();
        if (node != null) {
            node.print(0);
        }
        System.out.println("");
    }

    public void clear(Consumer<Long> cleanerFunction) {
        if (cleanerFunction == null) {
            throw new IllegalArgumentException("cleaner function cannot be null");
        }
        this.heap.execute(() -> {
            this.root.destroy(cleanerFunction);
            this.count = 0L;
        });
    }

    void deleteNodes(Node parent, Node child, Byte radix, Consumer<Long> cleanerFunction) {
        this.heap.execute(() -> {
            if (child == null) {
                return;
            }
            if (child.isLeaf()) {
                if (cleanerFunction != null) {
                    cleanerFunction.accept(((SimpleLeaf)child).getValue());
                }
                child.free();
                ((InternalNode)parent).deleteChild(radix);
                this.decrementCount();
            } else if (((InternalNode)child).getChildrenCount() == 0) {
                child.free();
                ((InternalNode)parent).deleteChild(radix);
            }
        });
    }

    public long remove(byte[] key, Consumer<Long> cleanerFunction) {
        if (cleanerFunction == null) {
            throw new NullPointerException("cleaner function cannot be null");
        }
        if (key.length == 0) {
            throw new IllegalArgumentException("Invalid key");
        }
        return this.search(this.root.getChild(), key, 0, this::deleteNodes, cleanerFunction);
    }

    public Iterator<Long> getValueIterator() {
        return new ValueIterator();
    }

    public Iterator<Entry> getEntryIterator() {
        return new EntryIterator();
    }

    public Iterator<Entry> getReverseEntryIterator() {
        return new EntryIterator(true);
    }

    public Iterator<Entry> getReverseEntryIterator(byte[] firstKey, boolean firstInclusive, byte[] lastKey, boolean lastInclusive) {
        if (firstKey == null || firstKey.length == 0 || lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(firstKey, firstInclusive, lastKey, lastInclusive, true);
    }

    public Iterator<Entry> getHeadEntryIterator(byte[] lastKey, boolean lastInclusive) {
        if (lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(lastKey, lastInclusive);
    }

    public Iterator<Entry> getTailEntryIterator(byte[] firstKey, boolean firstInclusive) {
        if (firstKey == null || firstKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(firstKey, firstInclusive, null, false, false);
    }

    public Iterator<Entry> getEntryIterator(byte[] firstKey, boolean firstInclusive, byte[] lastKey, boolean lastInclusive) {
        if (firstKey == null || firstKey.length == 0 || lastKey == null || lastKey.length == 0) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(firstKey, firstInclusive, lastKey, lastInclusive, false);
    }

    static class Node256
    extends InternalNode {
        protected static final long SIZE = 2072L;
        private static final long CHILDREN_OFFSET = 16L;
        private static final int BLANK_RADIX_CHILD_INDEX = 256;
        private static final int MAX_CAPACITY = 257;

        Node256(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        Node256(AnyHeap heap) {
            super(heap, 2072L, range -> range.setByte(0L, (byte)3));
        }

        Node256(AnyHeap heap, Node48 oldNode, Node newNode, Optional<Byte> radix) {
            super(heap, 2072L, range -> {
                range.setByte(0L, (byte)3);
                range.copyFromMemoryBlock(oldNode.mb, 1L, 1L, 15L);
                byte[] oldRadices = oldNode.getRadices();
                byte blankIndex = oldNode.getBlankRadixIndex();
                for (int index = 0; index < oldRadices.length; ++index) {
                    if (oldRadices[index] != 0) {
                        range.setLong(16L + (long)(index * 8), oldNode.findValueAtIndex(oldRadices[index] - 1));
                    }
                    if (index != blankIndex) continue;
                    range.setLong(2064L, oldNode.findValueAtIndex(blankIndex));
                    range.setByte(1L, (byte)-1);
                }
                if (radix.isPresent()) {
                    range.setLong(16L + (long)(Byte.toUnsignedInt((Byte)radix.get()) * 8), newNode.handle());
                } else {
                    range.setLong(2064L, newNode.handle());
                }
                range.setShort(2L, (short)49);
            });
        }

        Node256 duplicate() {
            AnyMemoryBlock dmb = this.heap.allocateCompactMemoryBlock(2072L, rng -> rng.copyFromMemoryBlock(this.mb, 0L, 0L, 2072L));
            return new Node256(this.heap, dmb);
        }

        @Override
        boolean hasBlankRadixChild() {
            return this.findValueAtIndex(256) != 0L;
        }

        @Override
        Leaf findBlankRadixChild() {
            long val = this.findValueAtIndex(256);
            return val == 0L ? null : (Leaf)Node.rebuild(this.heap, val);
        }

        @Override
        boolean addBlankRadixChild(Leaf child) {
            if (!this.hasBlankRadixChild()) {
                this.putChildAtIndex(256, child);
                this.incChildrenCount();
            }
            return true;
        }

        @Override
        protected byte[] getRadices() {
            return null;
        }

        @Override
        NodeEntry[] getEntries() {
            NodeEntry[] entries = new NodeEntry[this.getChildrenCount()];
            int index = 0;
            Leaf blankChild = this.findBlankRadixChild();
            if (blankChild != null) {
                entries[index++] = new NodeEntry(0, blankChild);
            }
            for (int i = 0; i < 256; ++i) {
                long val = this.findValueAtIndex(i);
                if (val == 0L) continue;
                entries[index++] = new NodeEntry((byte)i, Node.rebuild(this.heap, val));
            }
            return entries;
        }

        @Override
        boolean addChild(byte radix, Node node) {
            int index = this.findChildIndex(radix);
            if (index == -1) {
                this.incChildrenCount();
                index = Byte.toUnsignedInt(radix);
            }
            this.putChildAtIndex(index, node);
            return true;
        }

        @Override
        void deleteChild(Byte radix) {
            int index = radix == null ? 256 : this.findChildIndex(radix);
            if (index != -1) {
                this.mb.setLong(16L + (long)(index * 8), 0L);
                this.decChildrenCount();
            }
        }

        @Override
        byte findLowestRadix() {
            byte lowest = 127;
            for (int i = 0; i < 256; ++i) {
                if (this.findValueAtIndex(i) == 0L) continue;
                lowest = (byte)i;
                break;
            }
            return lowest;
        }

        @Override
        byte findHighestRadix() {
            byte highest = -128;
            for (int i = 255; i >= 0; --i) {
                if (this.findValueAtIndex(i) == 0L) continue;
                highest = (byte)i;
                break;
            }
            return highest;
        }

        @Override
        Node findChild(byte radix) {
            return this.getChildAtIndex(Byte.toUnsignedInt(radix));
        }

        @Override
        int findChildIndex(byte radix) {
            int index = Byte.toUnsignedInt(radix);
            return this.findValueAtIndex(index) == 0L ? -1 : index;
        }

        @Override
        protected long findValueAtIndex(int index) {
            if (index == -1) {
                return 0L;
            }
            return this.mb.getLong(16L + (long)(index * 8));
        }

        @Override
        void putChildAtIndex(int index, Node child) {
            this.mb.setLong(16L + (long)(index * 8), child.handle());
        }

        @Override
        protected short capacity() {
            return 257;
        }

        @Override
        InternalNode grow(Node child, Optional<Byte> radix) {
            return null;
        }

        @Override
        InternalNode split(Byte radix, boolean first) {
            Node256 newNode = new Node256(this.heap);
            if (radix == null) {
                newNode.mb.withRange(0L, 2072L, rng -> {
                    rng.copyFromMemoryBlock(this.mb, 16L, 16L, 2048L);
                    rng.setShort(2L, (short)(this.getChildrenCount() - 1));
                });
                this.mb.withRange(0L, 2072L, rng -> {
                    rng.setMemory((byte)0, 16L, 16384L);
                    rng.setShort(2L, (short)1);
                });
            } else {
                for (int i = Byte.toUnsignedInt(radix); i < 256; ++i) {
                    if (this.findValueAtIndex(i) == 0L) continue;
                    newNode.putChildAtIndex(i, this.getChildAtIndex(i));
                    newNode.incChildrenCount();
                    if (!first && i == Byte.toUnsignedInt(radix)) continue;
                    this.deleteChild((byte)i);
                }
                if (newNode.findValueAtIndex(Byte.toUnsignedInt(radix) - 1) != 0L) {
                    throw new RuntimeException();
                }
            }
            if (this.getPrefixLength() > 0) {
                newNode.setPrefixLength(this.getPrefixLength());
                newNode.setPrefix(this.getPrefix());
            }
            return newNode;
        }

        @Override
        void printStatsChildren(StringBuilder start, int depth) {
            int i;
            for (i = 0; i < this.capacity(); ++i) {
                Node node;
                if (this.findValueAtIndex(i) == 0L || (node = this.getChildAtIndex(i)) == null) continue;
                node.statsPrint(depth + 1);
            }
            if (i != this.capacity()) {
                throw new RuntimeException("Node 256, Empty child or childrencount is wrong");
            }
        }

        @Override
        void printChildren(StringBuilder start, int depth) {
            for (int i = 0; i < this.capacity(); ++i) {
                if (this.findValueAtIndex(i) == 0L) continue;
                System.out.println(start + "For radix " + new String(new byte[]{(byte)(i - 128)}) + "(" + (i - 128) + "):");
                Node node = this.getChildAtIndex(i);
                if (node == null) continue;
                node.print(depth + 1);
            }
        }
    }

    static class Node48
    extends InternalNode {
        private static final int MAX_CAPACITY = 48;
        private static final int MAX_RADICES = 256;
        protected static final long SIZE = 656L;
        private static final long RADIX_OFFSET = 16L;
        static final long CHILDREN_OFFSET = 272L;
        private byte[] radices;

        Node48(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        Node48(AnyHeap heap) {
            super(heap, 656L, range -> range.setByte(0L, (byte)2));
        }

        Node48(AnyHeap heap, Node16 oldNode, Node newNode, Optional<Byte> radix) {
            super(heap, 656L, range -> {
                range.setByte(0L, (byte)2);
                range.copyFromMemoryBlock(oldNode.mb, 1L, 1L, 15L);
                byte blankRadixIndex = oldNode.getBlankRadixIndex();
                byte[] oldRadices = oldNode.getRadices();
                StringBuffer radices = new StringBuffer("radics: ");
                for (int index = 0; index < oldRadices.length; ++index) {
                    if (index == blankRadixIndex) continue;
                    range.setByte(16L + (long)Byte.toUnsignedInt(oldRadices[index]), (byte)(index + 1));
                    radices.append(" " + oldRadices[index]);
                }
                range.copyFromMemoryBlock(oldNode.mb, 32L, 272L, oldNode.capacity() * 8);
                if (radix.isPresent()) {
                    range.setByte(16L + (long)Byte.toUnsignedInt((Byte)radix.get()), (byte)17);
                } else {
                    range.setByte(1L, (byte)16);
                }
                range.setLong(400L, newNode.handle());
                range.setShort(2L, (short)17);
            });
        }

        Node48 duplicate() {
            AnyMemoryBlock dmb = this.heap.allocateCompactMemoryBlock(656L, rng -> rng.copyFromMemoryBlock(this.mb, 0L, 0L, 656L));
            return new Node48(this.heap, dmb);
        }

        @Override
        protected byte[] getRadices() {
            if (this.radices == null) {
                byte[] radices = new byte[256];
                this.mb.copyToArray(16L, radices, 0, 256);
                this.radices = radices;
            }
            return this.radices;
        }

        void addRadix(byte radix, int index) {
            this.mb.setByte(16L + (long)index, radix);
        }

        @Override
        NodeEntry[] getEntries() {
            byte[] radices = this.getRadices();
            NodeEntry[] entries = new NodeEntry[this.getChildrenCount()];
            byte blankIndex = this.getBlankRadixIndex();
            int index = 0;
            if (blankIndex != -1) {
                entries[index++] = new NodeEntry(0, this.getChildAtIndex(blankIndex));
            }
            for (int i = 0; i < 256; ++i) {
                if (radices[i] == 1 + blankIndex || radices[i] == 0) continue;
                entries[index++] = new NodeEntry((byte)i, this.getChildAtIndex(radices[i] - 1));
            }
            return entries;
        }

        @Override
        boolean addChild(byte radix, Node node) {
            int index = this.findChildIndex(radix);
            if (index == -1) {
                if (this.getChildrenCount() >= 48) {
                    return false;
                }
                index = this.getChildrenCount();
                this.incChildrenCount();
                this.addRadix((byte)(index + 1), Byte.toUnsignedInt(radix));
            }
            this.putChildAtIndex(index, node);
            this.radices = null;
            return true;
        }

        @Override
        void deleteChild(Byte radix) {
            int index = radix == null ? this.clearBlankRadixFlag() : this.findChildIndex(radix);
            if (index != -1) {
                this.mb.withRange(0L, 656L, range -> {
                    if (radix != null) {
                        range.setByte(16L + (long)Byte.toUnsignedInt(radix), (byte)0);
                    }
                    this.decChildrenCount();
                    short childrenCount = this.getChildrenCount();
                    if (childrenCount == index) {
                        range.setLong(272L + (long)(childrenCount * 8), 0L);
                    } else {
                        range.setLong(272L + (long)(index * 8), this.mb.getLong(272L + (long)(childrenCount * 8)));
                        range.setLong(272L + (long)(childrenCount * 8), 0L);
                        byte[] radices = this.getRadices();
                        for (int i = 0; i < radices.length; ++i) {
                            if (radices[i] != childrenCount + 1) continue;
                            range.setByte(16L + (long)i, (byte)(index + 1));
                            break;
                        }
                    }
                    this.radices = null;
                });
            }
        }

        @Override
        byte findLowestRadix() {
            byte lowest = 127;
            byte[] radices = this.getRadices();
            for (int i = 0; i < 256; ++i) {
                if (radices[i] == 0) continue;
                lowest = (byte)i;
                break;
            }
            return lowest;
        }

        @Override
        byte findHighestRadix() {
            byte highest = -128;
            byte[] radices = this.getRadices();
            for (int i = 255; i >= 0; --i) {
                if (radices[i] == 0) continue;
                highest = (byte)i;
                break;
            }
            return highest;
        }

        @Override
        int findChildIndex(byte radix) {
            int index;
            byte[] radices = this.getRadices();
            return radices[index = Byte.toUnsignedInt(radix)] == 0 ? -1 : radices[index] - 1;
        }

        @Override
        protected long findValueAtIndex(int index) {
            if (index == -1) {
                return 0L;
            }
            return this.mb.getLong(272L + (long)(8 * index));
        }

        @Override
        void putChildAtIndex(int index, Node child) {
            if (index == -1) {
                return;
            }
            this.mb.setLong(272L + (long)(index * 8), child.handle());
        }

        @Override
        protected short capacity() {
            return 48;
        }

        @Override
        InternalNode grow(Node child, Optional<Byte> radix) {
            return new Node256(this.heap, this, child, radix);
        }

        @Override
        InternalNode split(Byte radix, boolean first) {
            int startIndex;
            int i;
            byte[] radices = this.getRadices();
            Node48 newNode = new Node48(this.heap);
            if (this.getPrefixLength() > 0) {
                newNode.setPrefixLength(this.getPrefixLength());
                newNode.setPrefix(this.getPrefix());
            }
            for (i = startIndex = radix == null ? 0 : Byte.toUnsignedInt(radix); i < 256; ++i) {
                if (radices[i] == 0) continue;
                newNode.addChild((byte)i, this.getChildAtIndex(radices[i] - 1));
            }
            radices = newNode.getRadices();
            int n = i = first ? startIndex : startIndex + 1;
            while (i < radices.length) {
                if (radices[i] != 0) {
                    this.deleteChild((byte)i);
                }
                ++i;
            }
            newNode.radices = null;
            this.radices = null;
            return newNode;
        }

        @Override
        void printChildren(StringBuilder start, int depth) {
            byte[] radices = this.getRadices();
            for (int i = 0; i < radices.length; ++i) {
                if (radices[i] == 0) continue;
                System.out.println(start + "For radix " + new String(new byte[]{(byte)(i - 128)}) + "(" + (i - 128) + "):");
                Node node = this.getChildAtIndex(radices[i] - 1);
                if (node == null) continue;
                node.print(depth + 1);
            }
        }
    }

    static class Node16
    extends InternalNode {
        protected static final long SIZE = 160L;
        private static final long RADIX_OFFSET = 16L;
        static final long CHILDREN_OFFSET = 32L;
        private static final int MAX_CAPACITY = 16;

        Node16(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        Node16(AnyHeap heap) {
            super(heap, 160L, range -> range.setByte(0L, (byte)1));
        }

        Node16(AnyHeap heap, Node4 oldNode, Node newNode, Optional<Byte> radix) {
            super(heap, 160L, range -> {
                range.setByte(0L, (byte)1);
                range.copyFromMemoryBlock(oldNode.mb, 1L, 1L, 15L);
                range.copyFromMemoryBlock(oldNode.mb, 48L, 16L, oldNode.capacity());
                range.copyFromMemoryBlock(oldNode.mb, 16L, 32L, oldNode.capacity() * 8);
                if (radix.isPresent()) {
                    range.setByte(20L, (Byte)radix.get());
                } else {
                    range.setByte(1L, (byte)4);
                }
                range.setLong(64L, newNode.handle());
                range.setShort(2L, (short)5);
            });
        }

        Node16 duplicate() {
            AnyMemoryBlock dmb = this.heap.allocateCompactMemoryBlock(160L, rng -> rng.copyFromMemoryBlock(this.mb, 0L, 0L, 160L));
            return new Node16(this.heap, dmb);
        }

        @Override
        protected byte[] getRadices() {
            byte[] ret = new byte[this.getChildrenCount()];
            if (ret.length == 0) {
                return ret;
            }
            this.mb.copyToArray(16L, ret, 0, ret.length);
            return ret;
        }

        @Override
        NodeEntry[] getEntries() {
            byte[] radices = this.getRadices();
            NodeEntry[] entries = new NodeEntry[radices.length];
            byte blankIndex = this.getBlankRadixIndex();
            int index = 0;
            if (blankIndex != -1) {
                entries[index++] = new NodeEntry(0, this.getChildAtIndex(blankIndex));
            }
            for (int i = 0; i < entries.length; ++i) {
                if (i == blankIndex) continue;
                entries[index++] = new NodeEntry(radices[i], this.getChildAtIndex(i));
            }
            Arrays.sort(entries, blankIndex != -1 ? 1 : 0, entries.length, (x, y) -> LongART.compareUnsigned(x.radix, y.radix));
            return entries;
        }

        void addRadix(byte radix, int index) {
            this.mb.setByte(16L + (long)index, radix);
        }

        @Override
        boolean addChild(byte radix, Node node) {
            int index = this.findChildIndex(radix);
            if (index == -1) {
                if (this.getChildrenCount() >= 16) {
                    return false;
                }
                index = this.getChildrenCount();
                this.incChildrenCount();
                this.addRadix(radix, index);
            }
            this.putChildAtIndex(index, node);
            return true;
        }

        @Override
        void deleteChild(Byte radix) {
            int index = radix == null ? this.clearBlankRadixFlag() : this.findChildIndex(radix);
            if (index != -1) {
                this.mb.withRange(16L, 160L - 16L, range -> {
                    this.decChildrenCount();
                    short childrenCount = this.getChildrenCount();
                    if (childrenCount == index) {
                        range.setLong(32L + (long)(childrenCount * 8), 0L);
                    } else {
                        range.setLong(32L + (long)(index * 8), this.mb.getLong(32L + (long)(childrenCount * 8)));
                        range.setLong(32L + (long)(childrenCount * 8), 0L);
                        range.setByte(16L + (long)index, this.mb.getByte(16L + (long)childrenCount));
                    }
                    range.setByte(16L + (long)childrenCount, (byte)0);
                });
            }
        }

        @Override
        int findChildIndex(byte radix) {
            byte[] radices = this.getRadices();
            byte blankIndex = this.getBlankRadixIndex();
            for (int i = 0; i < radices.length; ++i) {
                if (i == blankIndex || radices[i] != radix) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected long findValueAtIndex(int index) {
            if (index == -1) {
                return 0L;
            }
            return this.mb.getLong(32L + (long)(index * 8));
        }

        @Override
        void putChildAtIndex(int index, Node child) {
            if (index == -1) {
                return;
            }
            this.mb.setLong(32L + (long)(index * 8), child.handle());
        }

        @Override
        protected short capacity() {
            return 16;
        }

        @Override
        InternalNode grow(Node child, Optional<Byte> radix) {
            return new Node48(this.heap, this, child, radix);
        }

        @Override
        InternalNode split(Byte radix, boolean first) {
            int i;
            byte[] radices = this.getRadices();
            Node16 newNode = new Node16(this.heap);
            byte blankIndex = this.getBlankRadixIndex();
            for (i = 0; i < radices.length; ++i) {
                if (radix != null && i == blankIndex || radix != null && LongART.compareUnsigned(radices[i], radix) < 0) continue;
                newNode.addChild(radices[i], this.getChildAtIndex(i));
            }
            radices = newNode.getRadices();
            for (i = 0; i < radices.length; ++i) {
                if (!first && radices[i] == radix) continue;
                this.deleteChild(radices[i]);
            }
            if (this.getPrefixLength() > 0) {
                newNode.setPrefixLength(this.getPrefixLength());
                newNode.setPrefix(this.getPrefix());
            }
            return newNode;
        }
    }

    static class Node4
    extends InternalNode {
        protected static final long SIZE = 52L;
        static final long RADIX_OFFSET = 48L;
        static final long CHILDREN_OFFSET = 16L;
        private static final int MAX_CAPACITY = 4;

        Node4(AnyHeap heap) {
            super(heap, 52L, range -> range.setByte(0L, (byte)7));
        }

        Node4(AnyHeap heap, byte[] prefix, int start, int prefixLen, Node child, byte radix) {
            super(heap, 52L, range -> {
                range.setByte(0L, (byte)7);
                if (prefixLen > 0) {
                    if (prefixLen > 8) {
                        throw new IllegalArgumentException("Prefix more than 8 bytes");
                    }
                    range.setInt(4L, prefixLen);
                    range.copyFromArray(prefix, start, 8L, prefixLen);
                }
                range.setByte(48L, radix);
                range.setLong(16L, child.handle());
                range.setShort(2L, (short)1);
            });
        }

        Node4(AnyHeap heap, byte[] prefix, int prefixLen, boolean blank, Node child1, byte radix1, Node child2, byte radix2) {
            super(heap, 52L, range -> {
                range.setByte(0L, (byte)7);
                if (prefixLen > 0) {
                    if (prefixLen > 8) {
                        throw new IllegalArgumentException("Prefix more than 8 bytes");
                    }
                    range.setInt(4L, prefixLen);
                    range.copyFromArray(prefix, 0, 8L, prefixLen);
                }
                if (blank) {
                    range.setByte(1L, (byte)0);
                } else {
                    range.setByte(48L, radix1);
                }
                range.setByte(49L, radix2);
                range.setLong(16L, child1.handle());
                range.setLong(24L, child2.handle());
                range.setShort(2L, (short)2);
            });
        }

        Node4(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        Node4 duplicate() {
            AnyMemoryBlock dmb = this.heap.allocateCompactMemoryBlock(52L, rng -> rng.copyFromMemoryBlock(this.mb, 0L, 0L, 52L));
            return new Node4(this.heap, dmb);
        }

        @Override
        protected byte[] getRadices() {
            byte[] ret = new byte[this.getChildrenCount()];
            if (ret.length == 0) {
                return ret;
            }
            this.mb.copyToArray(48L, ret, 0, ret.length);
            return ret;
        }

        @Override
        NodeEntry[] getEntries() {
            byte[] radices = this.getRadices();
            NodeEntry[] entries = new NodeEntry[radices.length];
            byte blankIndex = this.getBlankRadixIndex();
            int index = 0;
            if (blankIndex != -1) {
                entries[index++] = new NodeEntry(0, (Leaf)this.getChildAtIndex(blankIndex));
            }
            for (int i = 0; i < entries.length; ++i) {
                if (i == blankIndex) continue;
                entries[index++] = new NodeEntry(radices[i], this.getChildAtIndex(i));
            }
            Arrays.sort(entries, blankIndex != -1 ? 1 : 0, entries.length, (x, y) -> LongART.compareUnsigned(x.radix, y.radix));
            return entries;
        }

        void addRadix(byte radix, int index) {
            this.mb.setByte(48L + (long)index, radix);
        }

        @Override
        boolean addChild(byte radix, Node node) {
            int index = this.findChildIndex(radix);
            if (index == -1) {
                if (this.getChildrenCount() >= 4) {
                    return false;
                }
                index = this.getChildrenCount();
                this.incChildrenCount();
                this.addRadix(radix, index);
            }
            this.putChildAtIndex(index, node);
            return true;
        }

        @Override
        void deleteChild(Byte radix) {
            int index = radix == null ? this.clearBlankRadixFlag() : this.findChildIndex(radix);
            if (index != -1) {
                this.mb.withRange(16L, 52L - 16L, range -> {
                    this.decChildrenCount();
                    short childrenCount = this.getChildrenCount();
                    if (childrenCount == index) {
                        range.setLong(16L + (long)(childrenCount * 8), 0L);
                    } else {
                        range.setLong(16L + (long)(index * 8), this.mb.getLong(16L + (long)(childrenCount * 8)));
                        range.setLong(16L + (long)(childrenCount * 8), 0L);
                        range.setByte(48L + (long)index, this.mb.getByte(48L + (long)childrenCount));
                    }
                    range.setByte(48L + (long)childrenCount, (byte)0);
                });
            }
        }

        @Override
        int findChildIndex(byte radix) {
            byte[] radices = this.getRadices();
            byte blankIndex = this.getBlankRadixIndex();
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                if (i == blankIndex || radices[i] != radix) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected long findValueAtIndex(int index) {
            if (index == -1) {
                return 0L;
            }
            return this.mb.getLong(16L + (long)(index * 8));
        }

        @Override
        void putChildAtIndex(int index, Node child) {
            this.mb.setLong(16L + (long)(index * 8), child.handle());
        }

        @Override
        protected short capacity() {
            return 4;
        }

        @Override
        InternalNode grow(Node child, Optional<Byte> radix) {
            return new Node16(this.heap, this, child, radix);
        }

        @Override
        InternalNode split(Byte radix, boolean first) {
            int i;
            byte[] radices = this.getRadices();
            Node4 newNode = new Node4(this.heap);
            byte blankIndex = this.getBlankRadixIndex();
            for (i = 0; i < radices.length; ++i) {
                if (radix != null && i == blankIndex || radix != null && LongART.compareUnsigned(radices[i], radix) < 0) continue;
                newNode.addChild(radices[i], this.getChildAtIndex(i));
            }
            radices = newNode.getRadices();
            for (i = 0; i < radices.length; ++i) {
                if (!first && radices[i] == radix) continue;
                this.deleteChild(radices[i]);
            }
            if (this.getPrefixLength() > 0) {
                newNode.setPrefixLength(this.getPrefixLength());
                newNode.setPrefix(this.getPrefix());
            }
            return newNode;
        }
    }

    static class SimpleLeaf
    extends Leaf {
        protected static final long SIZE = 24L;
        private static final long VALUE_OFFSET = 16L;

        SimpleLeaf(AnyHeap heap) {
            super(heap, 24L);
            this.initType((byte)4);
        }

        SimpleLeaf(AnyHeap heap, long value) {
            this(heap, new byte[]{0}, 0, 0, value);
        }

        SimpleLeaf(AnyHeap heap, byte[] prefix, int start, int length, long value) {
            super(heap, heap.allocateCompactMemoryBlock(24L, range -> {
                range.setByte(0L, (byte)4);
                if (length > 0) {
                    range.setInt(4L, length);
                    range.copyFromArray(prefix, start, 8L, length);
                }
                range.setLong(16L, value);
            }));
        }

        static Node create(AnyHeap heap, byte[] prefix, int start, int length, long value) {
            if (length > 8) {
                return Leaf.prependNodes(heap, prefix, start, length, value);
            }
            return new SimpleLeaf(heap, prefix, start, length, value);
        }

        SimpleLeaf(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        @Override
        long getValue() {
            return this.mb.getLong(16L);
        }

        @Override
        void setValue(long value) {
            this.mb.setLong(16L, value);
        }

        @Override
        void destroy(Consumer<Long> cleanerFunction) {
            cleanerFunction.accept(this.getValue());
        }
    }

    static abstract class Leaf
    extends Node {
        Leaf(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        Leaf(AnyHeap heap, long size) {
            super(heap, size);
        }

        abstract void setValue(long var1);

        abstract long getValue();

        @Override
        boolean isLeaf() {
            return true;
        }

        static Node prependNodes(AnyHeap heap, byte[] key, int start, int length, long value) {
            Node4 parent;
            int curStart = key.length - 8;
            int curLength = length;
            Node child = new SimpleLeaf(heap, key, curStart, 8, value);
            curLength -= 9;
            curStart -= 9;
            while (curLength > 8) {
                parent = new Node4(heap, key, curStart, 8, child, key[curStart + 8]);
                child = parent;
                curStart -= 9;
                curLength -= 9;
            }
            if (curLength >= 0) {
                parent = new Node4(heap, key, start, curLength, child, key[curStart + 8]);
                child = parent;
            }
            return child;
        }
    }

    static abstract class InternalNode
    extends Node {
        InternalNode(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        InternalNode(AnyHeap heap, long size, Consumer<Range> initializer) {
            super(heap, heap.allocateCompactMemoryBlock(size, range -> {
                range.setByte(1L, (byte)-1);
                initializer.accept((Range)range);
            }));
        }

        boolean hasBlankRadixChild() {
            return this.getBlankRadixIndex() != -1;
        }

        byte getBlankRadixIndex() {
            return this.mb.getByte(1L);
        }

        void setBlankRadixIndex(byte index) {
            this.mb.setByte(1L, index);
        }

        short getChildrenCount() {
            return this.mb.getShort(2L);
        }

        private void setChildrenCount(short count) {
            this.mb.setShort(2L, count);
        }

        void incChildrenCount() {
            this.setChildrenCount((short)(this.getChildrenCount() + 1));
        }

        void decChildrenCount() {
            this.setChildrenCount((short)(this.getChildrenCount() - 1));
        }

        Leaf findBlankRadixChild() {
            return (Leaf)this.getChildAtIndex(this.getBlankRadixIndex());
        }

        boolean addBlankRadixChild(Leaf child) {
            short childrenCount = this.getChildrenCount();
            if (childrenCount == this.capacity()) {
                return false;
            }
            this.incChildrenCount();
            this.setBlankRadixIndex((byte)childrenCount);
            this.putChildAtIndex(childrenCount, child);
            return true;
        }

        Node findChild(byte radix) {
            return this.getChildAtIndex(this.findChildIndex(radix));
        }

        Node getChildAtIndex(int index) {
            return Node.rebuild(this.heap, this.findValueAtIndex(index));
        }

        @Override
        void destroy(Consumer<Long> cleanerFunction) {
            for (int i = 0; i < this.capacity(); ++i) {
                Node child = this.getChildAtIndex(i);
                if (child == null) continue;
                child.destroy(cleanerFunction);
                child.free();
            }
        }

        int clearBlankRadixFlag() {
            byte index = this.getBlankRadixIndex();
            if (index != -1) {
                this.mb.setByte(1L, (byte)-1);
            }
            return index;
        }

        byte findLowestRadix() {
            byte[] radices = this.getRadices();
            byte lowest = radices[0];
            for (int i = 1; i < radices.length; ++i) {
                if (LongART.compareUnsigned(lowest, radices[i]) <= 0) continue;
                lowest = radices[i];
            }
            return lowest;
        }

        byte findHighestRadix() {
            byte[] radices = this.getRadices();
            byte blankIndex = this.getBlankRadixIndex();
            byte highest = radices[0];
            for (int i = 0; i < radices.length; ++i) {
                if (i == blankIndex || LongART.compareUnsigned(highest, radices[i]) >= 0) continue;
                highest = radices[i];
            }
            return highest;
        }

        protected abstract short capacity();

        protected abstract byte[] getRadices();

        abstract boolean addChild(byte var1, Node var2);

        abstract int findChildIndex(byte var1);

        protected abstract long findValueAtIndex(int var1);

        abstract void putChildAtIndex(int var1, Node var2);

        abstract InternalNode grow(Node var1, Optional<Byte> var2);

        abstract NodeEntry[] getEntries();

        abstract void deleteChild(Byte var1);

        abstract InternalNode split(Byte var1, boolean var2);

        @Override
        boolean isLeaf() {
            return false;
        }

        void updateChild(Node newChild, Byte b) {
            if (b == null) {
                System.out.println("updateChild: radix is null newChild addr is " + newChild.handle());
                if (!newChild.isLeaf()) {
                    throw new RuntimeException();
                }
                this.addBlankRadixChild((Leaf)newChild);
            } else {
                this.addChild(b, newChild);
            }
        }

        void printStatsChildren(StringBuilder start, int depth) {
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                Node node = this.getChildAtIndex(i);
                if (node == null) {
                    throw new RuntimeException("Empty child at index: " + i + ". this capacity is " + this.capacity());
                }
                node.statsPrint(depth + 1);
            }
        }

        void printChildren(StringBuilder start, int depth) {
            byte[] radices = this.getRadices();
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                if (radices == null) continue;
                System.out.println(start + "For radix " + new String(new byte[]{radices[i]}) + "(" + radices[i] + "):");
                Node node = this.getChildAtIndex(i);
                if (node == null) continue;
                node.print(depth + 1);
            }
        }
    }

    static final class Root
    extends Node {
        private static final long SIZE = 24L;
        private static final long CHILD_OFFSET = 16L;

        Root(AnyHeap heap) {
            super(heap, 24L);
            this.initType((byte)6);
        }

        Root(AnyHeap heap, AnyMemoryBlock mb) {
            super(heap, mb);
        }

        boolean addChild(Node node) {
            this.mb.setLong(16L, node.handle());
            return true;
        }

        Node getChild() {
            return Node.rebuild(this.heap, this.mb.getLong(16L));
        }

        long getCount() {
            return this.mb.getLong(8L);
        }

        void setCount(long count) {
            this.mb.setLong(8L, count);
        }

        void incrementCount() {
            this.mb.setLong(8L, this.mb.getLong(8L) + 1L);
        }

        void decrementCount() {
            this.mb.setLong(8L, this.mb.getLong(8L) - 1L);
        }

        int getMaxKeyLength() {
            return this.mb.getInt(4L);
        }

        void setMaxKeyLength(int length) {
            this.mb.setInt(4L, length);
        }

        void setVersion(short version) {
            this.mb.setShort(2L, version);
        }

        short getVersion() {
            return this.mb.getShort(2L);
        }

        @Override
        boolean isLeaf() {
            return false;
        }

        @Override
        void destroy(Consumer<Long> cleanerFunction) {
            Node child = this.getChild();
            if (child != null) {
                child.destroy(cleanerFunction);
                child.free();
                this.mb.setLong(16L, 0L);
            }
            this.setCount(0L);
        }

        void deleteChild() {
            this.destroy(null);
        }

        @Override
        void free() {
            this.destroy(c -> {});
            this.mb.freeMemory();
        }
    }

    static class NodeEntry {
        byte radix;
        Node child;

        public NodeEntry(byte radix, Node child) {
            this.radix = radix;
            this.child = child;
        }
    }

    static abstract class Node {
        static final byte NODE4_TYPE = 7;
        static final byte NODE16_TYPE = 1;
        static final byte NODE48_TYPE = 2;
        static final byte NODE256_TYPE = 3;
        static final byte SIMPLE_LEAF_TYPE = 4;
        static final byte COMPLEX_LEAF_TYPE = 5;
        static final byte ROOT_TYPE = 6;
        protected static final long HEADER_SIZE = 16L;
        protected static final long NODE_TYPE_OFFSET = 0L;
        protected static final long BLANK_RADIX_INDEX_OFFSET = 1L;
        protected static final long CHILDREN_COUNT_OFFSET = 2L;
        protected static final long PREFIX_LENGTH_OFFSET = 4L;
        protected static final long COMPRESSED_PATH_OFFSET = 8L;
        static final int MAX_PREFIX_LENGTH = 8;
        AnyHeap heap;
        AnyMemoryBlock mb;

        Node(AnyHeap heap, long size) {
            this.heap = heap;
            this.mb = this.heap.allocateCompactMemoryBlock(size);
        }

        Node(AnyHeap heap, AnyMemoryBlock mb) {
            this.heap = heap;
            this.mb = mb;
        }

        static Node rebuild(AnyHeap heap, long handle) {
            Node ret;
            if (handle == 0L) {
                return null;
            }
            AnyMemoryBlock mb = heap.compactMemoryBlockFromHandle(handle);
            byte rawType = mb.getByte(0L);
            switch (rawType) {
                case 7: {
                    ret = new Node4(heap, mb);
                    break;
                }
                case 1: {
                    ret = new Node16(heap, mb);
                    break;
                }
                case 2: {
                    ret = new Node48(heap, mb);
                    break;
                }
                case 3: {
                    ret = new Node256(heap, mb);
                    break;
                }
                case 4: {
                    ret = new SimpleLeaf(heap, mb);
                    break;
                }
                case 6: {
                    ret = new Root(heap, mb);
                    break;
                }
                default: {
                    throw new HeapException("Failed to reaccess tree with supplied handle");
                }
            }
            return ret;
        }

        void free() {
            this.mb.freeMemory();
        }

        long handle() {
            return this.mb.handle();
        }

        private byte getType() {
            return this.mb.getByte(0L);
        }

        void initType(byte type) {
            this.mb.setByte(0L, type);
        }

        int getPrefixLength() {
            return this.mb.getInt(4L);
        }

        protected void setPrefixLength(int length) {
            this.mb.setInt(4L, length);
        }

        byte[] getPrefix() {
            byte[] prefix = new byte[this.getPrefixLength()];
            if (prefix.length == 0) {
                return prefix;
            }
            this.mb.copyToArray(8L, prefix, 0, prefix.length);
            return prefix;
        }

        void initPrefix(byte[] prefix) {
            if (prefix.length > 8) {
                throw new IllegalArgumentException("Prefix more than 8 bytes");
            }
            this.mb.copyFromArray(prefix, 0, 8L, prefix.length);
        }

        protected void setPrefix(byte[] prefix) {
            if (prefix.length > 8) {
                throw new IllegalArgumentException("Prefix more than 8 bytes");
            }
            this.mb.copyFromArray(prefix, 0, 8L, prefix.length);
        }

        void updatePrefix(byte[] prefix, int start, int updatedLength) {
            if (updatedLength <= 0) {
                this.setPrefixLength(0);
                return;
            }
            byte[] updatedPrefix = new byte[8];
            for (int i = 0; i < updatedLength; ++i) {
                updatedPrefix[i] = prefix[start + i];
            }
            this.setPrefixLength(updatedLength);
            this.setPrefix(updatedPrefix);
        }

        int checkPrefix(byte[] key, int depth) {
            int i;
            byte[] prefix = this.getPrefix();
            for (i = 0; i < key.length - depth && i < prefix.length && key[depth + i] == prefix[i]; ++i) {
            }
            return i;
        }

        boolean isLeaf() {
            return false;
        }

        String getPrefixString() {
            StringBuilder sb = new StringBuilder();
            byte[] prefix = this.getPrefix();
            for (int i = 0; i < prefix.length; ++i) {
                sb.append(String.format("%02X ", prefix[i]));
            }
            return sb.toString();
        }

        abstract void destroy(Consumer<Long> var1);

        public void statsPrint(int depth) {
            StringBuilder start = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                start.append("   ");
            }
            if (!this.isLeaf()) {
                InternalNode intNode = (InternalNode)this;
                System.out.println(depth + "," + intNode.capacity() + "," + intNode.getChildrenCount() + "," + this.getPrefixLength());
                intNode.printStatsChildren(start, depth);
            } else {
                System.out.println(depth + ",0,0," + this.getPrefixLength());
            }
        }

        void print(int depth) {
            StringBuilder start = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                start.append("   ");
            }
            System.out.println(start + "=========================");
            System.out.println(start + "Type: " + this.getType());
            System.out.println(start + "Prefix length: " + this.getPrefixLength());
            System.out.println(start + "Prefix: " + this.getPrefixString());
            if (!this.isLeaf()) {
                InternalNode intNode = (InternalNode)this;
                System.out.println(start + "Child count: " + intNode.getChildrenCount());
                if (intNode.hasBlankRadixChild()) {
                    System.out.println(start + "Has Blank Radix Child at " + intNode.getBlankRadixIndex());
                }
                intNode.printChildren(start, depth);
            } else {
                SimpleLeaf leaf = (SimpleLeaf)this;
                System.out.println(start + "Value: " + Long.toHexString(leaf.getValue()));
            }
        }
    }

    class ValueIterator
    implements Iterator<Long> {
        StackItem cursor;
        ArrayDeque<StackItem> cache = new ArrayDeque();
        long next;
        long prev;

        public ValueIterator() {
            Node first = LongART.this.root.getChild();
            if (first != null) {
                if (first.isLeaf()) {
                    SimpleLeaf leaf = (SimpleLeaf)first;
                    this.next = leaf.getValue();
                } else {
                    LongART.this.search2(first, new byte[0], 0, this::buildCache, null, false);
                    this.cursor = this.cache.getFirst();
                    this.advance();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != 0L;
        }

        @Override
        public Long next() {
            this.prev = this.next;
            if (this.prev == 0L) {
                throw new NoSuchElementException();
            }
            if (this.cursor == null) {
                this.next = 0L;
                return this.prev;
            }
            while (this.cursor.isDone()) {
                if (this.cache.size() == 0) {
                    this.next = 0L;
                    return this.prev;
                }
                this.cache.pop();
                this.cursor = this.cache.peekFirst();
                if (this.cursor != null) {
                    this.cursor.next();
                    continue;
                }
                this.next = 0L;
                return this.prev;
            }
            this.advance();
            return this.prev;
        }

        void advance() {
            if (!this.cursor.entryAtIndex().child.isLeaf()) {
                LongART.this.search2(this.cursor.entryAtIndex().child, new byte[0], 0, this::buildCache, null, false);
                this.cursor = this.cache.getFirst();
            }
            this.next = ((SimpleLeaf)this.cursor.entryAtIndex().child).getValue();
            this.cursor.next();
        }

        void buildCache(Node parent, Node child, Byte radix, Consumer<Long> cleanerFunction) {
            StackItem item = radix == null ? new StackItem(((InternalNode)parent).getEntries(), parent.getPrefixLength(), false) : new StackItem(((InternalNode)parent).getEntries(), parent.getPrefixLength(), radix, ((InternalNode)parent).hasBlankRadixChild(), false);
            this.cache.push(item);
        }
    }

    class EntryIterator
    implements Iterator<Entry> {
        StackItem cursor;
        byte[] lastKey = null;
        boolean lastInclusive = false;
        boolean reversed;
        ByteBuffer keyBuf;
        ArrayDeque<StackItem> cache;
        Entry prev;
        Entry next;

        public EntryIterator() {
            this(false);
        }

        public EntryIterator(boolean reversed) {
            this.reversed = reversed;
            this.cache = new ArrayDeque();
            Node first = LongART.this.root.getChild();
            if (first != null) {
                if (first.isLeaf()) {
                    SimpleLeaf leaf = (SimpleLeaf)first;
                    this.next = new Entry(first.getPrefix(), leaf.getValue());
                } else {
                    this.keyBuf = ByteBuffer.allocate(LongART.this.maxKeyLen);
                    LongART.this.search2(first, new byte[0], 0, this::buildCache, null, reversed);
                    this.cursor = this.cache.getFirst();
                    this.advance();
                }
            }
        }

        void buildCache(Node parent, Node child, Byte radix, Consumer<Long> cleanerFunction) {
            if (this.reversed && child == null) {
                return;
            }
            NodeEntry[] entries = ((InternalNode)parent).getEntries();
            StackItem item = radix == null && child != null ? new StackItem(entries, parent.getPrefixLength(), this.reversed) : (child == null ? new StackItem(entries, parent.getPrefixLength(), radix == null ? entries[0].radix : radix, ((InternalNode)parent).hasBlankRadixChild(), this.reversed) : new StackItem(((InternalNode)parent).getEntries(), parent.getPrefixLength(), radix, ((InternalNode)parent).hasBlankRadixChild(), this.reversed));
            this.cache.push(item);
            byte[] ba = parent.getPrefix();
            if (ba.length > 0) {
                this.keyBuf.put(ba);
            }
            if (radix != null && child != null && !child.isLeaf()) {
                this.keyBuf.put(radix);
            }
        }

        public EntryIterator(byte[] lastKey, boolean lastInclusive) {
            this();
            this.lastKey = lastKey;
            this.lastInclusive = lastInclusive;
        }

        public EntryIterator(byte[] firstKey, boolean firstInclusive, byte[] lastKey, boolean lastInclusive, boolean reversed) {
            this.cache = new ArrayDeque();
            this.reversed = reversed;
            Node first = LongART.this.root.getChild();
            if (lastKey != null) {
                int comp = this.keyCompare(firstKey, lastKey);
                if (comp == 0) {
                    long val = LongART.this.get(firstKey);
                    this.next = val == 0L ? null : new Entry(firstKey, val);
                    return;
                }
                if (!reversed && comp > 0) {
                    throw new IllegalArgumentException();
                }
                if (reversed && comp < 0) {
                    throw new IllegalArgumentException();
                }
            }
            if (reversed) {
                this.lastKey = firstKey;
                firstKey = lastKey;
                this.lastInclusive = firstInclusive;
                firstInclusive = lastInclusive;
            } else {
                this.lastKey = lastKey;
                this.lastInclusive = lastInclusive;
            }
            if (first != null) {
                if (first.isLeaf()) {
                    SimpleLeaf leaf = (SimpleLeaf)first;
                    int x = this.keyCompare(firstKey, first.getPrefix());
                    this.next = firstInclusive && x == 0 || x < 0 ? new Entry(first.getPrefix(), leaf.getValue()) : null;
                } else {
                    this.keyBuf = ByteBuffer.allocate(LongART.this.maxKeyLen);
                    long l = LongART.this.search2(first, firstKey, 0, this::buildCache, null, reversed);
                    this.cursor = this.cache.peekFirst();
                    if (this.cursor != null) {
                        if (l == -1L && this.keyBuf.position() > 0) {
                            this.keyBuf.position(this.keyBuf.position() - 1);
                        }
                        this.advanceTo(firstKey, firstInclusive);
                    } else {
                        LongART.this.search2(first, new byte[0], 0, this::buildCache, null, reversed);
                        this.cursor = this.cache.getFirst();
                        this.advanceTo(firstKey, firstInclusive);
                    }
                }
                this.prev = this.next;
            }
        }

        int keyCompare(byte[] firstKey, byte[] nextKey) {
            byte[] next;
            byte[] first;
            if (this.reversed) {
                first = nextKey;
                next = firstKey;
            } else {
                first = firstKey;
                next = nextKey;
            }
            int ret = 0;
            for (int i = 0; i < first.length && i < next.length && (ret = LongART.compareUnsigned(first[i], next[i])) == 0; ++i) {
            }
            return ret == 0 ? Integer.compare(first.length, next.length) : ret;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null || this.lastKey == null) {
                return this.next != null;
            }
            int y = this.keyCompare(this.lastKey, this.next.getKey());
            return this.lastInclusive ? y >= 0 : y > 0;
        }

        @Override
        public Entry next() {
            this.prev = this.next;
            if (this.prev == null) {
                throw new NoSuchElementException("Null");
            }
            if (this.cursor == null) {
                this.next = null;
                return this.prev;
            }
            while (this.cursor.isDone()) {
                if (this.cache.size() == 0) {
                    this.next = null;
                    return this.prev;
                }
                this.pop();
                if (this.cursor != null) continue;
                this.next = null;
                return this.prev;
            }
            this.advance();
            return this.prev;
        }

        void advance() {
            NodeEntry ne = this.cursor.entryAtIndex();
            if (!ne.child.isLeaf()) {
                if (!this.cursor.currentIsBlank()) {
                    this.keyBuf.put(ne.radix);
                }
                LongART.this.search2(ne.child, new byte[0], 0, this::buildCache, null, this.reversed);
                this.cursor = this.cache.getFirst();
                ne = this.cursor.entryAtIndex();
            }
            SimpleLeaf leaf = (SimpleLeaf)ne.child;
            this.keyBuf.mark();
            if (!this.cursor.currentIsBlank()) {
                this.keyBuf.put(ne.radix);
            }
            this.cursor.next();
            byte[] leafPrefix = leaf.getPrefix();
            if (leafPrefix.length > 0) {
                this.keyBuf.put(leafPrefix);
            }
            this.next = new Entry(Arrays.copyOf(this.keyBuf.array(), this.keyBuf.position()), leaf.getValue());
            this.keyBuf.reset();
        }

        void advanceTo(byte[] firstKey, boolean inclusive) {
            block0: while (this.cursor != null && !this.cursor.isDone()) {
                this.advance();
                int x = this.keyCompare(firstKey, this.next.getKey());
                if (inclusive && x == 0 || x < 0) break;
                while (this.cursor.isDone() && this.cache.size() > 0) {
                    this.pop();
                    if (this.cursor != null) continue;
                    continue block0;
                }
            }
        }

        void pop() {
            this.keyBuf.reset().position(Math.max(0, this.keyBuf.position() - (1 + this.cursor.prefixLen()))).mark();
            this.cache.pop();
            this.cursor = this.cache.peekFirst();
            if (this.cursor != null) {
                this.cursor.next();
            }
            this.keyBuf.reset();
        }
    }

    public static class Entry {
        byte[] key;
        long value;

        Entry(byte[] key, long value) {
            this.key = key;
            this.value = value;
        }

        public byte[] getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }
    }

    class StackItem {
        NodeEntry[] entries;
        int index = 0;
        int prefixLen = 0;
        private final boolean hasBlank;
        final boolean reversed;

        public StackItem(NodeEntry[] entries, int prefixLen, boolean reversed) {
            this.entries = entries;
            this.prefixLen = prefixLen;
            this.hasBlank = true;
            this.reversed = reversed;
            if (reversed) {
                this.index = entries.length - 1;
            }
        }

        public StackItem(NodeEntry[] entries, int prefixLen, Byte radix, boolean hasBlank, boolean reversed) {
            this.entries = entries;
            this.prefixLen = prefixLen;
            this.hasBlank = hasBlank;
            this.reversed = reversed;
            if (radix != entries[0].radix) {
                this.index = this.calcIndex(radix);
            }
            if (reversed && this.index == entries.length) {
                this.index = entries.length - 1;
            }
        }

        int calcIndex(byte radix) {
            int i;
            for (i = 0; i < this.entries.length && LongART.compareUnsigned(radix, this.entries[i].radix) > 0; ++i) {
            }
            return i;
        }

        public boolean isDone() {
            if (!this.reversed) {
                return this.index >= this.entries.length;
            }
            return this.index < 0;
        }

        public boolean currentIsBlank() {
            return this.hasBlank && this.index == 0;
        }

        public int prefixLen() {
            return this.prefixLen;
        }

        public void next() {
            this.index = !this.reversed ? ++this.index : --this.index;
        }

        public NodeEntry entryAtIndex() {
            return this.entries[this.index];
        }
    }

    @FunctionalInterface
    static interface SearchHelper {
        public void apply(Node var1, Node var2, Byte var3, Consumer<Long> var4);
    }
}

