/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyAccessor;
import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongLinkedList {
    private AnyHeap heap;
    private AnyAccessor sentinel;
    private long handle;
    private static final long VERSION_OFFSET = 0L;
    private static final long FIRST_OFFSET = 8L;
    private static final long COUNT_OFFSET = 16L;
    private static final long SIZE = 24L;
    private static final short VERSION = 100;

    public LongLinkedList(AnyHeap heap) {
        this.heap = heap;
        this.handle = heap.allocateCompactMemory(24L);
        this.sentinel = heap.createCompactAccessor();
        this.sentinel.handle(this.handle);
        this.sentinel.setShort(0L, (short)100);
    }

    private LongLinkedList(AnyHeap heap, long handle) {
        this.heap = heap;
        this.handle = handle;
        this.sentinel = heap.createCompactAccessor();
        this.sentinel.handle(handle);
    }

    public static LongLinkedList fromHandle(AnyHeap heap, long handle) {
        return new LongLinkedList(heap, handle);
    }

    public void add(long index, long value) {
        if (index < 0L || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sentinel.isValid()) {
            throw new IllegalStateException();
        }
        this.heap.execute(() -> {
            Node p = new Node(this.heap, value);
            if (index == 0L) {
                p.setNext(this.first());
                this.setFirst(p);
            } else {
                Node n = this.findNode(index - 1L);
                Node q = n.next();
                p.setNext(q);
                n.setNext(p);
            }
            this.incrementSize();
        });
    }

    public void addFirst(long value) {
        if (!this.sentinel.isValid()) {
            throw new IllegalStateException();
        }
        this.heap.execute(() -> {
            Node n = new Node(this.heap, value);
            Node p = this.first();
            if (p == null) {
                this.setFirst(n);
            } else {
                n.setNext(p);
                this.setFirst(n);
            }
            this.incrementSize();
        });
    }

    public long get(long index) {
        if (index < 0L || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Node n = this.findNode(index);
        return n.getValue();
    }

    public long getFirst() {
        Node first = this.first();
        if (first == null) {
            throw new NoSuchElementException();
        }
        return first.getValue();
    }

    public long handle() {
        if (!this.sentinel.isValid()) {
            throw new IllegalStateException();
        }
        return this.sentinel.handle();
    }

    public Iterator<Long> iterator() {
        return new ListIterator(this);
    }

    public long set(long index, long value) {
        if (index < 0L || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Node n = this.findNode(index);
        long retValue = n.getValue();
        n.setValue(value);
        return retValue;
    }

    public long size() {
        return this.sentinel.getLong(16L);
    }

    public long remove(long index) {
        if (index < 0L || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        long data = this.heap.execute(() -> {
            Node n = null;
            Node p = null;
            long retValue = 0L;
            if (index == 0L) {
                p = this.first();
                this.setFirst(p.next());
            } else {
                n = this.findNode(index - 1L);
                p = n.next();
                n.setNext(p.next());
            }
            retValue = p.getValue();
            p.free();
            this.decrementSize();
            return retValue;
        });
        return data;
    }

    public long removeFirst() {
        if (this.size() == 0L) {
            throw new NoSuchElementException();
        }
        return this.remove(0L);
    }

    public void clear() {
        if (!this.sentinel.isValid()) {
            throw new IllegalStateException();
        }
        long firstHandle = this.sentinel.getLong(8L);
        if (firstHandle == 0L) {
            return;
        }
        this.sentinel.handle(firstHandle);
        while (this.sentinel.isValid()) {
            long next = Node.nextHandle(this.sentinel);
            this.sentinel.freeMemory();
            if (next > 0L) {
                this.sentinel.handle(next);
                continue;
            }
            this.sentinel.resetHandle();
        }
        this.sentinel.handle(this.handle);
        this.sentinel.setLong(8L, 0L);
        this.sentinel.setLong(16L, 0L);
    }

    public void free() {
        this.clear();
        this.sentinel.freeMemory();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongLinkedList)) {
            return false;
        }
        AnyMemoryBlock thisBlock = this.heap.compactMemoryBlockFromHandle(this.handle);
        LongLinkedList otherList = (LongLinkedList)obj;
        AnyMemoryBlock otherBlock = otherList.heap.compactMemoryBlockFromHandle(otherList.handle());
        return otherBlock.equals(thisBlock);
    }

    public int hashCode() {
        return this.heap.compactMemoryBlockFromHandle(this.handle).hashCode();
    }

    private Node findNode(long index) {
        this.sentinel.handle(this.sentinel.getLong(8L));
        int i = 0;
        while ((long)i < index) {
            Node.advance(this.sentinel);
            ++i;
        }
        long val = this.sentinel.handle();
        this.sentinel.handle(this.handle);
        return Node.fromHandle(this.heap, val);
    }

    private void setFirst(Node first) {
        long firstHandle = first == null ? 0L : first.handle();
        this.sentinel.setLong(8L, firstHandle);
    }

    private Node first() {
        long firstHandle = this.sentinel.getLong(8L);
        return firstHandle == 0L ? null : Node.fromHandle(this.heap, firstHandle);
    }

    private long firstHandle() {
        return this.sentinel.getLong(8L);
    }

    private void decrementSize() {
        this.sentinel.setLong(16L, this.size() - 1L);
    }

    private void incrementSize() {
        this.sentinel.setLong(16L, this.size() + 1L);
    }

    static class Node {
        private static final long VALUE_OFFSET = 0L;
        private static final long NEXT_OFFSET = 8L;
        private static final int NODE_SIZE = 16;
        AnyMemoryBlock mb;
        private AnyHeap heap;

        public Node(AnyHeap heap, long value) {
            this.heap = heap;
            this.mb = heap.allocateCompactMemoryBlock(16L);
            this.mb.setLong(0L, value);
        }

        public static Node fromHandle(AnyHeap heap, long handle) {
            return new Node(heap, heap.compactMemoryBlockFromHandle(handle));
        }

        private Node(AnyHeap heap, AnyMemoryBlock mb) {
            this.mb = mb;
            this.heap = heap;
        }

        public long getValue() {
            return this.mb.getLong(0L);
        }

        public Node next() {
            long nextHandle = this.mb.getLong(8L);
            if (nextHandle != 0L) {
                return Node.fromHandle(this.heap, nextHandle);
            }
            return null;
        }

        public static long getValue(AnyAccessor acc) {
            return acc.getLong(0L);
        }

        static long nextHandle(AnyAccessor acc) {
            return acc.getLong(8L);
        }

        public static void advance(AnyAccessor acc) {
            long nextHandle = acc.getLong(8L);
            if (nextHandle != 0L) {
                acc.handle(nextHandle);
            } else {
                acc.resetHandle();
            }
        }

        public void setValue(long value) {
            this.mb.setLong(0L, value);
        }

        public void setNext(Node next) {
            long nextHandle = next == null ? 0L : next.handle();
            this.mb.setLong(8L, nextHandle);
        }

        public long handle() {
            return this.mb.handle();
        }

        public void free() {
            this.mb.freeMemory();
        }
    }

    static class ListIterator
    implements Iterator<Long> {
        private long currentValue;
        private LongLinkedList l;
        private AnyAccessor acc;
        final long size;

        public ListIterator(LongLinkedList l) {
            this.l = l;
            this.size = l.size();
            this.acc = l.heap.createCompactAccessor();
            long handle = l.firstHandle();
            if (handle != 0L) {
                this.acc.handle(handle);
            }
        }

        @Override
        public boolean hasNext() {
            return this.acc.isValid();
        }

        @Override
        public Long next() {
            if (this.l.size() == 0L) {
                throw new NoSuchElementException();
            }
            if (this.l.size() != this.size) {
                throw new ConcurrentModificationException();
            }
            this.currentValue = Node.getValue(this.acc);
            Node.advance(this.acc);
            return this.currentValue;
        }
    }
}

