/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.util.AbstractSharded;
import com.intel.pmem.llpl.util.AutoCloseableIterator;
import com.intel.pmem.llpl.util.Shardable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;

interface Sharder<K> {
    public long handle();

    public K lowestKey(Function<Shardable<K>, K> var1);

    public K highestKey(Function<Shardable<K>, K> var1);

    public Object shardAndPut(K var1, Function<Shardable<K>, Object> var2);

    public Object shardAndGet(K var1, Function<Shardable<K>, Object> var2);

    public <E> AutoCloseableIterator<E> shardsAndExecute(K var1, K var2, Function<Shardable<K>, Iterator<E>> var3, boolean var4);

    public void forEach(Consumer<Shardable<K>> var1);

    public void free();

    public long totalEntries();

    public static <K> Sharder<K> rebuild(AnyHeap heap, long handle, AbstractSharded<K> sharded) {
        AnyMemoryBlock block = heap.memoryBlockFromHandle(handle);
        byte[] arr = new byte[block.getInt(16L)];
        block.copyToArray(20L, arr, 0, arr.length);
        String className = new String(arr);
        Sharder ret = null;
        String classArg = className.equals("com.intel.pmem.llpl.util.DynamicSharder") ? "com.intel.pmem.llpl.util.AbstractSharded" : "com.intel.pmem.llpl.util.Sharded";
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> ctor = cls.getDeclaredConstructor(AnyHeap.class, Long.TYPE, Class.forName(classArg));
            ret = (Sharder)ctor.newInstance(heap, handle, sharded);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

