/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;

public class ShortArray {
    private static final int SHIFT_BITS = 1;
    private final AnyMemoryBlock arrayBlock;
    private static final long VERSION_OFFSET = 0L;
    private static final long DATA_OFFSET = 8L;
    private static final short VERSION = 100;

    public static ShortArray fromHandle(AnyHeap heap, long handle) {
        AnyMemoryBlock arrayBlock = heap.memoryBlockFromHandle(handle);
        return new ShortArray(heap, arrayBlock);
    }

    public ShortArray(AnyHeap heap, long size) {
        this.arrayBlock = heap.allocateMemoryBlock(2L * size + 8L);
        this.arrayBlock.setShort(0L, (short)100);
    }

    private ShortArray(AnyHeap heap, AnyMemoryBlock arrayBlock) {
        this.arrayBlock = arrayBlock;
    }

    private long elementOffset(long index) {
        return 8L + 2L * index;
    }

    public void set(long index, short value) {
        if (index < 0L || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.arrayBlock.setShort(this.elementOffset(index), value);
    }

    public short get(long index) {
        if (index < 0L || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.arrayBlock.getShort(this.elementOffset(index));
    }

    public long size() {
        return this.arrayBlock.size() - 8L >> 1;
    }

    public long handle() {
        return this.arrayBlock.handle();
    }

    public void free() {
        this.arrayBlock.freeMemory();
    }

    public boolean equals(Object obj) {
        return obj instanceof ShortArray && ((ShortArray)obj).arrayBlock.equals(this.arrayBlock);
    }

    public int hashCode() {
        return this.arrayBlock.hashCode();
    }
}

