/*
 * Decompiled with CFR 0.152.
 */
package com.intel.pmem.llpl.util;

import com.intel.pmem.llpl.AnyHeap;
import com.intel.pmem.llpl.AnyMemoryBlock;
import com.intel.pmem.llpl.util.AutoCloseableIterator;
import com.intel.pmem.llpl.util.LongArray;
import com.intel.pmem.llpl.util.Shardable;
import com.intel.pmem.llpl.util.Sharded;
import com.intel.pmem.llpl.util.Sharder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

class StaticSharder<K>
implements Sharder<K> {
    private int maxShards;
    private Shard<K>[] shards;
    private AnyHeap heap;
    private final long handle;
    final String CLASSNAME = "com.intel.pmem.llpl.util.StaticSharder";
    private final short VERSION = (short)100;
    private final long VERSION_OFFSET = 0L;
    private final long ROOT_SHARD_OFFSET = 8L;
    private final long CLASSNAME_LENGTH_OFFSET = 16L;
    private final long CLASSNAME_OFFSET = 20L;
    private final long ROOT_BLOCK_SIZE = 20L + (long)"com.intel.pmem.llpl.util.StaticSharder".length();

    private StaticSharder(LongArray shardArray, int maxShards, AnyHeap heap, Shard<K>[] shards) {
        this.maxShards = maxShards;
        this.heap = heap;
        this.shards = shards;
        this.handle = this.encodeRootBlock(heap, shardArray);
    }

    public StaticSharder(AnyHeap heap, long handle, Sharded<K> sharded) {
        this.heap = heap;
        this.handle = handle;
        AnyMemoryBlock block = heap.memoryBlockFromHandle(handle);
        long shardArrayHandle = block.getLong(8L);
        LongArray shardArray = LongArray.fromHandle(heap, shardArrayHandle);
        this.maxShards = (int)shardArray.size();
        this.shards = new Shard[this.maxShards];
        for (int i = 0; i < this.maxShards; ++i) {
            this.shards[i] = new Shard<K>(sharded.recreateShard(shardArray.get(i)));
        }
    }

    public long encodeRootBlock(AnyHeap heap, LongArray shardArray) {
        AnyMemoryBlock rootBlock = heap.allocateMemoryBlock(this.ROOT_BLOCK_SIZE);
        rootBlock.setInt(16L, "com.intel.pmem.llpl.util.StaticSharder".length());
        rootBlock.copyFromArray("com.intel.pmem.llpl.util.StaticSharder".getBytes(), 0, 20L, "com.intel.pmem.llpl.util.StaticSharder".length());
        rootBlock.setLong(8L, shardArray.handle());
        rootBlock.setShort(0L, (short)100);
        return rootBlock.handle();
    }

    public StaticSharder(AnyHeap heap, int maxShards, Sharded<K> sharded) {
        LongArray shardArray = new LongArray(heap, maxShards);
        Shard[] shards = new Shard[maxShards];
        for (int i = 0; i < maxShards; ++i) {
            shards[i] = new Shard<K>(sharded.createShard());
            shardArray.set(i, shards[i].handle());
        }
        this.maxShards = maxShards;
        this.heap = heap;
        this.shards = shards;
        this.handle = this.encodeRootBlock(heap, shardArray);
    }

    @Override
    public long totalEntries() {
        long size = 0L;
        for (int i = 0; i < this.shards.length; ++i) {
            size += this.shards[i].size();
        }
        return size;
    }

    Shard<K> shard(K key) {
        return this.shards[Math.abs(key.hashCode()) % this.maxShards];
    }

    @Override
    public Object shardAndPut(K key, Function<Shardable<K>, Object> f) {
        return this.shardAndGet(key, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object shardAndGet(K key, Function<Shardable<K>, Object> f) {
        Object ret;
        Shard<K> shard = this.shard(key);
        shard.lock();
        try {
            ret = f.apply(shard.shard());
        }
        finally {
            shard.unlock();
        }
        return ret;
    }

    @Override
    public void forEach(Consumer<Shardable<K>> c) {
        ((Stream)Arrays.stream(this.shards).parallel()).forEach((? super T shard) -> {
            shard.lock();
            try {
                c.accept(shard.shard());
            }
            finally {
                shard.unlock();
            }
        });
    }

    @Override
    public void free() {
        ((Stream)Arrays.stream(this.shards).parallel()).forEach((? super T shard) -> {
            shard.lock();
            try {
                shard.free();
            }
            finally {
                shard.unlock();
            }
        });
        this.heap.memoryBlockFromHandle(this.handle).freeMemory();
    }

    @Override
    public <E> AutoCloseableIterator<E> shardsAndExecute(K fromKey, K toKey, Function<Shardable<K>, Iterator<E>> f, boolean reversed) {
        return null;
    }

    @Override
    public long handle() {
        return this.handle;
    }

    @Override
    public K lowestKey(Function<Shardable<K>, K> f) {
        ConcurrentSkipListSet set = new ConcurrentSkipListSet();
        ((Stream)Arrays.stream(this.shards).parallel()).forEach((? super T shard) -> {
            shard.lock();
            try {
                set.add(f.apply(shard.shard()));
            }
            finally {
                shard.unlock();
            }
        });
        return (K)set.first();
    }

    @Override
    public K highestKey(Function<Shardable<K>, K> f) {
        ConcurrentSkipListSet set = new ConcurrentSkipListSet();
        ((Stream)Arrays.stream(this.shards).parallel()).forEach((? super T shard) -> {
            shard.lock();
            try {
                set.add(f.apply(shard.shard()));
            }
            finally {
                shard.unlock();
            }
        });
        return (K)set.last();
    }

    class Shard<K> {
        Shardable<K> shard;
        ReentrantLock lock;

        Shard(Shardable<K> shard) {
            this.shard = shard;
            this.lock = new ReentrantLock(false);
        }

        public Shardable<K> shard() {
            return this.shard;
        }

        public long handle() {
            return this.shard.handle();
        }

        public long size() {
            return this.shard.size();
        }

        public void free() {
            this.shard.free();
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public boolean isLocked() {
            return this.lock.isLocked();
        }
    }
}

