/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.PrivilegedAction;

class NativeLoader {
    private static String libName = "libqat-java";
    private static boolean isLoaded = false;
    private static String extension;

    NativeLoader() {
    }

    static boolean isLoaded() {
        if (isLoaded) {
            return true;
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.loadLibrary(libName);
            } else {
                PrivilegedAction<Void> pa = () -> {
                    System.loadLibrary(libName);
                    return null;
                };
                AccessController.doPrivileged(pa);
            }
            isLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            isLoaded = false;
        }
        return isLoaded;
    }

    static synchronized String getLibName() {
        return "/com/intel/qat/" + NativeLoader.getOSName() + "/" + System.getProperty("os.arch") + "/" + libName + extension;
    }

    static String getOSName() {
        String os = System.getProperty("os.name");
        if (!os.contains("Linux")) {
            throw new UnsupportedOperationException("Operating System is not supported");
        }
        String ret = "linux";
        extension = ".so";
        return ret;
    }

    static synchronized void loadLibrary() {
        if (NativeLoader.isLoaded()) {
            return;
        }
        String libName = NativeLoader.getLibName();
        File tempNativeLib = null;
        File tempNativeLibLock = null;
        try (InputStream in = NativeLoader.class.getResourceAsStream(libName);){
            if (in == null) {
                throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + libName + ". Please try building from source.");
            }
            tempNativeLibLock = File.createTempFile("libqat-java", extension + ".lck");
            tempNativeLib = new File(tempNativeLibLock.getAbsolutePath().replaceFirst(".lck$", ""));
            try (FileOutputStream out = new FileOutputStream(tempNativeLib);){
                int bytesRead;
                byte[] buf = new byte[4096];
                while ((bytesRead = in.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
            }
            boolean isSymbolicLink = Files.isSymbolicLink(tempNativeLib.toPath());
            if (isSymbolicLink) {
                throw new IOException("Failed to load native qat-java library." + String.valueOf(tempNativeLib.toPath()) + " is a symbolic link.");
            }
            File finalTempNativeLib = tempNativeLib;
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                System.load(finalTempNativeLib.getAbsolutePath());
            } else {
                PrivilegedAction<Void> pa = () -> {
                    System.load(finalTempNativeLib.getAbsolutePath());
                    return null;
                };
                AccessController.doPrivileged(pa);
            }
            isLoaded = true;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("Failed to load native qat-java library.\n" + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (tempNativeLib != null) {
                tempNativeLib.deleteOnExit();
            }
            if (tempNativeLibLock != null) {
                tempNativeLibLock.deleteOnExit();
            }
        }
    }
}

