/*
 * Decompiled with CFR 0.152.
 */
package com.intellectualsites.http;

import com.intellectualsites.http.EntityMapper;
import com.intellectualsites.http.HttpClient;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClientSettings {
    private final Collection<Consumer<HttpClient.WrappedRequestBuilder>> decorators = new LinkedList<Consumer<HttpClient.WrappedRequestBuilder>>();
    private String baseURL = "";
    private EntityMapper entityMapper;

    ClientSettings() {
    }

    @NotNull
    String getBaseURL() {
        return this.baseURL;
    }

    @Nullable
    EntityMapper getEntityMapper() {
        return this.entityMapper;
    }

    @NotNull
    Collection<Consumer<HttpClient.WrappedRequestBuilder>> getRequestDecorators() {
        return Collections.unmodifiableCollection(this.decorators);
    }

    void setBaseURL(@NotNull String baseURL) {
        this.baseURL = Objects.requireNonNull(baseURL, "Base URL may not be null");
    }

    void setEntityMapper(@Nullable EntityMapper entityMapper) {
        this.entityMapper = entityMapper;
    }

    void addDecorator(@NotNull Consumer<HttpClient.WrappedRequestBuilder> decorator) {
        this.decorators.add(Objects.requireNonNull(decorator, "Decorator may not be null"));
    }
}

