/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi;

import be.maximvdw.placeholderapi.PlaceholderOptions;
import be.maximvdw.placeholderapi.PlaceholderReplaceEvent;
import be.maximvdw.placeholderapi.PlaceholderReplacer;
import be.maximvdw.placeholderapi.events.PlaceholderAddedEvent;
import be.maximvdw.placeholderapi.internal.CustomPlaceholdersPack;
import be.maximvdw.placeholderapi.internal.PlaceholderPack;
import be.maximvdw.placeholderapi.internal.PlaceholderPlugin;
import be.maximvdw.placeholderapi.internal.ui.SendConsole;
import be.maximvdw.placeholderapi.internal.utils.DateUtils;
import be.maximvdw.placeholderapi.internal.utils.NumberUtils;
import be.maximvdw.placeholderapi.internal.utils.bukkit.BukkitUtils;
import be.maximvdw.placeholderapi.internal.utils.chat.ColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bstats.bukkit.Metrics;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderAPI
extends JavaPlugin {
    private static List<PlaceholderPlugin> placeholderPlugins = new ArrayList<PlaceholderPlugin>();
    private static PlaceholderPack customPlaceholders = null;
    private static List<PlaceholderAddedEvent> placeholderAddedHandlers = new ArrayList<PlaceholderAddedEvent>();

    public void onEnable() {
        super.onEnable();
        new SendConsole((Plugin)this);
        PlaceholderAPI.initialize(this);
        SendConsole.info("Initializing placeholders ...");
        new ColorUtils();
        new BukkitUtils();
        new DateUtils();
        new NumberUtils();
        int resource = 11182;
        SendConsole.info("Sending metrics ...");
        try {
            new Metrics((JavaPlugin)this, 11182);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void initialize(PlaceholderAPI api) {
        customPlaceholders = new CustomPlaceholdersPack((Plugin)api);
    }

    public boolean registerMVdWPlugin(Plugin plugin, PlaceholderPlugin placeholderPlugin) {
        if (customPlaceholders == null) {
            SendConsole.severe("Unable to hook into MVdW Placeholder plugin!");
        }
        if (!placeholderPlugins.contains(placeholderPlugin)) {
            placeholderPlugin.registerPlaceHolder(customPlaceholders);
            placeholderPlugins.add(placeholderPlugin);
            SendConsole.info("Hooked into MVdW plugin: " + plugin.getName());
            return true;
        }
        placeholderPlugin.registerPlaceHolder(customPlaceholders);
        SendConsole.info("Hooked into MVdW plugin again: " + plugin.getName());
        return false;
    }

    public static String replacePlaceholders(OfflinePlayer offlinePlayer, String input) {
        if (placeholderPlugins.size() == 0) {
            return input;
        }
        return placeholderPlugins.get(0).getPlaceholderResult(input, offlinePlayer);
    }

    public static int getLoadedPlaceholderCount() {
        if (placeholderPlugins.size() == 0) {
            return 0;
        }
        return placeholderPlugins.get(0).getPlaceHolderCount();
    }

    public static boolean registerPlaceholder(Plugin plugin, String placeholder, PlaceholderReplacer replacer) {
        return PlaceholderAPI.registerPlaceholder(plugin, placeholder, replacer, new ArrayList<PlaceholderOptions>());
    }

    public static boolean registerPlaceholder(Plugin plugin, String placeholder, PlaceholderReplacer replacer, PlaceholderOptions ... options) {
        return PlaceholderAPI.registerPlaceholder(plugin, placeholder, replacer, new ArrayList<PlaceholderOptions>());
    }

    private static boolean registerPlaceholder(Plugin plugin, String placeholder, PlaceholderReplacer replacer, Collection<PlaceholderOptions> options) {
        if (plugin == null) {
            return false;
        }
        if (placeholder == null) {
            return false;
        }
        if (placeholder.equals("")) {
            return false;
        }
        if (replacer == null) {
            return false;
        }
        SendConsole.info(plugin.getName() + " added custom placeholder {" + placeholder.toLowerCase() + "}");
        be.maximvdw.placeholderapi.internal.PlaceholderReplacer<String> internalReplacer = new be.maximvdw.placeholderapi.internal.PlaceholderReplacer<String>(String.class, new Object[]{replacer}){

            @Override
            public String getResult(PlaceholderReplaceEvent event) {
                PlaceholderReplacer replacer = (PlaceholderReplacer)this.getArguments()[0];
                return replacer.onPlaceholderReplace(event);
            }
        };
        for (PlaceholderOptions option : options) {
            switch (option) {
                case RELATIONAL_PLACEHOLDER: {
                    internalReplacer.isRelationalPlaceholder(true);
                    break;
                }
                case ONLINE_PLACEHOLDER: {
                    internalReplacer.setOnline(true);
                }
            }
        }
        customPlaceholders.addOfflinePlaceholder(placeholder, "Custom MVdWPlaceholderAPI placeholder", false, internalReplacer);
        for (PlaceholderAddedEvent event : placeholderAddedHandlers) {
            if (event == null) continue;
            event.onPlaceholderAdded(plugin, placeholder.toLowerCase(), replacer);
        }
        return true;
    }

    public static boolean registerStaticPlaceholders(Plugin plugin, String placeholder, final String value) {
        if (plugin == null) {
            return false;
        }
        if (placeholder == null) {
            return false;
        }
        if (placeholder.equals("")) {
            return false;
        }
        PlaceholderReplacer replacer = new PlaceholderReplacer(){

            @Override
            public String onPlaceholderReplace(PlaceholderReplaceEvent event) {
                return value;
            }
        };
        customPlaceholders.addOfflinePlaceholder(placeholder, "Custom MVdWPlaceholderAPI placeholder", false, new be.maximvdw.placeholderapi.internal.PlaceholderReplacer<String>(String.class, new Object[]{replacer}){

            @Override
            public String getResult(PlaceholderReplaceEvent replaceEvent) {
                PlaceholderReplacer replacer = (PlaceholderReplacer)this.getArguments()[0];
                return replacer.onPlaceholderReplace(replaceEvent);
            }
        });
        for (PlaceholderAddedEvent event : placeholderAddedHandlers) {
            if (event == null) continue;
            event.onPlaceholderAdded(plugin, placeholder.toLowerCase(), replacer);
        }
        return true;
    }

    public void addPlaceholderListener(PlaceholderAddedEvent handler) {
        placeholderAddedHandlers.add(handler);
    }
}

