/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi.internal.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface ModuleConstraint {
    public ContraintType type();

    public String value();

    public static enum ContraintType {
        PLUGIN(1, "Plugin"),
        PLUGIN_VERSION(3, "Plugin version"),
        PLUGIN_VERSION_IS_LOWER(4, "Plugin version lower"),
        PLUGIN_VERSION_IS_HIGHER(5, "Plugin version higher"),
        PLUGIN_MAIN(6, "Plugin main"),
        PLUGIN_AUTHOR(7, "Plugin author"),
        PLACEHOLDERAPI_VERSION(2, "PlaceholderAPIBungee version"),
        SERVER_VERSION_IS_LOWER(1, "Server version is lower"),
        SERVER_VERSION_IS_HIGHER(1, "Server version is higher"),
        MODULE(3, "Module"),
        MODULE_VERSION(4, "Module version"),
        MODULE_VERSION_IS_LOWER(5, "Module version lower"),
        MODULE_VERSION_IS_HIGHER(6, "Module version higher");

        private int priority = 0;
        private String name = "";

        private ContraintType(int priority, String name) {
            this.setPriority(priority);
            this.setName(name);
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

