/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.ModbusValues;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataAddressException;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataValueException;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import java.util.Arrays;

public class ModbusCoils
extends ModbusValues<Boolean> {
    private boolean[] coils = new boolean[0];

    public ModbusCoils(int size) {
        this.coils = new boolean[Modbus.checkEndAddress(size) ? size : 65535];
    }

    public ModbusCoils(byte[] bytes) {
        this.coils = DataUtils.toBitsArray(bytes, bytes.length);
    }

    @Override
    public byte[] getBytes() {
        return DataUtils.toByteArray(this.coils);
    }

    @Override
    public void setBytesBe(byte[] bytes) {
        this.coils = DataUtils.toBitsArray(bytes, bytes.length * 8);
    }

    public void setBytes(byte[] bytes, int quantity) {
        this.coils = DataUtils.toBitsArray(bytes, quantity);
    }

    void setSize(int size) {
        if (this.coils.length != size) {
            this.coils = Arrays.copyOf(this.coils, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImpl(int offset, Boolean coil) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkAddress(offset);
        ModbusCoils modbusCoils = this;
        synchronized (modbusCoils) {
            this.coils[offset] = coil;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int offset, boolean[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, range.length);
        if (!Modbus.checkWriteCoilCount(range.length)) {
            throw new IllegalDataValueException();
        }
        ModbusCoils modbusCoils = this;
        synchronized (modbusCoils) {
            for (int i = 0; i < range.length; ++i) {
                this.set(offset + i, range[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] getRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkRange(offset, quantity);
        if (!Modbus.checkReadCoilCount(quantity)) {
            throw new IllegalDataValueException();
        }
        ModbusCoils modbusCoils = this;
        synchronized (modbusCoils) {
            return Arrays.copyOfRange(this.coils, offset, offset + quantity);
        }
    }

    @Override
    public synchronized int getQuantity() {
        return this.coils.length;
    }

    @Override
    public synchronized int getByteCount() {
        return (int)Math.ceil((double)this.coils.length / 8.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get(int offset) throws IllegalDataAddressException {
        this.checkAddress(offset);
        ModbusCoils modbusCoils = this;
        synchronized (modbusCoils) {
            return this.coils[offset];
        }
    }

    private void checkRange(int offset, int quantity) throws IllegalDataAddressException {
        if (offset + quantity > this.getQuantity()) {
            throw new IllegalDataAddressException(offset);
        }
    }

    private void checkAddress(int offset) throws IllegalDataAddressException {
        if (!Modbus.checkStartAddress(offset)) {
            throw new IllegalDataAddressException(offset);
        }
    }
}

