/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg;

import com.intelligt.modbus.jlibmodbus.msg.ModbusMessageFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.DiagnosticsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.EncapsulatedInterfaceTransportRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventCounterRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventLogRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.IllegalFunctionRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.MaskWriteRegisterRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadCoilsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadDiscreteInputsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadExceptionStatusRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadFifoQueueRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadFileRecordRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadHoldingRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadInputRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadWriteMultipleRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReportSlaveIdRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteFileRecordRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteMultipleCoilsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteMultipleRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteSingleCoilRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteSingleRegisterRequest;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public final class ModbusRequestFactory
implements ModbusMessageFactory {
    private ModbusRequestFactory() {
    }

    public static ModbusRequestFactory getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public ModbusMessage createMessage(int functionCode) {
        ModbusRequest msg;
        switch (ModbusFunctionCode.get(functionCode)) {
            case READ_COILS: {
                msg = new ReadCoilsRequest();
                break;
            }
            case READ_DISCRETE_INPUTS: {
                msg = new ReadDiscreteInputsRequest();
                break;
            }
            case READ_HOLDING_REGISTERS: {
                msg = new ReadHoldingRegistersRequest();
                break;
            }
            case READ_INPUT_REGISTERS: {
                msg = new ReadInputRegistersRequest();
                break;
            }
            case WRITE_SINGLE_COIL: {
                msg = new WriteSingleCoilRequest();
                break;
            }
            case WRITE_SINGLE_REGISTER: {
                msg = new WriteSingleRegisterRequest();
                break;
            }
            case WRITE_MULTIPLE_COILS: {
                msg = new WriteMultipleCoilsRequest();
                break;
            }
            case WRITE_MULTIPLE_REGISTERS: {
                msg = new WriteMultipleRegistersRequest();
                break;
            }
            case MASK_WRITE_REGISTER: {
                msg = new MaskWriteRegisterRequest();
                break;
            }
            case READ_WRITE_MULTIPLE_REGISTERS: {
                msg = new ReadWriteMultipleRegistersRequest();
                break;
            }
            case READ_FIFO_QUEUE: {
                msg = new ReadFifoQueueRequest();
                break;
            }
            case READ_FILE_RECORD: {
                msg = new ReadFileRecordRequest();
                break;
            }
            case WRITE_FILE_RECORD: {
                msg = new WriteFileRecordRequest();
                break;
            }
            case READ_EXCEPTION_STATUS: {
                msg = new ReadExceptionStatusRequest();
                break;
            }
            case REPORT_SLAVE_ID: {
                msg = new ReportSlaveIdRequest();
                break;
            }
            case GET_COMM_EVENT_COUNTER: {
                msg = new GetCommEventCounterRequest();
                break;
            }
            case GET_COMM_EVENT_LOG: {
                msg = new GetCommEventLogRequest();
                break;
            }
            case DIAGNOSTICS: {
                msg = new DiagnosticsRequest();
                break;
            }
            case ENCAPSULATED_INTERFACE_TRANSPORT: {
                msg = new EncapsulatedInterfaceTransportRequest();
                break;
            }
            default: {
                msg = new IllegalFunctionRequest(functionCode);
            }
        }
        return msg;
    }

    private static class SingletonHolder {
        private static final ModbusRequestFactory instance = new ModbusRequestFactory();

        private SingletonHolder() {
        }
    }
}

