/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg;

import com.intelligt.modbus.jlibmodbus.msg.ModbusMessageFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.DiagnosticsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.GetCommEventCounterResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.GetCommEventLogResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.IllegalFunctionResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.MaskWriteRegisterResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadCoilsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadDiscreteInputsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadExceptionStatusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFifoQueueResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFileRecordResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadHoldingRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadInputRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReportSlaveIdResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteFileRecordResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteMultipleCoilsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteMultipleRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteSingleCoilResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteSingleRegisterResponse;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public final class ModbusResponseFactory
implements ModbusMessageFactory {
    private ModbusResponseFactory() {
    }

    public static ModbusResponseFactory getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public ModbusMessage createMessage(int functionCode) {
        ModbusResponse msg;
        switch (ModbusFunctionCode.get(functionCode)) {
            case READ_COILS: {
                msg = new ReadCoilsResponse();
                break;
            }
            case READ_DISCRETE_INPUTS: {
                msg = new ReadDiscreteInputsResponse();
                break;
            }
            case READ_HOLDING_REGISTERS: {
                msg = new ReadHoldingRegistersResponse();
                break;
            }
            case READ_INPUT_REGISTERS: {
                msg = new ReadInputRegistersResponse();
                break;
            }
            case WRITE_SINGLE_COIL: {
                msg = new WriteSingleCoilResponse();
                break;
            }
            case WRITE_SINGLE_REGISTER: {
                msg = new WriteSingleRegisterResponse();
                break;
            }
            case WRITE_MULTIPLE_COILS: {
                msg = new WriteMultipleCoilsResponse();
                break;
            }
            case WRITE_MULTIPLE_REGISTERS: {
                msg = new WriteMultipleRegistersResponse();
                break;
            }
            case MASK_WRITE_REGISTER: {
                msg = new MaskWriteRegisterResponse();
                break;
            }
            case READ_WRITE_MULTIPLE_REGISTERS: {
                msg = new ReadWriteMultipleRegistersResponse();
                break;
            }
            case READ_FIFO_QUEUE: {
                msg = new ReadFifoQueueResponse();
                break;
            }
            case READ_FILE_RECORD: {
                msg = new ReadFileRecordResponse();
                break;
            }
            case WRITE_FILE_RECORD: {
                msg = new WriteFileRecordResponse();
                break;
            }
            case READ_EXCEPTION_STATUS: {
                msg = new ReadExceptionStatusResponse();
                break;
            }
            case REPORT_SLAVE_ID: {
                msg = new ReportSlaveIdResponse();
                break;
            }
            case GET_COMM_EVENT_COUNTER: {
                msg = new GetCommEventCounterResponse();
                break;
            }
            case GET_COMM_EVENT_LOG: {
                msg = new GetCommEventLogResponse();
                break;
            }
            case DIAGNOSTICS: {
                msg = new DiagnosticsResponse();
                break;
            }
            case ENCAPSULATED_INTERFACE_TRANSPORT: {
                msg = new EncapsulatedInterfaceTransportResponse();
                break;
            }
            default: {
                msg = new IllegalFunctionResponse(functionCode);
            }
        }
        if (ModbusFunctionCode.isException(functionCode)) {
            msg.setException();
        }
        return msg;
    }

    private static class SingletonHolder {
        private static final ModbusResponseFactory instance = new ModbusResponseFactory();

        private SingletonHolder() {
        }
    }
}

