/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractDataRequest
extends ModbusRequest {
    private int startAddress;

    protected AbstractDataRequest() {
    }

    protected abstract void writeData(ModbusOutputStream var1) throws IOException;

    protected abstract void readData(ModbusInputStream var1) throws IOException, ModbusNumberException;

    @Override
    public final void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        this.setStartAddress(fifo.readShortBE());
        this.readData(fifo);
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getStartAddress());
        this.writeData(fifo);
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(int startAddress) throws ModbusNumberException {
        if (!Modbus.checkStartAddress(startAddress)) {
            throw new ModbusNumberException("Error in start address", startAddress);
        }
        this.startAddress = startAddress;
    }

    @Override
    public final int requestSize() {
        return 2 + this.dataSize();
    }

    protected abstract int dataSize();
}

