/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.MEIFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.ModbusEncapsulatedInterface;
import com.intelligt.modbus.jlibmodbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.MEITypeCode;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class EncapsulatedInterfaceTransportRequest
extends ModbusRequest {
    private ModbusEncapsulatedInterface mei = null;

    @Override
    protected Class getResponseClass() {
        return EncapsulatedInterfaceTransportResponse.class;
    }

    public void setMEIType(MEITypeCode meiTypeCode) {
        this.setMei(MEIFactory.getMEI(meiTypeCode));
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.mei.getTypeCode().toInt());
        this.mei.writeRequest(fifo);
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        int meiTypeCode = fifo.read();
        this.mei = MEIFactory.getMEI(MEITypeCode.get(meiTypeCode));
        if (this.mei == null) {
            throw new ModbusNumberException("Unknown MEI type", meiTypeCode);
        }
        this.mei.readRequest(fifo);
    }

    @Override
    public int requestSize() {
        return 1 + (this.mei == null ? 0 : this.mei.getRequestSize());
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        EncapsulatedInterfaceTransportResponse response = new EncapsulatedInterfaceTransportResponse();
        response.setServerAddress(this.getServerAddress());
        this.mei.process(dataHolder);
        response.setMei(this.mei);
        return response;
    }

    public ModbusEncapsulatedInterface getMei() {
        return this.mei;
    }

    public void setMei(ModbusEncapsulatedInterface mei) {
        this.mei = mei;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        return response instanceof EncapsulatedInterfaceTransportResponse && this.mei.getTypeCode() == ((EncapsulatedInterfaceTransportResponse)response).getMei().getTypeCode();
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.ENCAPSULATED_INTERFACE_TRANSPORT.toInt();
    }
}

