/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractDataRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFifoQueueResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadFifoQueueRequest
extends AbstractDataRequest {
    @Override
    protected Class getResponseClass() {
        return ReadFifoQueueResponse.class;
    }

    @Override
    protected void writeData(ModbusOutputStream fifo) throws IOException {
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
    }

    @Override
    protected int dataSize() {
        return 0;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadFifoQueueResponse response = new ReadFifoQueueResponse();
        response.setServerAddress(this.getServerAddress());
        try {
            int[] r = dataHolder.readFifoQueue(this.getStartAddress());
            response.setFifoValueRegister(r);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        return true;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_FIFO_QUEUE.toInt();
    }
}

