/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteFileRecordResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteFileRecordRequest
extends ModbusRequest {
    public static final int READ_SUB_REQ_LENGTH = 7;
    private ModbusFileRecord fileRecord = null;

    public ModbusFileRecord getFileRecord() {
        return this.fileRecord;
    }

    public void setFileRecord(ModbusFileRecord record) {
        this.fileRecord = record;
    }

    @Override
    protected Class getResponseClass() {
        return WriteFileRecordResponse.class;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        ModbusFileRecord record = this.getFileRecord();
        fifo.write(7 + record.getRecordLength() * 2);
        fifo.write(6);
        fifo.writeShortBE(record.getFileNumber());
        fifo.writeShortBE(record.getRecordNumber());
        fifo.writeShortBE(record.getRecordLength());
        fifo.write(DataUtils.toByteArray(record.getRegisters()));
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        if (fifo.read() != 6) {
            throw new ModbusNumberException("Reference type mismatch.");
        }
        int file_number = fifo.readShortBE();
        int record_number = fifo.readShortBE();
        int record_length = fifo.readShortBE();
        byte[] buffer = new byte[record_length * 2];
        if (fifo.read(buffer) != buffer.length) {
            throw new ModbusNumberException(record_length + " bytes expected, but not received.");
        }
        this.setFileRecord(new ModbusFileRecord(file_number, record_number, DataUtils.BeToIntArray(buffer)));
    }

    @Override
    public int requestSize() {
        return 1 + 7 * this.getFileRecord().getRecordLength() * 2;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteFileRecordResponse response = (WriteFileRecordResponse)this.getResponse();
        response.setFileRecord(this.getFileRecord());
        try {
            dataHolder.writeFileRecord(response.getFileRecord());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteFileRecordResponse)) {
            return false;
        }
        ModbusFileRecord reqRecord = this.getFileRecord();
        ModbusFileRecord respRecord = ((WriteFileRecordResponse)response).getFileRecord();
        return respRecord.getFileNumber() == reqRecord.getFileNumber() && respRecord.getRecordNumber() == reqRecord.getRecordNumber() && respRecord.getRecordLength() == reqRecord.getRecordLength();
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_FILE_RECORD.toInt();
    }
}

