/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractWriteMultipleRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteMultipleRegistersResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;

public final class WriteMultipleRegistersRequest
extends AbstractWriteMultipleRequest {
    @Override
    protected Class getResponseClass() {
        return WriteMultipleRegistersResponse.class;
    }

    @Override
    public void setByteCount(int byteCount) throws ModbusNumberException {
        if (byteCount % 2 != 0) {
            throw new ModbusNumberException("bytes.length=" + byteCount + " should be an even number");
        }
        super.setByteCount(byteCount);
        this.setQuantity(byteCount / 2);
    }

    @Override
    protected boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkWriteRegisterCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + quantity);
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteMultipleRegistersResponse response = (WriteMultipleRegistersResponse)this.getResponse();
        response.setStartAddress(this.getStartAddress());
        response.setQuantity(this.getQuantity());
        try {
            dataHolder.writeHoldingRegisterRange(this.getStartAddress(), this.getRegisters());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteMultipleRegistersResponse)) {
            return false;
        }
        WriteMultipleRegistersResponse r = (WriteMultipleRegistersResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getQuantity();
    }

    @Override
    public void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        if (this.getQuantity() * 2 != this.getByteCount()) {
            throw new ModbusNumberException("Byte count not matches quantity*2", this.getByteCount());
        }
        if (!this.checkAddressRange(this.getStartAddress(), this.getQuantity())) {
            throw new ModbusNumberException("Register count greater than max register count", this.getQuantity());
        }
    }

    public int[] getRegisters() {
        return DataUtils.BeToIntArray(this.getBytes());
    }

    public void setRegisters(int[] registers) throws ModbusNumberException {
        super.setBytes(DataUtils.toByteArray(registers));
        this.setByteCount(registers.length * 2);
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(super.getBytes(), super.getByteCount());
    }

    @Override
    public void setBytes(byte[] values) throws ModbusNumberException {
        super.setBytes(Arrays.copyOf(values, values.length));
        this.setByteCount(values.length);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_MULTIPLE_REGISTERS.toInt();
    }
}

