/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractDataRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteSingleRegisterResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class WriteSingleRegisterRequest
extends AbstractDataRequest {
    private int value;

    @Override
    protected Class getResponseClass() {
        return WriteSingleRegisterResponse.class;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteSingleRegisterResponse response = (WriteSingleRegisterResponse)this.getResponse();
        response.setStartAddress(this.getStartAddress());
        response.setValue(this.getValue());
        try {
            dataHolder.writeHoldingRegister(this.getStartAddress(), this.getValue());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteSingleRegisterResponse)) {
            return false;
        }
        WriteSingleRegisterResponse r = (WriteSingleRegisterResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getValue();
    }

    @Override
    protected final void readData(ModbusInputStream fifo) throws IOException {
        try {
            this.setValue(fifo.readShortBE());
        }
        catch (ModbusNumberException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_REGISTER.toInt();
    }

    @Override
    public final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getValue());
    }

    @Override
    protected int dataSize() {
        return 2;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) throws ModbusNumberException {
        if (!Modbus.checkRegisterValue(value)) {
            throw new ModbusNumberException("Register value out of range", value);
        }
        this.value = (short)value & 0xFFFF;
    }
}

