/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DiagnosticsSubFunctionCode;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class DiagnosticsResponse
extends ModbusResponse {
    private DiagnosticsSubFunctionCode subFunctionCode;
    private int subFunctionData = 0;

    @Override
    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setSubFunctionCode(DiagnosticsSubFunctionCode.get(fifo.readShortBE()));
        this.setSubFunctionData(fifo.readShortBE());
    }

    @Override
    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getSubFunctionCode().toInt());
        fifo.writeShortBE(this.getSubFunctionData());
    }

    @Override
    protected int responseSize() {
        return 4;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.DIAGNOSTICS.toInt();
    }

    public DiagnosticsSubFunctionCode getSubFunctionCode() {
        return this.subFunctionCode;
    }

    public void setSubFunctionCode(DiagnosticsSubFunctionCode subFunctionCode) {
        this.subFunctionCode = subFunctionCode;
    }

    public int getSubFunctionData() {
        return this.subFunctionData;
    }

    public void setSubFunctionData(int subFunctionData) {
        this.subFunctionData = subFunctionData;
    }
}

