/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.MEIFactory;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.ModbusEncapsulatedInterface;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.MEITypeCode;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class EncapsulatedInterfaceTransportResponse
extends ModbusResponse {
    private ModbusEncapsulatedInterface mei = null;

    @Override
    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int meiTypeCode = fifo.read();
        this.setMei(MEIFactory.getMEI(MEITypeCode.get(meiTypeCode)));
        if (this.getMei() == null) {
            throw new ModbusNumberException("Unknown MEI type", meiTypeCode);
        }
        this.getMei().readResponse(fifo);
    }

    @Override
    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getMei().getTypeCode().toInt());
        this.getMei().writeResponse(fifo);
    }

    public ModbusEncapsulatedInterface getMei() {
        return this.mei;
    }

    public void setMei(ModbusEncapsulatedInterface mei) {
        this.mei = mei;
    }

    @Override
    protected int responseSize() {
        return 1 + (this.mei == null ? 0 : this.mei.getResponseSize());
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.ENCAPSULATED_INTERFACE_TRANSPORT.toInt();
    }
}

