/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractReadResponse;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReadFileRecordResponse
extends AbstractReadResponse {
    public static final int READ_RESP_SUB_REQ_LENGTH = 2;
    private List<ModbusFileRecord> records = new ArrayList<ModbusFileRecord>();

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int record_byte_count;
        int response_byte_count = this.getByteCount();
        int i = 0;
        for (int read = 0; read < response_byte_count; read += record_byte_count) {
            byte[] buffer;
            record_byte_count = fifo.read() * 2;
            if (fifo.read() != 6) {
                throw new ModbusNumberException("Reference type mismatch.");
            }
            if (record_byte_count > response_byte_count - (read += 2)) {
                record_byte_count = response_byte_count - read;
            }
            if (fifo.read(buffer = new byte[record_byte_count]) != record_byte_count) {
                throw new ModbusNumberException(record_byte_count + " bytes expected, but not received.");
            }
            ModbusFileRecord mfr = new ModbusFileRecord(0, i++, DataUtils.BeToIntArray(buffer));
            this.records.add(mfr);
        }
        this.setFileRecords(this.records.toArray(new ModbusFileRecord[this.records.size()]));
    }

    @Override
    protected void writeData(ModbusOutputStream fifo) throws IOException {
        for (ModbusFileRecord r : this.getFileRecords()) {
            fifo.write(r.getRecordLength());
            fifo.write(6);
            fifo.write(DataUtils.toByteArray(r.getRegisters()));
        }
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_FILE_RECORD.toInt();
    }

    public ModbusFileRecord[] getFileRecords() {
        return (ModbusFileRecord[])this.records.toArray();
    }

    public void setFileRecords(ModbusFileRecord[] fileRecords) throws ModbusNumberException {
        this.records = Arrays.asList(fileRecords);
        int byteCount = 0;
        for (ModbusFileRecord r : this.getFileRecords()) {
            byteCount += 2 + r.getRecordLength() * 2;
        }
        this.setByteCount(byteCount);
    }
}

