/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingOutputStream;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransportFactory;
import com.intelligt.modbus.jlibmodbus.tcp.TcpParameters;
import com.intelligt.modbus.jlibmodbus.utils.TcpClientInfo;
import java.io.IOException;
import java.net.Socket;

public class ModbusSlaveConnectionTCP
extends ModbusConnection {
    private Socket socket;
    private ModbusTransport transport = null;
    private final TcpClientInfo clientInfo;

    ModbusSlaveConnectionTCP(Socket socket) throws ModbusIOException {
        try {
            this.socket = socket;
            this.transport = ModbusTransportFactory.createTCP(socket);
            this.clientInfo = new TcpClientInfo(new TcpParameters(socket.getInetAddress(), socket.getPort(), socket.getKeepAlive()), false);
            this.open();
        }
        catch (Exception e) {
            throw new ModbusIOException(e);
        }
    }

    @Override
    public LoggingOutputStream getOutputStream() {
        return this.transport.getOutputStream();
    }

    @Override
    public LoggingInputStream getInputStream() {
        return this.transport.getInputStream();
    }

    @Override
    public ModbusTransport getTransport() {
        return this.transport;
    }

    @Override
    protected void openImpl() throws ModbusIOException {
        this.clientInfo.setConnected(true);
    }

    @Override
    protected void closeImpl() throws ModbusIOException {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
        finally {
            this.transport = null;
            this.socket = null;
            this.clientInfo.setConnected(false);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public TcpClientInfo getClientInfo() {
        return this.clientInfo;
    }
}

