/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.util.List;

public abstract class SerialPortAbstractFactory {
    protected final String mainClassName;
    protected final String connectorName;

    protected SerialPortAbstractFactory(String mainClassName, String connectorName) {
        this.mainClassName = mainClassName;
        this.connectorName = connectorName;
    }

    public final String getUnavailableString() {
        return "The " + this.connectorName + " library is missing";
    }

    public final String getMainClassName() {
        return this.mainClassName;
    }

    abstract SerialPort createSerialImpl(SerialParameters var1) throws SerialPortException;

    abstract List<String> getPortIdentifiersImpl() throws SerialPortException;

    final SerialPort createSerial(SerialParameters sp) throws SerialPortException {
        this.checkLibrary();
        return this.createSerialImpl(sp);
    }

    final List<String> getPortIdentifiers() throws SerialPortException {
        this.checkLibrary();
        return this.getPortIdentifiersImpl();
    }

    String getVersion() {
        return "The version number is unavailable.";
    }

    public boolean available() {
        try {
            Class.forName(this.getMainClassName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected final void checkLibrary() throws SerialPortException {
        if (!this.available()) {
            throw new SerialPortException(this.getUnavailableString());
        }
    }
}

