/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.slave;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.net.ModbusSlaveConnectionTCP;
import com.intelligt.modbus.jlibmodbus.slave.ModbusSlave;
import com.intelligt.modbus.jlibmodbus.slave.RequestHandlerTCP;
import com.intelligt.modbus.jlibmodbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ModbusSlaveTCP
extends ModbusSlave
implements Runnable {
    private static final int DEFAULT_POOLS_SIZE = 10;
    private final ExecutorService threadPool;
    private final TcpParameters tcp;
    private Thread mainThread = null;
    private ServerSocket server = null;

    public ModbusSlaveTCP(TcpParameters tcp) {
        this(tcp, 10);
    }

    public ModbusSlaveTCP(TcpParameters tcp, int poolsSize) {
        this.tcp = new TcpParameters(tcp);
        this.threadPool = Executors.newFixedThreadPool(poolsSize);
    }

    @Override
    public synchronized void listenImpl() throws ModbusIOException {
        try {
            this.server = new ServerSocket(this.tcp.getPort());
            this.mainThread = new Thread(this);
            this.setListening(true);
            this.mainThread.start();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    @Override
    public synchronized void shutdownImpl() {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
        finally {
            this.server = null;
        }
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
        }
        try {
            if (this.mainThread != null) {
                this.mainThread.join(1000L);
                if (this.mainThread.isAlive()) {
                    this.mainThread.interrupt();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.mainThread = null;
        }
    }

    @Override
    void connectionOpened(ModbusConnection connection) {
        super.connectionOpened(connection);
        this.notifyObservers(((ModbusSlaveConnectionTCP)connection).getClientInfo());
    }

    @Override
    void connectionClosed(ModbusConnection connection) {
        super.connectionClosed(connection);
        this.notifyObservers(((ModbusSlaveConnectionTCP)connection).getClientInfo());
    }

    @Override
    public void run() {
        try {
            while (this.isListening()) {
                Socket s = this.server.accept();
                try {
                    this.threadPool.execute(new RequestHandlerTCP(this, s));
                }
                catch (ModbusIOException ioe) {
                    Modbus.log().warning(ioe.getLocalizedMessage());
                    s.close();
                }
            }
        }
        catch (SocketException e) {
            if (this.server != null && !this.server.isClosed()) {
                Modbus.log().warning(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            Modbus.log().warning(e.getLocalizedMessage());
            e.printStackTrace();
        }
        finally {
            if (this.isListening()) {
                try {
                    this.shutdown();
                }
                catch (ModbusIOException e) {
                    Modbus.log().warning(e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

