/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.intellij.uiDesigner.compiler.CodeGenerationException;
import com.intellij.uiDesigner.compiler.FormByteCodeGenerator;
import com.intellij.uiDesigner.lw.LwRootContainer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.Repository;

public final class CodeGenerator {
    public static final String SETUP_METHOD_NAME = "$$$setupUI$$$";
    private final LwRootContainer myRootContainer;
    private final ArrayList myErrors;
    private final ArrayList myWarnings;
    private final File myClassFile;
    private final ClassLoader myLoader;
    static /* synthetic */ Class class$org$apache$bcel$Repository;

    public CodeGenerator(LwRootContainer rootContainer, File classFile, ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        if (rootContainer == null) {
            throw new IllegalArgumentException("rootContainer cannot be null");
        }
        this.myRootContainer = rootContainer;
        this.myClassFile = classFile;
        this.myLoader = loader;
        this.myErrors = new ArrayList();
        this.myWarnings = new ArrayList();
    }

    public void patch() {
        JavaClass result;
        JavaClass javaClass;
        String classToBind = this.myRootContainer.getClassToBind();
        if (classToBind == null) {
            this.myWarnings.add("No class to bind specified");
            return;
        }
        if (!this.myClassFile.exists()) {
            this.myErrors.add("Class to bind does not exist: " + classToBind);
            return;
        }
        try {
            ClassParser classParser = new ClassParser(this.myClassFile.getPath());
            javaClass = classParser.parse();
            javaClass.setRepository(CodeGenerator.getActiveBCELRepository());
        }
        catch (IOException e) {
            this.myErrors.add("Cannot parse class file " + this.myClassFile.getPath() + ": " + e.toString());
            return;
        }
        catch (ClassFormatException e) {
            this.myErrors.add("Class format exception: " + e.getMessage() + " File: " + this.myClassFile.getPath());
            return;
        }
        catch (Exception e) {
            this.myErrors.add("Incorrect version of BCEL library: " + e.getMessage());
            return;
        }
        try {
            result = CodeGenerator.instrumentClass(javaClass, this.myRootContainer, this.myLoader);
        }
        catch (CodeGenerationException e) {
            this.myErrors.add(e.getMessage());
            return;
        }
        try {
            result.dump(this.myClassFile.getPath());
        }
        catch (Exception e) {
            this.myErrors.add(e.getMessage() != null ? e.getMessage() : null);
        }
    }

    public String[] getErrors() {
        return (String[])((Object[])this.myErrors.toArray(new String[this.myErrors.size()]));
    }

    public String[] getWarnings() {
        return (String[])((Object[])this.myWarnings.toArray(new String[this.myWarnings.size()]));
    }

    private static JavaClass instrumentClass(JavaClass javaClass, LwRootContainer rootContainer, ClassLoader loader) throws CodeGenerationException {
        String classToBind = javaClass.getClassName();
        int setupMethodPosition = -1;
        Method[] methods = javaClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (SETUP_METHOD_NAME.equals(method.getName())) {
                setupMethodPosition = i;
                break;
            }
            ++i;
        }
        ClassGen classGen = new ClassGen(javaClass);
        ConstantPoolGen constantPool = classGen.getConstantPool();
        InstructionFactory instructionFactory = new InstructionFactory(classGen);
        MethodGen setupMethodGen = new MethodGen(2, (Type)Type.VOID, Type.NO_ARGS, new String[0], SETUP_METHOD_NAME, classToBind, new InstructionList(), constantPool);
        FormByteCodeGenerator codeGenerator = new FormByteCodeGenerator(rootContainer, instructionFactory, setupMethodGen.getInstructionList(), constantPool, classToBind, 1, javaClass);
        codeGenerator.generate(loader);
        setupMethodGen.getInstructionList().append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        setupMethodGen.setMaxStack();
        setupMethodGen.setMaxLocals();
        if (setupMethodPosition != -1) {
            classGen.setMethodAt(setupMethodGen.getMethod(), setupMethodPosition);
        } else {
            classGen.addMethod(setupMethodGen.getMethod());
        }
        if (setupMethodPosition == -1) {
            Method[] methods2 = classGen.getMethods();
            int i2 = 0;
            while (i2 < methods2.length) {
                Method method = methods2[i2];
                if ("<init>".equals(method.getName())) {
                    MethodGen constructorGen = new MethodGen(method, javaClass.getClassName(), classGen.getConstantPool());
                    InstructionList constructorInstructions = constructorGen.getInstructionList();
                    InstructionHandle[] instructionHandles = constructorInstructions.getInstructionHandles();
                    int j = 0;
                    while (j < instructionHandles.length) {
                        InvokeInstruction invokeInstruction;
                        String className;
                        Instruction instruction = instructionHandles[j].getInstruction();
                        if (instruction instanceof InvokeInstruction && "invokespecial".equals(instruction.getName()) && ((className = (invokeInstruction = (InvokeInstruction)instruction).getClassName(classGen.getConstantPool())).equals(classToBind) || className.equals(classGen.getSuperclassName()))) {
                            if (className.equals(classToBind)) break;
                            InstructionList callSetupList = new InstructionList();
                            callSetupList.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
                            callSetupList.append((Instruction)instructionFactory.createInvoke(classToBind, SETUP_METHOD_NAME, (Type)Type.VOID, Type.NO_ARGS, (short)183));
                            constructorInstructions.append(instructionHandles[j], callSetupList);
                            constructorGen.setMaxStack();
                            constructorGen.setMaxLocals();
                            classGen.setMethodAt(constructorGen.getMethod(), i2);
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return classGen.getJavaClass();
    }

    public static Repository getActiveBCELRepository() throws Exception {
        Class aClass = class$org$apache$bcel$Repository == null ? (class$org$apache$bcel$Repository = CodeGenerator.class$("org.apache.bcel.Repository")) : class$org$apache$bcel$Repository;
        Field field = aClass.getDeclaredField("_repository");
        field.setAccessible(true);
        return (Repository)field.get(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

