/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import org.jdom.Element;

public final class LwXmlReader {
    public static Element getChild(Element element, String childName) {
        return element.getChild(childName, element.getNamespace());
    }

    public static Element getRequiredChild(Element element, String childName) {
        Element child = LwXmlReader.getChild(element, childName);
        if (child == null) {
            throw new IllegalArgumentException("subtag '" + childName + "' is required: " + element);
        }
        return child;
    }

    public static String getString(Element element, String attributeName) {
        String value = element.getAttributeValue(attributeName);
        return value != null ? value.trim() : null;
    }

    public static String getRequiredString(Element element, String attributeName) {
        String value = LwXmlReader.getString(element, attributeName);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("attribute '" + attributeName + "' is required: " + element);
    }

    public static int getRequiredInt(Element element, String attributeName) {
        String str = LwXmlReader.getRequiredString(element, attributeName);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("attribute '" + attributeName + "' is not a proper integer: " + str);
        }
    }

    public static boolean getOptionalBoolean(Element element, String attributeName, boolean defaultValue) {
        String str = element.getAttributeValue(attributeName);
        if (str == null) {
            return defaultValue;
        }
        return Boolean.valueOf(str);
    }

    public static double getRequiredDouble(Element element, String attributeName) {
        String str = LwXmlReader.getRequiredString(element, attributeName);
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("attribute '" + attributeName + "' is not a proper double: " + str);
        }
    }
}

