/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

public final class StringDescriptor {
    private final String myBundleName;
    private final String myKey;
    private final String myValue;
    private String myResolvedValue;

    private StringDescriptor(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.myBundleName = null;
        this.myKey = null;
        this.myValue = value;
    }

    public StringDescriptor(String bundleName, String key) {
        if (bundleName == null) {
            throw new IllegalArgumentException("bundleName cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.myBundleName = bundleName.replace('.', '/');
        this.myKey = key;
        this.myValue = null;
    }

    public static StringDescriptor create(String value) {
        return value != null ? new StringDescriptor(value) : null;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getBundleName() {
        return this.myBundleName;
    }

    public String getKey() {
        return this.myKey;
    }

    public String getResolvedValue() {
        return this.myResolvedValue;
    }

    public void setResolvedValue(String resolvedValue) {
        this.myResolvedValue = resolvedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringDescriptor)) {
            return false;
        }
        StringDescriptor descriptor = (StringDescriptor)o;
        boolean bl = this.myBundleName != null ? !this.myBundleName.equals(descriptor.myBundleName) : descriptor.myBundleName != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.myKey != null ? !this.myKey.equals(descriptor.myKey) : descriptor.myKey != null;
        if (bl2) {
            return false;
        }
        return !(this.myValue != null ? !this.myValue.equals(descriptor.myValue) : descriptor.myValue != null);
    }

    public int hashCode() {
        int result = this.myBundleName != null ? this.myBundleName.hashCode() : 0;
        result = 29 * result + (this.myKey != null ? this.myKey.hashCode() : 0);
        result = 29 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
        return result;
    }
}

