/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.compiler;

import com.intellij.uiDesigner.compiler.CodeGenerationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwRbIntroStringProperty;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.LwScrollPane;
import com.intellij.uiDesigner.lw.LwSplitPane;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.shared.BorderType;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

final class FormByteCodeGenerator {
    private final LwRootContainer myRootContainer;
    private final InstructionFactory myFactory;
    private final ConstantPoolGen myConstantPoolGen;
    private final String myClassToBind;
    private final JavaClass myClassBeingPatched;
    private int myTempVariableCount;
    private final HashMap myComponent2TempVariable;
    private final InstructionList myList;
    static /* synthetic */ Class class$com$intellij$uiDesigner$core$GridLayoutManager;
    static /* synthetic */ Class class$java$awt$Insets;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$LayoutManager;
    static /* synthetic */ Class class$com$intellij$uiDesigner$core$SupportCode;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$AbstractButton;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JScrollPane;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;
    static /* synthetic */ Class class$javax$swing$JSplitPane;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$swing$BorderFactory;
    static /* synthetic */ Class class$javax$swing$border$Border;
    static /* synthetic */ Class class$javax$swing$border$TitledBorder;
    static /* synthetic */ Class class$com$intellij$uiDesigner$core$GridConstraints;

    public FormByteCodeGenerator(LwRootContainer rootContainer, InstructionFactory instructionFactory, InstructionList instructionList, ConstantPoolGen constantPoolGen, String classToBind, int nextVariable, JavaClass classBeingPatched) {
        this.myRootContainer = rootContainer;
        this.myFactory = instructionFactory;
        this.myConstantPoolGen = constantPoolGen;
        this.myClassToBind = classToBind;
        this.myClassBeingPatched = classBeingPatched;
        this.myList = instructionList;
        this.myComponent2TempVariable = new HashMap();
        this.myTempVariableCount = nextVariable;
    }

    public void generate(ClassLoader loader) throws CodeGenerationException {
        if (this.myRootContainer.getComponentCount() != 1) {
            throw new CodeGenerationException("There should be only one component at the top level");
        }
        if (FormByteCodeGenerator.containsNotEmptyPanelsWithXYLayout((LwComponent)this.myRootContainer.getComponent(0))) {
            throw new CodeGenerationException("There are non empty panels with XY layout. Please lay them out in a grid.");
        }
        this.generateSetupCodeForComponent((LwComponent)this.myRootContainer.getComponent(0), loader);
    }

    private static boolean containsNotEmptyPanelsWithXYLayout(LwComponent component) {
        if (!(component instanceof LwContainer)) {
            return false;
        }
        LwContainer container = (LwContainer)component;
        if (container.getComponentCount() == 0) {
            return false;
        }
        if (container.isXY()) {
            return true;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (!FormByteCodeGenerator.containsNotEmptyPanelsWithXYLayout((LwComponent)container.getComponent(i))) continue;
            return true;
        }
        return false;
    }

    private static Class getComponentClass(LwComponent component, ClassLoader classLoader) throws CodeGenerationException {
        try {
            return Class.forName(component.getComponentClassName(), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException("Class not found: " + component.getComponentClassName());
        }
    }

    private void generateSetupCodeForComponent(LwComponent component, ClassLoader loader) throws CodeGenerationException {
        LwContainer parent = component.getParent();
        int variable = this.getTempVariable(component);
        Class componentClass = FormByteCodeGenerator.getComponentClass(component, loader);
        this.createNew(componentClass);
        this.dup();
        this.invokeInit(componentClass, Type.NO_ARGS);
        this.myList.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)variable));
        String binding = component.getBinding();
        if (binding != null) {
            Field field = this.findField(binding);
            if (field == null) {
                throw new CodeGenerationException("Cannot bind: field does not exist: " + this.myClassToBind + "." + binding);
            }
            if (field.isStatic()) {
                throw new CodeGenerationException("Cannot bind: field is static: " + this.myClassToBind + "." + binding);
            }
            if (field.isFinal()) {
                throw new CodeGenerationException("Cannot bind: field is final: " + this.myClassToBind + "." + binding);
            }
            JavaClass componentJavaClass = Repository.lookupClass((String)componentClass.getName());
            if (componentJavaClass == null) {
                throw new CodeGenerationException("Class not found: " + componentClass.getName());
            }
            Type fieldType = Type.getType((String)field.getSignature());
            if (!(fieldType instanceof ObjectType)) {
                throw new CodeGenerationException("Cannot bind: field is of primitive type: " + this.myClassToBind + "." + binding);
            }
            String fieldClassName = ((ObjectType)fieldType).getClassName();
            JavaClass fieldJavaClass = Repository.lookupClass((String)fieldClassName);
            if (fieldJavaClass == null) {
                throw new CodeGenerationException("Class not found: " + fieldClassName);
            }
            if (!Repository.instanceOf((JavaClass)componentJavaClass, (JavaClass)fieldJavaClass)) {
                throw new CodeGenerationException("Cannot bind: Incompatible types. Cannot assign " + componentClass.getName() + " to field " + this.myClassToBind + "." + binding);
            }
            this.load(0);
            this.load(variable);
            this.myList.append((Instruction)this.myFactory.createFieldAccess(this.myClassToBind, binding, fieldType, (short)181));
        }
        if (!(component instanceof LwScrollPane) && !(component instanceof LwTabbedPane) && !(component instanceof LwSplitPane) && component instanceof LwContainer) {
            LwContainer container = (LwContainer)component;
            if (container.isXY()) {
                if (container.getComponentCount() != 0) {
                    throw new IllegalStateException("only empty xys are accepted");
                }
            } else {
                this.load(variable);
                if (!container.isGrid()) {
                    if (container.isXY()) {
                        throw new IllegalArgumentException("XY is not supported");
                    }
                    throw new IllegalArgumentException("unknown layout: " + container.getLayout());
                }
                GridLayoutManager layout = (GridLayoutManager)container.getLayout();
                this.createNew(class$com$intellij$uiDesigner$core$GridLayoutManager == null ? (class$com$intellij$uiDesigner$core$GridLayoutManager = FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.GridLayoutManager")) : class$com$intellij$uiDesigner$core$GridLayoutManager);
                this.dup();
                this.push(layout.getRowCount());
                this.push(layout.getColumnCount());
                this.newInsets(layout.getMargin());
                this.push(layout.getHGap());
                this.push(layout.getVGap());
                this.push(layout.isSameSizeHorizontally());
                this.push(layout.isSameSizeVertically());
                this.invokeInit(class$com$intellij$uiDesigner$core$GridLayoutManager == null ? (class$com$intellij$uiDesigner$core$GridLayoutManager = FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.GridLayoutManager")) : class$com$intellij$uiDesigner$core$GridLayoutManager, new Type[]{Type.INT, Type.INT, new ObjectType((class$java$awt$Insets == null ? (class$java$awt$Insets = FormByteCodeGenerator.class$("java.awt.Insets")) : class$java$awt$Insets).getName()), Type.INT, Type.INT, Type.BOOLEAN, Type.BOOLEAN});
                this.invokeVoidVirtual(class$java$awt$Container == null ? (class$java$awt$Container = FormByteCodeGenerator.class$("java.awt.Container")) : class$java$awt$Container, "setLayout", new Class[]{class$java$awt$LayoutManager == null ? (class$java$awt$LayoutManager = FormByteCodeGenerator.class$("java.awt.LayoutManager")) : class$java$awt$LayoutManager});
            }
        }
        LwIntrospectedProperty[] introspectedProperties = component.getAssignedIntrospectedProperties();
        for (int i = 0; i < introspectedProperties.length; ++i) {
            String propertyClass;
            LwIntrospectedProperty property = introspectedProperties[i];
            this.load(variable);
            Object value = component.getPropertyValue(property);
            if (property instanceof LwRbIntroStringProperty) {
                StringDescriptor descriptor = (StringDescriptor)value;
                if (descriptor.getValue() == null) {
                    this.push(property.getWriteMethodName());
                    this.push(descriptor.getBundleName());
                    this.push(descriptor.getKey());
                    this.invokeVoidStatic(class$com$intellij$uiDesigner$core$SupportCode == null ? FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.SupportCode") : class$com$intellij$uiDesigner$core$SupportCode, "setTextFromBundle", new Type[]{new ObjectType((class$javax$swing$JComponent == null ? FormByteCodeGenerator.class$("javax.swing.JComponent") : class$javax$swing$JComponent).getName()), Type.STRING, Type.STRING, Type.STRING});
                    continue;
                }
                value = descriptor.getValue();
            }
            SupportCode.TextWithMnemonic textWithMnemonic = null;
            if ("text".equals(property.getName()) && ((class$javax$swing$AbstractButton == null ? FormByteCodeGenerator.class$("javax.swing.AbstractButton") : class$javax$swing$AbstractButton).isAssignableFrom(componentClass) || (class$javax$swing$JLabel == null ? FormByteCodeGenerator.class$("javax.swing.JLabel") : class$javax$swing$JLabel).isAssignableFrom(componentClass))) {
                textWithMnemonic = SupportCode.parseText((String)value);
                value = textWithMnemonic.myText;
            }
            if ((propertyClass = property.getPropertyClassName()).equals((class$java$awt$Dimension == null ? FormByteCodeGenerator.class$("java.awt.Dimension") : class$java$awt$Dimension).getName())) {
                this.newDimension((Dimension)value);
            } else if (propertyClass.equals((class$java$lang$Integer == null ? FormByteCodeGenerator.class$("java.lang.Integer") : class$java$lang$Integer).getName())) {
                this.push((Integer)value);
            } else if (propertyClass.equals((class$java$lang$Double == null ? FormByteCodeGenerator.class$("java.lang.Double") : class$java$lang$Double).getName())) {
                this.push((Double)value);
            } else if (propertyClass.equals((class$java$lang$Boolean == null ? FormByteCodeGenerator.class$("java.lang.Boolean") : class$java$lang$Boolean).getName())) {
                this.push((Boolean)value);
            } else if (propertyClass.equals((class$java$awt$Rectangle == null ? FormByteCodeGenerator.class$("java.awt.Rectangle") : class$java$awt$Rectangle).getName())) {
                this.newRectangle((Rectangle)value);
            } else if (propertyClass.equals((class$java$awt$Insets == null ? FormByteCodeGenerator.class$("java.awt.Insets") : class$java$awt$Insets).getName())) {
                this.newInsets((Insets)value);
            } else if (propertyClass.equals((class$java$lang$String == null ? FormByteCodeGenerator.class$("java.lang.String") : class$java$lang$String).getName())) {
                this.push((String)value);
            } else {
                throw new RuntimeException("unexpected property class: " + propertyClass);
            }
            Object type = propertyClass.equals((class$java$lang$Integer == null ? FormByteCodeGenerator.class$("java.lang.Integer") : class$java$lang$Integer).getName()) ? Type.INT : (propertyClass.equals((class$java$lang$Double == null ? FormByteCodeGenerator.class$("java.lang.Double") : class$java$lang$Double).getName()) ? Type.DOUBLE : (propertyClass.equals((class$java$lang$Boolean == null ? FormByteCodeGenerator.class$("java.lang.Boolean") : class$java$lang$Boolean).getName()) ? Type.BOOLEAN : new ObjectType(propertyClass)));
            this.invokeVoidVirtual(componentClass, property.getWriteMethodName(), new Type[]{type});
            if (textWithMnemonic == null || textWithMnemonic.myMnemonicIndex == -1) continue;
            if ((class$javax$swing$AbstractButton == null ? FormByteCodeGenerator.class$("javax.swing.AbstractButton") : class$javax$swing$AbstractButton).isAssignableFrom(componentClass)) {
                this.load(variable);
                this.push(textWithMnemonic.getMnemonicChar());
                this.invokeVoidVirtual(componentClass, "setMnemonic", new Type[]{Type.CHAR});
                this.load(variable);
                this.push(textWithMnemonic.myMnemonicIndex);
                this.myList.append((Instruction)this.myFactory.createInvoke((class$com$intellij$uiDesigner$core$SupportCode == null ? FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.SupportCode") : class$com$intellij$uiDesigner$core$SupportCode).getName(), "setDisplayedMnemonicIndex", (Type)Type.VOID, new Type[]{new ObjectType((class$javax$swing$JComponent == null ? FormByteCodeGenerator.class$("javax.swing.JComponent") : class$javax$swing$JComponent).getName()), Type.INT}, (short)184));
                continue;
            }
            if (!(class$javax$swing$JLabel == null ? FormByteCodeGenerator.class$("javax.swing.JLabel") : class$javax$swing$JLabel).isAssignableFrom(componentClass)) continue;
            this.load(variable);
            this.push(textWithMnemonic.getMnemonicChar());
            this.invokeVoidVirtual(componentClass, "setDisplayedMnemonic", new Type[]{Type.CHAR});
            this.load(variable);
            this.push(textWithMnemonic.myMnemonicIndex);
            this.myList.append((Instruction)this.myFactory.createInvoke((class$com$intellij$uiDesigner$core$SupportCode == null ? FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.SupportCode") : class$com$intellij$uiDesigner$core$SupportCode).getName(), "setDisplayedMnemonicIndex", (Type)Type.VOID, new Type[]{new ObjectType((class$javax$swing$JComponent == null ? FormByteCodeGenerator.class$("javax.swing.JComponent") : class$javax$swing$JComponent).getName()), Type.INT}, (short)184));
        }
        if (!(component.getParent() instanceof LwRootContainer)) {
            if (parent instanceof LwScrollPane) {
                this.load(this.getTempVariable(parent));
                this.load(variable);
                this.invokeVoidVirtual(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = FormByteCodeGenerator.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, "setViewportView", new Class[]{class$java$awt$Component == null ? (class$java$awt$Component = FormByteCodeGenerator.class$("java.awt.Component")) : class$java$awt$Component});
            } else if (parent instanceof LwTabbedPane) {
                this.load(this.getTempVariable(parent));
                LwTabbedPane.Constraints tabConstraints = (LwTabbedPane.Constraints)component.getCustomLayoutConstraints();
                if (tabConstraints == null) {
                    throw new IllegalArgumentException("tab constraints cannot be null: " + component.getId());
                }
                this.push(tabConstraints.myTitle);
                this.load(variable);
                this.invokeVoidVirtual(class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = FormByteCodeGenerator.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane, "addTab", new Class[]{class$java$lang$String == null ? (class$java$lang$String = FormByteCodeGenerator.class$("java.lang.String")) : class$java$lang$String, class$java$awt$Component == null ? (class$java$awt$Component = FormByteCodeGenerator.class$("java.awt.Component")) : class$java$awt$Component});
            } else if (parent instanceof LwSplitPane) {
                this.load(this.getTempVariable(parent));
                this.load(variable);
                if ("left".equals(component.getCustomLayoutConstraints())) {
                    this.invokeVoidVirtual(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = FormByteCodeGenerator.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, "setLeftComponent", new Class[]{class$java$awt$Component == null ? (class$java$awt$Component = FormByteCodeGenerator.class$("java.awt.Component")) : class$java$awt$Component});
                } else {
                    this.invokeVoidVirtual(class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = FormByteCodeGenerator.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane, "setRightComponent", new Class[]{class$java$awt$Component == null ? (class$java$awt$Component = FormByteCodeGenerator.class$("java.awt.Component")) : class$java$awt$Component});
                }
            } else {
                this.load(this.getTempVariable(parent));
                this.load(variable);
                this.addNewGridConstraints(component);
                this.invokeVoidVirtual(class$java$awt$Container == null ? (class$java$awt$Container = FormByteCodeGenerator.class$("java.awt.Container")) : class$java$awt$Container, "add", new Class[]{class$java$awt$Component == null ? (class$java$awt$Component = FormByteCodeGenerator.class$("java.awt.Component")) : class$java$awt$Component, class$java$lang$Object == null ? (class$java$lang$Object = FormByteCodeGenerator.class$("java.lang.Object")) : class$java$lang$Object});
            }
        }
        if (component instanceof LwContainer) {
            LwContainer container = (LwContainer)component;
            BorderType borderType = container.getBorderType();
            StringDescriptor borderTitle = container.getBorderTitle();
            String borderFactoryMethodName = borderType.getBorderFactoryMethodName();
            boolean borderNone = borderType.equals(BorderType.NONE);
            if (!borderNone || borderTitle != null) {
                this.load(variable);
                if (!borderNone) {
                    this.myList.append((Instruction)this.myFactory.createInvoke((class$javax$swing$BorderFactory == null ? (class$javax$swing$BorderFactory = FormByteCodeGenerator.class$("javax.swing.BorderFactory")) : class$javax$swing$BorderFactory).getName(), borderFactoryMethodName, (Type)new ObjectType((class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = FormByteCodeGenerator.class$("javax.swing.border.Border")) : class$javax$swing$border$Border).getName()), Type.NO_ARGS, (short)184));
                    this.push(borderTitle);
                    this.myList.append((Instruction)this.myFactory.createInvoke((class$javax$swing$BorderFactory == null ? (class$javax$swing$BorderFactory = FormByteCodeGenerator.class$("javax.swing.BorderFactory")) : class$javax$swing$BorderFactory).getName(), "createTitledBorder", (Type)new ObjectType((class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = FormByteCodeGenerator.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder).getName()), new Type[]{new ObjectType((class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = FormByteCodeGenerator.class$("javax.swing.border.Border")) : class$javax$swing$border$Border).getName()), new ObjectType((class$java$lang$String == null ? (class$java$lang$String = FormByteCodeGenerator.class$("java.lang.String")) : class$java$lang$String).getName())}, (short)184));
                } else {
                    this.push(borderTitle);
                    this.myList.append((Instruction)this.myFactory.createInvoke((class$javax$swing$BorderFactory == null ? (class$javax$swing$BorderFactory = FormByteCodeGenerator.class$("javax.swing.BorderFactory")) : class$javax$swing$BorderFactory).getName(), "createTitledBorder", (Type)new ObjectType((class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = FormByteCodeGenerator.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder).getName()), new Type[]{new ObjectType((class$java$lang$String == null ? (class$java$lang$String = FormByteCodeGenerator.class$("java.lang.String")) : class$java$lang$String).getName())}, (short)184));
                }
                this.invokeVoidVirtual(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = FormByteCodeGenerator.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, "setBorder", new Class[]{class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = FormByteCodeGenerator.class$("javax.swing.border.Border")) : class$javax$swing$border$Border});
            }
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.generateSetupCodeForComponent((LwComponent)container.getComponent(i), loader);
            }
        }
    }

    private int getTempVariable(LwComponent component) {
        if (this.myComponent2TempVariable.containsKey(component)) {
            return (Integer)this.myComponent2TempVariable.get(component);
        }
        int result = ++this.myTempVariableCount;
        this.myComponent2TempVariable.put(component, new Integer(result));
        return result;
    }

    private void addNewGridConstraints(LwComponent component) {
        GridConstraints constraints = component.getConstraints();
        this.createNew(class$com$intellij$uiDesigner$core$GridConstraints == null ? (class$com$intellij$uiDesigner$core$GridConstraints = FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.GridConstraints")) : class$com$intellij$uiDesigner$core$GridConstraints);
        this.dup();
        this.push(constraints.getRow());
        this.push(constraints.getColumn());
        this.push(constraints.getRowSpan());
        this.push(constraints.getColSpan());
        this.push(constraints.getAnchor());
        this.push(constraints.getFill());
        this.push(constraints.getHSizePolicy());
        this.push(constraints.getVSizePolicy());
        this.newDimensionOrNull(constraints.myMinimumSize);
        this.newDimensionOrNull(constraints.myPreferredSize);
        this.newDimensionOrNull(constraints.myMaximumSize);
        ObjectType dimensionType = new ObjectType((class$java$awt$Dimension == null ? (class$java$awt$Dimension = FormByteCodeGenerator.class$("java.awt.Dimension")) : class$java$awt$Dimension).getName());
        this.invokeInit(class$com$intellij$uiDesigner$core$GridConstraints == null ? (class$com$intellij$uiDesigner$core$GridConstraints = FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.GridConstraints")) : class$com$intellij$uiDesigner$core$GridConstraints, new Type[]{Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, Type.INT, dimensionType, dimensionType, dimensionType});
    }

    private void newDimensionOrNull(Dimension dimension) {
        if (dimension.width == -1 && dimension.height == -1) {
            this.pushNull();
        } else {
            this.newDimension(dimension);
        }
    }

    private void pushNull() {
        this.myList.append((Instruction)new ACONST_NULL());
    }

    private void newDimension(Dimension dimension) {
        this.createNew(class$java$awt$Dimension == null ? (class$java$awt$Dimension = FormByteCodeGenerator.class$("java.awt.Dimension")) : class$java$awt$Dimension);
        this.dup();
        this.push(dimension.width);
        this.push(dimension.height);
        this.invokeInit(class$java$awt$Dimension == null ? (class$java$awt$Dimension = FormByteCodeGenerator.class$("java.awt.Dimension")) : class$java$awt$Dimension, new Type[]{Type.INT, Type.INT});
    }

    private void newInsets(Insets insets) {
        this.createNew(class$java$awt$Insets == null ? (class$java$awt$Insets = FormByteCodeGenerator.class$("java.awt.Insets")) : class$java$awt$Insets);
        this.dup();
        this.push(insets.top);
        this.push(insets.left);
        this.push(insets.bottom);
        this.push(insets.right);
        this.invokeInit(class$java$awt$Insets == null ? (class$java$awt$Insets = FormByteCodeGenerator.class$("java.awt.Insets")) : class$java$awt$Insets, new Type[]{Type.INT, Type.INT, Type.INT, Type.INT});
    }

    private void newRectangle(Rectangle rectangle) {
        this.createNew(class$java$awt$Insets == null ? (class$java$awt$Insets = FormByteCodeGenerator.class$("java.awt.Insets")) : class$java$awt$Insets);
        this.dup();
        this.push(rectangle.x);
        this.push(rectangle.y);
        this.push(rectangle.width);
        this.push(rectangle.height);
        this.invokeInit(class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = FormByteCodeGenerator.class$("java.awt.Rectangle")) : class$java$awt$Rectangle, new Type[]{Type.INT, Type.INT, Type.INT, Type.INT});
    }

    private void push(int value) {
        this.myList.append((CompoundInstruction)new PUSH(this.myConstantPoolGen, value));
    }

    private void push(double value) {
        this.myList.append((CompoundInstruction)new PUSH(this.myConstantPoolGen, value));
    }

    private void push(char value) {
        this.myList.append((CompoundInstruction)new PUSH(this.myConstantPoolGen, (int)value));
    }

    private void push(boolean value) {
        this.myList.append((CompoundInstruction)new PUSH(this.myConstantPoolGen, value));
    }

    private void push(String value) {
        this.myList.append((CompoundInstruction)new PUSH(this.myConstantPoolGen, value));
    }

    private void push(StringDescriptor descriptor) {
        if (descriptor == null) {
            this.pushNull();
        } else if (descriptor.getValue() != null) {
            this.push(descriptor.getValue());
        } else {
            this.push(descriptor.getBundleName());
            this.push(descriptor.getKey());
            this.myList.append((Instruction)this.myFactory.createInvoke((class$com$intellij$uiDesigner$core$SupportCode == null ? (class$com$intellij$uiDesigner$core$SupportCode = FormByteCodeGenerator.class$("com.intellij.uiDesigner.core.SupportCode")) : class$com$intellij$uiDesigner$core$SupportCode).getName(), "getResourceString", (Type)Type.STRING, new Type[]{Type.STRING, Type.STRING}, (short)184));
        }
    }

    private void dup() {
        this.myList.append((Instruction)InstructionConstants.DUP);
    }

    private void load(int variable) {
        this.myList.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)variable));
    }

    private void invokeVoidVirtual(Class aClass, String methodName, Class[] parameters) {
        Type[] types = new Type[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = new ObjectType(parameters[i].getName());
        }
        this.invokeVoidVirtual(aClass, methodName, types);
    }

    private void invokeVoidVirtual(Class aClass, String methodName, Type[] types) {
        this.myList.append((Instruction)this.myFactory.createInvoke(aClass.getName(), methodName, (Type)Type.VOID, types, (short)182));
    }

    private void invokeVoidStatic(Class aClass, String methodName, Type[] types) {
        this.myList.append((Instruction)this.myFactory.createInvoke(aClass.getName(), methodName, (Type)Type.VOID, types, (short)184));
    }

    private void createNew(Class aClass) {
        this.myList.append((Instruction)this.myFactory.createNew(aClass.getName()));
    }

    private void invokeInit(Class aClass, Type[] parameters) {
        this.myList.append((Instruction)this.myFactory.createInvoke(aClass.getName(), "<init>", (Type)Type.VOID, parameters, (short)183));
    }

    private Field findField(String fieldName) {
        return FormByteCodeGenerator.findField(this.myClassBeingPatched, fieldName);
    }

    private static Field findField(JavaClass aClass, String fieldName) {
        Field[] fields = aClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

