/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.core;

import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.DimensionInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.HorizontalInfo;
import com.intellij.uiDesigner.core.LayoutState;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.core.VerticalInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;

public final class GridLayoutManager
extends AbstractLayout {
    private int myMinCellSize = 20;
    private final int[] myRowStretches;
    private final int[] myColumnStretches;
    private final int[] myYs;
    private final int[] myHeights;
    private final int[] myXs;
    private final int[] myWidths;
    private LayoutState myLayoutState;
    DimensionInfo myHorizontalInfo;
    DimensionInfo myVerticalInfo;
    private boolean mySameSizeHorizontally;
    private boolean mySameSizeVertically;

    public GridLayoutManager(int rowCount, int columnCount) {
        int i;
        if (columnCount < 1) {
            throw new IllegalArgumentException("wrong columnCount: " + columnCount);
        }
        if (rowCount < 1) {
            throw new IllegalArgumentException("wrong rowCount: " + rowCount);
        }
        this.myRowStretches = new int[rowCount];
        for (i = 0; i < rowCount; ++i) {
            this.myRowStretches[i] = 1;
        }
        this.myColumnStretches = new int[columnCount];
        for (i = 0; i < columnCount; ++i) {
            this.myColumnStretches[i] = 1;
        }
        this.myXs = new int[columnCount];
        this.myWidths = new int[columnCount];
        this.myYs = new int[rowCount];
        this.myHeights = new int[rowCount];
    }

    public GridLayoutManager(int rowCount, int columnCount, Insets margin, int hGap, int vGap) {
        this(rowCount, columnCount);
        this.setMargin(margin);
        this.setHGap(hGap);
        this.setVGap(vGap);
        this.myMinCellSize = 0;
    }

    public GridLayoutManager(int rowCount, int columnCount, Insets margin, int hGap, int vGap, boolean sameSizeHorizontally, boolean sameSizeVertically) {
        this(rowCount, columnCount, margin, hGap, vGap);
        this.mySameSizeHorizontally = sameSizeHorizontally;
        this.mySameSizeVertically = sameSizeVertically;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        GridConstraints c = (GridConstraints)constraints;
        int row = c.getRow();
        int rowSpan = c.getRowSpan();
        int rowCount = this.getRowCount();
        if (row < 0 || row >= rowCount) {
            throw new IllegalArgumentException("wrong row: " + row);
        }
        if (row + rowSpan - 1 >= rowCount) {
            throw new IllegalArgumentException("wrong row span: " + rowSpan + "; row=" + row + " rowCount=" + rowCount);
        }
        int column = c.getColumn();
        int colSpan = c.getColSpan();
        int columnCount = this.getColumnCount();
        if (column < 0 || column >= columnCount) {
            throw new IllegalArgumentException("wrong column: " + column);
        }
        if (column + colSpan - 1 >= columnCount) {
            throw new IllegalArgumentException("wrong col span: " + colSpan + "; column=" + column + " columnCount=" + columnCount);
        }
        super.addLayoutComponent(comp, constraints);
    }

    public int getRowCount() {
        return this.myRowStretches.length;
    }

    public int getColumnCount() {
        return this.myColumnStretches.length;
    }

    public int getRowStretch(int rowIndex) {
        return this.myRowStretches[rowIndex];
    }

    public void setRowStretch(int rowIndex, int stretch) {
        if (stretch < 1) {
            throw new IllegalArgumentException("wrong stretch: " + stretch);
        }
        this.myRowStretches[rowIndex] = stretch;
    }

    public int getColumnStretch(int columnIndex) {
        return this.myColumnStretches[columnIndex];
    }

    public void setColumnStretch(int columnIndex, int stretch) {
        if (stretch < 1) {
            throw new IllegalArgumentException("wrong stretch: " + stretch);
        }
        this.myColumnStretches[columnIndex] = stretch;
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.validateInfos(container);
        DimensionInfo horizontalInfo = this.myHorizontalInfo;
        DimensionInfo verticalInfo = this.myVerticalInfo;
        Dimension result = this.getTotalGap(container, horizontalInfo, verticalInfo);
        int[] widths = this.getMinSizes(horizontalInfo);
        if (this.mySameSizeHorizontally) {
            this.makeSameSizes(widths);
        }
        result.width += GridLayoutManager.sum(widths);
        int[] heights = this.getMinSizes(verticalInfo);
        if (this.mySameSizeVertically) {
            this.makeSameSizes(heights);
        }
        result.height += GridLayoutManager.sum(heights);
        return result;
    }

    private void makeSameSizes(int[] widths) {
        int i;
        int max = widths[0];
        for (i = 0; i < widths.length; ++i) {
            int width = widths[i];
            max = Math.max(width, max);
        }
        for (i = 0; i < widths.length; ++i) {
            widths[i] = max;
        }
    }

    private int[] getSameSizes(DimensionInfo info, int totalWidth) {
        int[] widths = new int[info.getCellCount()];
        int average = totalWidth / widths.length;
        int rest = totalWidth % widths.length;
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = average;
            if (rest <= 0) continue;
            int n = i;
            widths[n] = widths[n] + 1;
            --rest;
        }
        return widths;
    }

    public Dimension preferredLayoutSize(Container container) {
        this.validateInfos(container);
        DimensionInfo horizontalInfo = this.myHorizontalInfo;
        DimensionInfo verticalInfo = this.myVerticalInfo;
        Dimension result = this.getTotalGap(container, horizontalInfo, verticalInfo);
        int[] widths = this.getPrefSizes(horizontalInfo);
        if (this.mySameSizeHorizontally) {
            this.makeSameSizes(widths);
        }
        result.width += GridLayoutManager.sum(widths);
        int[] heights = this.getPrefSizes(verticalInfo);
        if (this.mySameSizeVertically) {
            this.makeSameSizes(heights);
        }
        result.height += GridLayoutManager.sum(heights);
        return result;
    }

    private static int sum(int[] ints) {
        int result = 0;
        for (int i = ints.length - 1; i >= 0; --i) {
            result += ints[i];
        }
        return result;
    }

    private Dimension getTotalGap(Container container, DimensionInfo hInfo, DimensionInfo vInfo) {
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + GridLayoutManager.countGap(hInfo, 0, hInfo.getCellCount()) + this.myMargin.left + this.myMargin.right, insets.top + insets.bottom + GridLayoutManager.countGap(vInfo, 0, vInfo.getCellCount()) + this.myMargin.top + this.myMargin.bottom);
    }

    private static int countGap(DimensionInfo info, int startCell, int cellCount) {
        int counter = 0;
        for (int cellIndex = startCell + cellCount - 2; cellIndex >= startCell; --cellIndex) {
            if (!GridLayoutManager.shouldAddGapAfterCell(info, cellIndex)) continue;
            ++counter;
        }
        return counter * info.getGap();
    }

    private static boolean shouldAddGapAfterCell(DimensionInfo info, int cellIndex) {
        int i;
        if (cellIndex < 0 || cellIndex >= info.getCellCount()) {
            throw new IllegalArgumentException("wrong cellIndex: " + cellIndex + "; cellCount=" + info.getCellCount());
        }
        boolean endsInThis = false;
        boolean startsInNext = false;
        int indexOfNextNotEmpty = -1;
        for (i = cellIndex + 1; i < info.getCellCount(); ++i) {
            if (GridLayoutManager.isCellEmpty(info, i)) continue;
            indexOfNextNotEmpty = i;
            break;
        }
        for (i = 0; i < info.getComponentCount(); ++i) {
            Component component = info.getComponent(i);
            if (component instanceof Spacer) continue;
            if (info.getCell(i) == indexOfNextNotEmpty) {
                startsInNext = true;
            }
            if (info.getCell(i) + info.getSpan(i) - 1 != cellIndex) continue;
            endsInThis = true;
        }
        return startsInNext && endsInThis;
    }

    private static boolean isCellEmpty(DimensionInfo info, int cellIndex) {
        if (cellIndex < 0 || cellIndex >= info.getCellCount()) {
            throw new IllegalArgumentException("wrong cellIndex: " + cellIndex + "; cellCount=" + info.getCellCount());
        }
        for (int i = 0; i < info.getComponentCount(); ++i) {
            Component component = info.getComponent(i);
            if (info.getCell(i) != cellIndex || component instanceof Spacer) continue;
            return false;
        }
        return true;
    }

    public void layoutContainer(Container container) {
        int i;
        int[] widths;
        int[] heights;
        this.validateInfos(container);
        LayoutState layoutState = this.myLayoutState;
        DimensionInfo horizontalInfo = this.myHorizontalInfo;
        DimensionInfo verticalInfo = this.myVerticalInfo;
        Dimension gap = this.getTotalGap(container, horizontalInfo, verticalInfo);
        Dimension size = container.getSize();
        size.width -= gap.width;
        size.height -= gap.height;
        Dimension prefSize = this.preferredLayoutSize(container);
        prefSize.width -= gap.width;
        prefSize.height -= gap.height;
        Dimension minSize = this.minimumLayoutSize(container);
        minSize.width -= gap.width;
        minSize.height -= gap.height;
        if (this.mySameSizeVertically) {
            heights = this.getSameSizes(verticalInfo, Math.max(size.height, minSize.height));
        } else if (size.height < prefSize.height) {
            heights = this.getMinSizes(verticalInfo);
            this.new_doIt(heights, 0, verticalInfo.getCellCount(), size.height, verticalInfo, true);
        } else {
            heights = this.getPrefSizes(verticalInfo);
            this.new_doIt(heights, 0, verticalInfo.getCellCount(), size.height, verticalInfo, false);
        }
        Insets insets = container.getInsets();
        int y = insets.top + this.myMargin.top;
        for (int i2 = 0; i2 < heights.length; ++i2) {
            this.myYs[i2] = y;
            this.myHeights[i2] = heights[i2];
            y += heights[i2];
            if (!GridLayoutManager.shouldAddGapAfterCell(verticalInfo, i2)) continue;
            y += verticalInfo.getGap();
        }
        if (this.mySameSizeHorizontally) {
            widths = this.getSameSizes(horizontalInfo, Math.max(size.width, minSize.width));
        } else if (size.width < prefSize.width) {
            widths = this.getMinSizes(horizontalInfo);
            this.new_doIt(widths, 0, horizontalInfo.getCellCount(), size.width, horizontalInfo, true);
        } else {
            widths = this.getPrefSizes(horizontalInfo);
            this.new_doIt(widths, 0, horizontalInfo.getCellCount(), size.width, horizontalInfo, false);
        }
        int x = insets.left + this.myMargin.left;
        for (i = 0; i < widths.length; ++i) {
            this.myXs[i] = x;
            this.myWidths[i] = widths[i];
            x += widths[i];
            if (!GridLayoutManager.shouldAddGapAfterCell(horizontalInfo, i)) continue;
            x += horizontalInfo.getGap();
        }
        for (i = 0; i < layoutState.getComponentCount(); ++i) {
            GridConstraints c = layoutState.getConstraints(i);
            Component component = layoutState.getComponent(i);
            int column = horizontalInfo.getCell(i);
            int colSpan = horizontalInfo.getSpan(i);
            int row = verticalInfo.getCell(i);
            int rowSpan = verticalInfo.getSpan(i);
            int cellWidth = this.myXs[column + colSpan - 1] + this.myWidths[column + colSpan - 1] - this.myXs[column];
            int cellHeight = this.myYs[row + rowSpan - 1] + this.myHeights[row + rowSpan - 1] - this.myYs[row];
            Dimension componentSize = new Dimension(cellWidth, cellHeight);
            if ((c.getFill() & 1) == 0) {
                componentSize.width = Math.min(componentSize.width, horizontalInfo.getPreferredWidth(i));
            }
            if ((c.getFill() & 2) == 0) {
                componentSize.height = Math.min(componentSize.height, verticalInfo.getPreferredWidth(i));
            }
            Util.adjustSize(component, c, componentSize);
            int dx = 0;
            int dy = 0;
            if ((c.getAnchor() & 4) != 0) {
                dx = cellWidth - componentSize.width;
            } else if ((c.getAnchor() & 8) == 0) {
                dx = (cellWidth - componentSize.width) / 2;
            }
            if ((c.getAnchor() & 2) != 0) {
                dy = cellHeight - componentSize.height;
            } else if ((c.getAnchor() & 1) == 0) {
                dy = (cellHeight - componentSize.height) / 2;
            }
            component.setBounds(this.myXs[column] + dx, this.myYs[row] + dy, componentSize.width, componentSize.height);
        }
    }

    public void invalidateLayout(Container container) {
        this.myLayoutState = null;
        this.myHorizontalInfo = null;
        this.myVerticalInfo = null;
    }

    private void validateInfos(Container container) {
        if (this.myLayoutState == null) {
            this.myLayoutState = new LayoutState(this, true);
            this.myHorizontalInfo = new HorizontalInfo(this.myLayoutState, GridLayoutManager.getHGapImpl(container));
            this.myVerticalInfo = new VerticalInfo(this.myLayoutState, GridLayoutManager.getVGapImpl(container));
        }
    }

    public int[] getXs() {
        return this.myXs;
    }

    public int[] getWidths() {
        return this.myWidths;
    }

    public int[] getYs() {
        return this.myYs;
    }

    public int[] getHeights() {
        return this.myHeights;
    }

    public int getRowAt(int y) {
        for (int i = 0; i < this.myYs.length; ++i) {
            if (this.myYs[i] > y || y > this.myYs[i] + this.myHeights[i]) continue;
            return i;
        }
        return -1;
    }

    public int getColumnAt(int x) {
        for (int i = 0; i < this.myXs.length; ++i) {
            if (this.myXs[i] > x || x > this.myXs[i] + this.myWidths[i]) continue;
            return i;
        }
        return -1;
    }

    private int[] getMinSizes(DimensionInfo info) {
        return this.getMinOrPrefSizes(info, true);
    }

    private int[] getPrefSizes(DimensionInfo info) {
        return this.getMinOrPrefSizes(info, false);
    }

    private int[] getMinOrPrefSizes(DimensionInfo info, boolean min) {
        int i;
        int[] widths = new int[info.getCellCount()];
        for (i = 0; i < widths.length; ++i) {
            widths[i] = this.myMinCellSize;
        }
        for (i = info.getComponentCount() - 1; i >= 0; --i) {
            if (info.getSpan(i) != 1) continue;
            int size = min ? GridLayoutManager.getMin2(info, i) : Math.max(info.getMinimumWidth(i), info.getPreferredWidth(i));
            int gap = GridLayoutManager.countGap(info, info.getCell(i), info.getSpan(i));
            size = Math.max(size - gap, 0);
            widths[info.getCell((int)i)] = Math.max(widths[info.getCell(i)], size);
        }
        boolean[] toProcess = new boolean[info.getCellCount()];
        for (int i2 = info.getComponentCount() - 1; i2 >= 0; --i2) {
            int size = min ? GridLayoutManager.getMin2(info, i2) : Math.max(info.getMinimumWidth(i2), info.getPreferredWidth(i2));
            int span = info.getSpan(i2);
            int cell = info.getCell(i2);
            int gap = GridLayoutManager.countGap(info, cell, span);
            size = Math.max(size - gap, 0);
            Arrays.fill(toProcess, false);
            int curSize = 0;
            for (int j = 0; j < span; ++j) {
                curSize += widths[j + cell];
                toProcess[j + cell] = true;
            }
            if (curSize >= size) continue;
            boolean[] higherPriorityCells = new boolean[toProcess.length];
            this.getCellsWithHigherPriorities(info, toProcess, higherPriorityCells, false, widths);
            GridLayoutManager.distribute(higherPriorityCells, info, size - curSize, widths);
        }
        return widths;
    }

    private static int getMin2(DimensionInfo info, int componentIndex) {
        int s = (info.getSizePolicy(componentIndex) & 1) != 0 ? info.getMinimumWidth(componentIndex) : Math.max(info.getMinimumWidth(componentIndex), info.getPreferredWidth(componentIndex));
        return s;
    }

    private void new_doIt(int[] widths, int cell, int span, int minWidth, DimensionInfo info, boolean checkPrefs) {
        int toDistribute = minWidth;
        for (int i = cell; i < cell + span; ++i) {
            toDistribute -= widths[i];
        }
        if (toDistribute <= 0) {
            return;
        }
        boolean[] allowedCells = new boolean[info.getCellCount()];
        for (int i = cell; i < cell + span; ++i) {
            allowedCells[i] = true;
        }
        boolean[] higherPriorityCells = new boolean[info.getCellCount()];
        this.getCellsWithHigherPriorities(info, allowedCells, higherPriorityCells, checkPrefs, widths);
        GridLayoutManager.distribute(higherPriorityCells, info, toDistribute, widths);
    }

    private static void distribute(boolean[] higherPriorityCells, DimensionInfo info, int toDistribute, int[] widths) {
        int i;
        int stretches = 0;
        for (i = 0; i < info.getCellCount(); ++i) {
            if (!higherPriorityCells[i]) continue;
            stretches += info.getStretch(i);
        }
        int toDistributeFrozen = toDistribute;
        for (int i2 = 0; i2 < info.getCellCount(); ++i2) {
            if (!higherPriorityCells[i2]) continue;
            int addon = toDistributeFrozen * info.getStretch(i2) / stretches;
            int n = i2;
            widths[n] = widths[n] + addon;
            toDistribute -= addon;
        }
        if (toDistribute != 0) {
            for (i = 0; i < info.getCellCount(); ++i) {
                if (!higherPriorityCells[i]) continue;
                int n = i;
                widths[n] = widths[n] + 1;
                if (--toDistribute == 0) break;
            }
        }
        if (toDistribute != 0) {
            throw new IllegalStateException("toDistribute = " + toDistribute);
        }
    }

    private void getCellsWithHigherPriorities(DimensionInfo info, boolean[] allowedCells, boolean[] higherPriorityCells, boolean checkPrefs, int[] widths) {
        int cell;
        Arrays.fill(higherPriorityCells, false);
        int foundCells = 0;
        if (checkPrefs) {
            int[] prefs = this.getMinOrPrefSizes(info, false);
            for (int cell2 = 0; cell2 < allowedCells.length; ++cell2) {
                if (!allowedCells[cell2] || GridLayoutManager.isCellEmpty(info, cell2) || prefs[cell2] <= widths[cell2]) continue;
                higherPriorityCells[cell2] = true;
                ++foundCells;
            }
            if (foundCells > 0) {
                return;
            }
        }
        for (cell = 0; cell < allowedCells.length; ++cell) {
            if (!allowedCells[cell] || (info.getCellSizePolicy(cell) & 4) == 0) continue;
            higherPriorityCells[cell] = true;
            ++foundCells;
        }
        if (foundCells > 0) {
            return;
        }
        for (cell = 0; cell < allowedCells.length; ++cell) {
            if (!allowedCells[cell] || (info.getCellSizePolicy(cell) & 2) == 0) continue;
            higherPriorityCells[cell] = true;
            ++foundCells;
        }
        if (foundCells > 0) {
            return;
        }
        for (cell = 0; cell < allowedCells.length; ++cell) {
            if (!allowedCells[cell] || GridLayoutManager.isCellEmpty(info, cell)) continue;
            higherPriorityCells[cell] = true;
            ++foundCells;
        }
        if (foundCells > 0) {
            return;
        }
        for (cell = 0; cell < allowedCells.length; ++cell) {
            if (!allowedCells[cell]) continue;
            higherPriorityCells[cell] = true;
        }
    }

    public boolean isSameSizeHorizontally() {
        return this.mySameSizeHorizontally;
    }

    public boolean isSameSizeVertically() {
        return this.mySameSizeVertically;
    }

    public void setSameSizeHorizontally(boolean sameSizeHorizontally) {
        this.mySameSizeHorizontally = sameSizeHorizontally;
    }

    public void setSameSizeVertically(boolean sameSizeVertically) {
        this.mySameSizeVertically = sameSizeVertically;
    }
}

