/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.ant;

import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.CodeGenerator;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;

public final class Javac2
extends Javac {
    private ArrayList myFormFiles;
    static /* synthetic */ Class class$org$apache$bcel$Repository;
    static /* synthetic */ Class class$org$apache$bcel$util$SyntheticRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compile() {
        super.compile();
        ArrayList formsToInstrument = this.myFormFiles;
        if (formsToInstrument.size() == 0) {
            this.log("No forms to instrument found", 3);
            return;
        }
        StringBuffer classPathBuffer = new StringBuffer();
        classPathBuffer.append(this.getDestdir().getAbsolutePath());
        Path classpath = this.getClasspath();
        String[] pathElements = classpath.list();
        for (int i = 0; i < pathElements.length; ++i) {
            String pathElement = pathElements[i];
            classPathBuffer.append(File.pathSeparator);
            classPathBuffer.append(pathElement);
        }
        classPathBuffer.append(File.pathSeparator);
        classPathBuffer.append(ClassPath.getClassPath());
        String classPath = classPathBuffer.toString();
        this.log("classpath=" + classPath, 3);
        try {
            URLClassLoader loader;
            Javac2.initBcel(new ClassPath(classPath));
            try {
                loader = Javac2.createClassLoader(classPath);
            }
            catch (MalformedURLException e) {
                this.fireError(e.getMessage());
                Javac2.disposeBcel();
                return;
            }
            HashMap<String, File> class2form = new HashMap<String, File>();
            for (int i = 0; i < formsToInstrument.size(); ++i) {
                LwRootContainer rootContainer;
                String formFileContent;
                File formFile = (File)formsToInstrument.get(i);
                this.log("compiling form " + formFile.getAbsolutePath(), 3);
                byte[] bytes = new byte[(int)formFile.length()];
                try {
                    FileInputStream fileReader = new FileInputStream(formFile);
                    fileReader.read(bytes);
                    fileReader.close();
                }
                catch (IOException e) {
                    this.fireError(e.getMessage());
                    continue;
                }
                try {
                    formFileContent = new String(bytes, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    this.fireError(e.getMessage());
                    continue;
                }
                try {
                    rootContainer = Utils.getRootContainer(formFileContent, new CompiledClassPropertiesProvider(loader));
                }
                catch (AlienFormFileException e) {
                    continue;
                }
                catch (Exception e) {
                    this.fireError("Cannot process form file " + formFile.getAbsolutePath() + ". Reason: " + e);
                    continue;
                }
                String classToBind = rootContainer.getClassToBind();
                if (classToBind == null) continue;
                String name = classToBind.replace('.', '/');
                File classFile = this.getClassFile(name);
                if (classFile == null) {
                    this.log(formFile.getAbsolutePath() + ": Class to bind does not exist: " + classToBind, 1);
                    continue;
                }
                File alreadyProcessedForm = (File)class2form.get(classToBind);
                if (alreadyProcessedForm != null) {
                    this.fireError(formFile.getAbsolutePath() + ": " + "The form is bound to the class " + classToBind + ".\n" + "Another form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class.");
                    continue;
                }
                class2form.put(classToBind, formFile);
                CodeGenerator codeGenerator = new CodeGenerator(rootContainer, classFile, loader);
                codeGenerator.patch();
                String[] warnings = codeGenerator.getWarnings();
                for (int j = 0; j < warnings.length; ++j) {
                    this.log(formFile.getAbsolutePath() + ": " + warnings[j], 1);
                }
                String[] errors = codeGenerator.getErrors();
                if (errors.length <= 0) continue;
                StringBuffer message = new StringBuffer();
                for (int j = 0; j < errors.length; ++j) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(formFile.getAbsolutePath()).append(": ").append(errors[j]);
                }
                this.fireError(message.toString());
            }
        }
        finally {
            Javac2.disposeBcel();
        }
    }

    private void fireError(String message) {
        if (this.failOnError) {
            throw new BuildException(message, this.getLocation());
        }
        this.log(message, 0);
    }

    private File getClassFile(String className) {
        File classFile = new File(this.getDestdir().getAbsolutePath(), className + ".class");
        if (classFile.exists()) {
            return classFile;
        }
        int position = className.lastIndexOf(47);
        if (position == -1) {
            return null;
        }
        return this.getClassFile(className.substring(0, position) + '$' + className.substring(position + 1));
    }

    private static URLClassLoader createClassLoader(String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            urls.add(new File(s).toURL());
        }
        URL[] urlsArr = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlsArr, null);
    }

    protected void resetFileLists() {
        super.resetFileLists();
        this.myFormFiles = new ArrayList();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        super.scanDir(srcDir, destDir, files);
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith(".form")) continue;
            this.log("Found form file " + file, 3);
            this.myFormFiles.add(new File(srcDir, file));
        }
    }

    private static void initBcel(ClassPath cp) {
        Class aClass = class$org$apache$bcel$Repository == null ? (class$org$apache$bcel$Repository = Javac2.class$("org.apache.bcel.Repository")) : class$org$apache$bcel$Repository;
        try {
            Field field = aClass.getDeclaredField("_repository");
            field.setAccessible(true);
            Repository currentRepository = (Repository)field.get(null);
            if (currentRepository instanceof SyntheticRepository) {
                ((SyntheticRepository)currentRepository).clear();
            }
            field.set(null, SyntheticRepository.getInstance((ClassPath)cp));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void disposeBcel() {
        Field field;
        org.apache.bcel.Repository.clearCache();
        try {
            field = (class$org$apache$bcel$util$SyntheticRepository == null ? (class$org$apache$bcel$util$SyntheticRepository = Javac2.class$("org.apache.bcel.util.SyntheticRepository")) : class$org$apache$bcel$util$SyntheticRepository).getDeclaredField("_instances");
            field.setAccessible(true);
            Map cpToRepositoryMap = (Map)field.get(null);
            Iterator it = cpToRepositoryMap.values().iterator();
            while (it.hasNext()) {
                SyntheticRepository repository = (SyntheticRepository)it.next();
                if (repository == null) continue;
                repository.clear();
            }
            cpToRepositoryMap.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            field = (class$org$apache$bcel$Repository == null ? (class$org$apache$bcel$Repository = Javac2.class$("org.apache.bcel.Repository")) : class$org$apache$bcel$Repository).getDeclaredField("_repository");
            field.setAccessible(true);
            field.set(null, SyntheticRepository.getInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while disposing BCEL: " + e.getClass() + " : " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

