/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.LwAtomicComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwHSpacer;
import com.intellij.uiDesigner.lw.LwScrollPane;
import com.intellij.uiDesigner.lw.LwSplitPane;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.LwVSpacer;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.shared.BorderType;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class LwContainer
extends LwComponent
implements IContainer {
    private final ArrayList myComponents = new ArrayList();
    private BorderType myBorderType;
    private StringDescriptor myBorderTitle;
    private AbstractLayout myLayout;
    static /* synthetic */ Class class$javax$swing$JPanel;

    public LwContainer(String className) {
        super(className);
        this.setBorderType(BorderType.NONE);
        this.myLayout = this.createInitialLayout();
    }

    protected AbstractLayout createInitialLayout() {
        return new XYLayoutManager();
    }

    public final AbstractLayout getLayout() {
        return this.myLayout;
    }

    public final void setLayout(AbstractLayout layout) {
        this.myLayout = layout;
    }

    public final boolean isGrid() {
        return this.getLayout() instanceof GridLayoutManager;
    }

    public final boolean isXY() {
        return this.getLayout() instanceof XYLayoutManager;
    }

    public final void addComponent(LwComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        if (this.myComponents.contains(component)) {
            throw new IllegalArgumentException("component is already added: " + component);
        }
        if (component.getParent() != null) {
            throw new IllegalArgumentException("component already added to another container");
        }
        this.myComponents.add(component);
        component.setParent(this);
    }

    public final IComponent getComponent(int index) {
        return (IComponent)this.myComponents.get(index);
    }

    public final int getComponentCount() {
        return this.myComponents.size();
    }

    public final BorderType getBorderType() {
        return this.myBorderType;
    }

    public final void setBorderType(BorderType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.myBorderType = type;
    }

    public final StringDescriptor getBorderTitle() {
        return this.myBorderTitle;
    }

    public final void setBorderTitle(StringDescriptor title) {
        this.myBorderTitle = title;
    }

    protected void readConstraintsForChild(Element element, LwComponent component) {
        Element constraintsElement = LwXmlReader.getRequiredChild(element, "constraints");
        Element xyElement = LwXmlReader.getChild(constraintsElement, "xy");
        if (xyElement != null) {
            component.setBounds(new Rectangle(LwXmlReader.getRequiredInt(xyElement, "x"), LwXmlReader.getRequiredInt(xyElement, "y"), LwXmlReader.getRequiredInt(xyElement, "width"), LwXmlReader.getRequiredInt(xyElement, "height")));
        }
        GridConstraints constraints = new GridConstraints();
        Element gridElement = LwXmlReader.getChild(constraintsElement, "grid");
        if (gridElement != null) {
            Element maxSizeElement;
            Element prefSizeElement;
            constraints.setRow(LwXmlReader.getRequiredInt(gridElement, "row"));
            constraints.setColumn(LwXmlReader.getRequiredInt(gridElement, "column"));
            constraints.setRowSpan(LwXmlReader.getRequiredInt(gridElement, "row-span"));
            constraints.setColSpan(LwXmlReader.getRequiredInt(gridElement, "col-span"));
            constraints.setVSizePolicy(LwXmlReader.getRequiredInt(gridElement, "vsize-policy"));
            constraints.setHSizePolicy(LwXmlReader.getRequiredInt(gridElement, "hsize-policy"));
            constraints.setAnchor(LwXmlReader.getRequiredInt(gridElement, "anchor"));
            constraints.setFill(LwXmlReader.getRequiredInt(gridElement, "fill"));
            Element minSizeElement = LwXmlReader.getChild(gridElement, "minimum-size");
            if (minSizeElement != null) {
                constraints.myMinimumSize.width = LwXmlReader.getRequiredInt(minSizeElement, "width");
                constraints.myMinimumSize.height = LwXmlReader.getRequiredInt(minSizeElement, "height");
            }
            if ((prefSizeElement = LwXmlReader.getChild(gridElement, "preferred-size")) != null) {
                constraints.myPreferredSize.width = LwXmlReader.getRequiredInt(prefSizeElement, "width");
                constraints.myPreferredSize.height = LwXmlReader.getRequiredInt(prefSizeElement, "height");
            }
            if ((maxSizeElement = LwXmlReader.getChild(gridElement, "maximum-size")) != null) {
                constraints.myMaximumSize.width = LwXmlReader.getRequiredInt(maxSizeElement, "width");
                constraints.myMaximumSize.height = LwXmlReader.getRequiredInt(maxSizeElement, "height");
            }
            component.getConstraints().restore(constraints);
        }
    }

    protected final void readBorder(Element element) {
        Element borderElement = LwXmlReader.getRequiredChild(element, "border");
        this.setBorderType(BorderType.valueOf(LwXmlReader.getRequiredString(borderElement, "type")));
        StringDescriptor descriptor = LwXmlReader.getStringDescriptor(borderElement, "title", "title-resource-bundle", "title-key");
        if (descriptor != null) {
            this.setBorderTitle(descriptor);
        }
    }

    protected final void readChildren(Element element, PropertiesProvider provider) throws Exception {
        Element childrenElement = LwXmlReader.getRequiredChild(element, "children");
        this.readChildrenImpl(childrenElement, provider);
    }

    protected final void readChildrenImpl(Element element, PropertiesProvider provider) throws Exception {
        Iterator i = element.getChildren().iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            LwComponent component = LwContainer.createComponentFromTag(child);
            this.addComponent(component);
            component.read(child, provider);
        }
    }

    public static LwComponent createComponentFromTag(Element child) throws Exception {
        LwComponent component;
        String name = child.getName();
        if ("component".equals(name)) {
            String className = LwXmlReader.getRequiredString(child, "class");
            component = new LwAtomicComponent(className);
        } else if ("vspacer".equals(name)) {
            component = new LwVSpacer();
        } else if ("hspacer".equals(name)) {
            component = new LwHSpacer();
        } else if ("xy".equals(name) || "grid".equals(name)) {
            component = new LwContainer((class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = LwContainer.class$("javax.swing.JPanel")) : class$javax$swing$JPanel).getName());
        } else if ("scrollpane".equals(name)) {
            component = new LwScrollPane();
        } else if ("tabbedpane".equals(name)) {
            component = new LwTabbedPane();
        } else if ("splitpane".equals(name)) {
            component = new LwSplitPane();
        } else {
            throw new IllegalArgumentException("unexpected element: " + child);
        }
        return component;
    }

    protected final void readLayout(Element element) {
        if ("xy".equals(element.getName())) {
            this.setLayout(new XYLayoutManager());
        } else if ("grid".equals(element.getName())) {
            int rowCount = LwXmlReader.getRequiredInt(element, "row-count");
            int columnCount = LwXmlReader.getRequiredInt(element, "column-count");
            int hGap = LwXmlReader.getRequiredInt(element, "hgap");
            int vGap = LwXmlReader.getRequiredInt(element, "vgap");
            boolean sameSizeHorizontally = LwXmlReader.getOptionalBoolean(element, "same-size-horizontally", false);
            boolean sameSizeVertically = LwXmlReader.getOptionalBoolean(element, "same-size-vertically", false);
            Element marginElement = LwXmlReader.getRequiredChild(element, "margin");
            Insets margin = new Insets(LwXmlReader.getRequiredInt(marginElement, "top"), LwXmlReader.getRequiredInt(marginElement, "left"), LwXmlReader.getRequiredInt(marginElement, "bottom"), LwXmlReader.getRequiredInt(marginElement, "right"));
            GridLayoutManager layout = new GridLayoutManager(rowCount, columnCount);
            layout.setMargin(margin);
            layout.setVGap(vGap);
            layout.setHGap(hGap);
            layout.setSameSizeHorizontally(sameSizeHorizontally);
            layout.setSameSizeVertically(sameSizeVertically);
            this.setLayout(layout);
        } else {
            throw new IllegalArgumentException("unexpected element: " + element);
        }
    }

    public void read(Element element, PropertiesProvider provider) throws Exception {
        this.readId(element);
        this.readBinding(element);
        this.readLayout(element);
        this.readConstraints(element);
        this.readProperties(element, provider);
        this.readBorder(element);
        this.readChildren(element, provider);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

